/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.api.loadbalance.McmpLoadBalanceNameSetService;
import com.tydic.mcmp.intf.api.loadbalance.McmpLoadBalanceSetProtectionService;
import com.tydic.mcmp.intf.api.loadbalance.bo.McmpLoadBalanceNameSetReqBo;
import com.tydic.mcmp.intf.api.loadbalance.bo.McmpLoadBalanceSetProtectionReqBo;
import com.tydic.mcmp.intf.base.McmpIntfRspBaseBO;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.busi.api.RsLoadBalanceModifyBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsLoadBalanceModifyBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsLoadBalanceModifyBusiRspBo;
import com.tydic.mcmp.resource.dao.RsInfoPlatformAcountMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.RsInfoSlbMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoResourcePo;
import com.tydic.mcmp.resource.dao.po.RsInfoSlbPo;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="rsLoadBalanceModifyBusiService")
public class RsLoadBalanceModifyBusiServiceImpl
implements RsLoadBalanceModifyBusiService {
    private static final Logger log = LoggerFactory.getLogger(RsLoadBalanceModifyBusiServiceImpl.class);
    private static final Integer SET_DELETE_PROTECTION = 2;
    @Autowired
    private McmpLoadBalanceNameSetService mcmpLoadBalanceNameSetService;
    @Autowired
    private McmpLoadBalanceSetProtectionService mcmpLoadBalanceSetProtectionService;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;
    @Autowired
    private RsInfoPlatformAcountMapper rsInfoPlatformAcountMapper;
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    @Autowired
    private RsInfoSlbMapper rsInfoSlbMapper;

    public RsLoadBalanceModifyBusiRspBo updateSlbBaseInfo(RsLoadBalanceModifyBusiReqBo reqBo) {
        log.info("\u8d1f\u8f7d\u5747\u8861\u5b9e\u4f8b\u57fa\u672c\u4fe1\u606f\u4fee\u6539busi\u670d\u52a1\uff0c\u5165\u53c2\uff1a" + reqBo);
        RsLoadBalanceModifyBusiRspBo retBo = new RsLoadBalanceModifyBusiRspBo();
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        if (2L == reqBo.getPlatformId() && SET_DELETE_PROTECTION.equals(reqBo.getAction())) {
            throw new McmpBusinessException("9000", "\u4ec5\u652f\u6301\u963f\u91cc\u516c\u6709\u4e91\u4fee\u6539\u5b9e\u4f8b\u7684\u5220\u9664\u4fdd\u62a4\u72b6\u6001");
        }
        if (SET_DELETE_PROTECTION.equals(reqBo.getAction()) && StringUtils.isEmpty((Object)reqBo.getDeleteProtection())) {
            throw new McmpBusinessException("9000", "\u8bbe\u7f6e\u5b9e\u4f8b\u5220\u9664\u4fdd\u62a4\u72b6\u6001\u65f6\uff08deleteProtection\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RsInfoResourcePo resourcePo = this.rsInfoResourceMapper.selectByPrimaryKey(reqBo.getResourceId());
        if (resourcePo == null) {
            throw new McmpBusinessException("9000", "\u6ca1\u6709\u67e5\u8be2\u5230\u8d44\u6e90\uff08" + reqBo.getResourceId() + "\uff09\u7684\u4fe1\u606f");
        }
        RsQueryAliParamAtomReqBo atomReqBo = new RsQueryAliParamAtomReqBo();
        atomReqBo.setAccountId(reqBo.getAccountId());
        atomReqBo.setPlatformId(reqBo.getPlatformId());
        RsQueryAliParamAtomRspBo atomRetBo = this.rsQueryAliParamAtomService.queryAliParam(atomReqBo);
        if (!"0000".equals(atomRetBo.getRespCode())) {
            throw new McmpBusinessException("9000", "\u83b7\u53d6\u7528\u6237\u53c2\u6570\u5931\u8d25\uff1a" + atomRetBo.getRespDesc());
        }
        if (SET_DELETE_PROTECTION.equals(reqBo.getAction())) {
            McmpIntfRspBaseBO interfaceRetBo = this.setSlbInsProtectionStatus(reqBo, resourcePo, atomRetBo);
            log.info("\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a" + interfaceRetBo);
            if (!"0000".equals(interfaceRetBo.getRespCode())) {
                throw new McmpBusinessException("9000", "\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u8bbe\u7f6e\u5b9e\u4f8b\u5220\u9664\u4fdd\u62a4\u72b6\u6001\u5931\u8d25\uff1a" + interfaceRetBo.getRespDesc());
            }
            return retBo;
        }
        McmpIntfRspBaseBO interfaceRetBo = this.setSlbInsName(reqBo, resourcePo, atomRetBo);
        log.info("\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a" + interfaceRetBo);
        if (!"0000".equals(interfaceRetBo.getRespCode())) {
            throw new McmpBusinessException("9000", "\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u4fee\u6539\u5b9e\u4f8b\u540d\u79f0\u5931\u8d25\uff1a" + interfaceRetBo.getRespDesc());
        }
        Date nowTime = this.rsInfoPlatformAcountMapper.getDbDate();
        RsInfoSlbPo slbPo = new RsInfoSlbPo();
        slbPo.setResourceId(reqBo.getResourceId());
        slbPo.setInstanceName(reqBo.getResourceName());
        int result = this.rsInfoSlbMapper.updateByPrimaryKeySelective(slbPo);
        if (result < 1) {
            throw new McmpBusinessException("9000", "\u4fee\u6539\u8d1f\u8f7d\u5747\u8861\u4fe1\u606f\u8868\u8bb0\u5f55\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
        RsInfoResourcePo resUpdatePo = new RsInfoResourcePo();
        BeanUtils.copyProperties((Object)reqBo, (Object)resUpdatePo);
        resUpdatePo.setUpdateTime(nowTime);
        result = this.rsInfoResourceMapper.updateByPrimaryKeySelective(resUpdatePo);
        if (result < 1) {
            throw new McmpBusinessException("9000", "\u4fee\u6539\u8d44\u6e90\u4fe1\u606f\u8868\u8bb0\u5f55\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
        return retBo;
    }

    private McmpIntfRspBaseBO setSlbInsProtectionStatus(RsLoadBalanceModifyBusiReqBo reqBo, RsInfoResourcePo resourcePo, RsQueryAliParamAtomRspBo atomRetBo) {
        log.info("\u672c\u6b21\u6267\u884c\u7684\u64cd\u4f5c\u4e3a\uff1a\u4fee\u6539\u963f\u91cc\u516c\u6709\u4e91\u8d1f\u8f7d\u5747\u8861\u5b9e\u4f8b\u5220\u9664\u4fdd\u62a4\u72b6\u6001");
        McmpLoadBalanceSetProtectionReqBo invokeReqBo = new McmpLoadBalanceSetProtectionReqBo();
        if (2L == reqBo.getPlatformId()) {
            invokeReqBo.setAccessKeyId(atomRetBo.getAccessKeyId());
            invokeReqBo.setAccessKeySecret(atomRetBo.getAccessKeySecret());
            invokeReqBo.setEndpointPriv(atomRetBo.getEndpoint());
            invokeReqBo.setProxyHost(atomRetBo.getProxyHost());
            invokeReqBo.setProxyPort(atomRetBo.getProxyPort());
        } else {
            invokeReqBo.setAccessKeyId(atomRetBo.getAccessKeyId());
            invokeReqBo.setAccessKeySecret(atomRetBo.getAccessKeySecret());
            invokeReqBo.setRegion(atomRetBo.getAccountRegionId());
        }
        invokeReqBo.setRegion(resourcePo.getRegionId());
        invokeReqBo.setCloudType(RsInterfaceUtil.convertCloudType(reqBo.getPlatformId()));
        invokeReqBo.setLoadBalancerId(resourcePo.getInstanceId());
        invokeReqBo.setDeleteProtection(reqBo.getDeleteProtection());
        log.info("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u7684\u53c2\u6570\u4e3a\uff1a" + JSON.toJSONString((Object)invokeReqBo));
        return this.mcmpLoadBalanceSetProtectionService.setInsProtection(invokeReqBo);
    }

    private McmpIntfRspBaseBO setSlbInsName(RsLoadBalanceModifyBusiReqBo reqBo, RsInfoResourcePo resourcePo, RsQueryAliParamAtomRspBo atomRetBo) {
        log.info("\u672c\u6b21\u6267\u884c\u7684\u64cd\u4f5c\u4e3a\uff1a\u4fee\u6539\u8d1f\u8f7d\u5747\u8861\u5b9e\u4f8b\u540d\u79f0");
        McmpLoadBalanceNameSetReqBo invokeReqBo = new McmpLoadBalanceNameSetReqBo();
        if (2L == reqBo.getPlatformId()) {
            invokeReqBo.setAccessKeyId(atomRetBo.getAccessKeyId());
            invokeReqBo.setAccessKeySecret(atomRetBo.getAccessKeySecret());
            invokeReqBo.setEndpointPriv(atomRetBo.getEndpoint());
            invokeReqBo.setProxyHost(atomRetBo.getProxyHost());
            invokeReqBo.setProxyPort(atomRetBo.getProxyPort());
        } else {
            invokeReqBo.setAccessKeyId(atomRetBo.getAccessKeyId());
            invokeReqBo.setAccessKeySecret(atomRetBo.getAccessKeySecret());
            invokeReqBo.setRegion(atomRetBo.getAccountRegionId());
        }
        invokeReqBo.setRegion(resourcePo.getRegionId());
        invokeReqBo.setCloudType(RsInterfaceUtil.convertCloudType(reqBo.getPlatformId()));
        invokeReqBo.setLoadBalancerId(resourcePo.getInstanceId());
        invokeReqBo.setLoadBalancerName(reqBo.getResourceName());
        log.info("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u7684\u53c2\u6570\u4e3a\uff1a" + JSON.toJSONString((Object)invokeReqBo));
        return this.mcmpLoadBalanceNameSetService.setInsName(invokeReqBo);
    }
}

