/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.mcmp.cloud.common.base.bo.McmpRspPageBo;
import com.tydic.mcmp.cloud.common.base.bo.McmpRspPageDataBo;
import com.tydic.mcmp.resource.atom.api.RsDicMapQueryAtomService;
import com.tydic.mcmp.resource.atom.bo.RsDicMapQueryAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsDicMapQueryAtomRspBo;
import com.tydic.mcmp.resource.busi.api.RsLoadBalancePageQueryBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsLoadBalancePageQueryBusiServiceReqBo;
import com.tydic.mcmp.resource.common.bo.RsLoadBalanceQueryDataBo;
import com.tydic.mcmp.resource.dao.RsInfoAliSlbSpecMapper;
import com.tydic.mcmp.resource.dao.RsInfoSlbMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoAliSlbSpecPo;
import com.tydic.mcmp.resource.dao.po.RsInfoSlbQueryPo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="rsLoadBalancePageQueryBusiService")
public class RsLoadBalancePageQueryBusiServiceImpl
implements RsLoadBalancePageQueryBusiService {
    private static final Logger log = LoggerFactory.getLogger(RsLoadBalancePageQueryBusiServiceImpl.class);
    @Autowired
    private RsInfoSlbMapper rsInfoSlbMapper;
    @Autowired
    private RsInfoAliSlbSpecMapper rsInfoAliSlbSpecMapper;
    @Autowired
    private RsDicMapQueryAtomService rsDicMapQueryAtomService;

    public McmpRspPageBo<McmpRspPageDataBo<RsLoadBalanceQueryDataBo>> qryLoadBalances(RsLoadBalancePageQueryBusiServiceReqBo reqBo) {
        log.info("\u8d1f\u8f7d\u5747\u8861\u5b9e\u4f8b\u5206\u9875\u67e5\u8be2busi\u670d\u52a1\uff0c \u5165\u53c2\uff1a" + reqBo);
        McmpRspPageBo retBo = new McmpRspPageBo();
        McmpRspPageDataBo retData = new McmpRspPageDataBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)retData);
        ArrayList<RsLoadBalanceQueryDataBo> retRows = new ArrayList<RsLoadBalanceQueryDataBo>();
        retData.setRows(retRows);
        retBo.setData((Object)retData);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        Page<RsInfoSlbQueryPo> page = this.getPage(reqBo);
        RsInfoSlbQueryPo qryPo = new RsInfoSlbQueryPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)qryPo);
        List<RsInfoSlbQueryPo> slbPos = this.rsInfoSlbMapper.selectPage(qryPo, page);
        if (CollectionUtils.isEmpty(slbPos)) {
            log.info("\u8d1f\u8f7d\u5747\u8861\u5b9e\u4f8b\u4fe1\u606f\u67e5\u8be2\u4e3a\u7a7a");
            return retBo;
        }
        Map<String, Map<String, String>> dicMap = this.getDicMap();
        HashMap<String, String> slbSpecMap = new HashMap<String, String>(16);
        RsInfoAliSlbSpecPo slbSpecReqPo = new RsInfoAliSlbSpecPo();
        List<RsInfoAliSlbSpecPo> slbSpecPos = this.rsInfoAliSlbSpecMapper.selectByCondition(slbSpecReqPo);
        for (RsInfoAliSlbSpecPo slbSpecPo : slbSpecPos) {
            slbSpecMap.put(slbSpecPo.getLoadBalanceSpec(), slbSpecPo.getLoadBalanceName());
        }
        for (RsInfoSlbQueryPo slbPo : slbPos) {
            RsLoadBalanceQueryDataBo dataBo = new RsLoadBalanceQueryDataBo();
            BeanUtils.copyProperties((Object)slbPo, (Object)dataBo);
            dataBo.setResourceStatusDesc(dicMap.get("RS_INFO_SLB_STATUS").get(dataBo.getResourceStatus() + ""));
            dataBo.setIpVersionDesc(dicMap.get("RS_INFO_SLB_IP_VERSION").get(dataBo.getIpVersion() + ""));
            dataBo.setSpecName((String)slbSpecMap.get(dataBo.getSpecId()));
            retRows.add(dataBo);
        }
        retData.setPageNo(Integer.valueOf(page.getPageNo()));
        retData.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        retData.setTotal(Integer.valueOf(page.getTotalPages()));
        return retBo;
    }

    private Map<String, Map<String, String>> getDicMap() {
        HashMap<String, Map<String, String>> dicMap = new HashMap<String, Map<String, String>>(16);
        ArrayList<String> codes = new ArrayList<String>();
        codes.add("RS_INFO_SLB_STATUS");
        codes.add("RS_INFO_SLB_IP_VERSION");
        RsDicMapQueryAtomReqBo atomReqBo = new RsDicMapQueryAtomReqBo();
        for (String code : codes) {
            atomReqBo.setType(code);
            RsDicMapQueryAtomRspBo atomRetBo = this.rsDicMapQueryAtomService.qryDicMap(atomReqBo);
            dicMap.put(code, atomRetBo.getDicMap());
        }
        return dicMap;
    }

    private Page<RsInfoSlbQueryPo> getPage(RsLoadBalancePageQueryBusiServiceReqBo reqBo) {
        Page page;
        if (reqBo.getPageNo() != 1) {
            page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBo, (Object)page);
            if (reqBo.getPageNo() < 1) {
                page.setPageNo(1);
            }
            if (reqBo.getPageSize() < 1) {
                page.setPageSize(10);
            }
        }
        return page;
    }
}

