/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.tydic.mcmp.resource.ability.api.bo.RsNetworkCreateBusiRspBo;
import com.tydic.mcmp.resource.atom.api.RsSyncResourceInfoToTicketAtomService;
import com.tydic.mcmp.resource.atom.bo.RsSyncResourceInfoToTicketAtomReqBo;
import com.tydic.mcmp.resource.busi.api.RsNetworkCreateBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsNetworkCreateBusiReqBo;
import com.tydic.mcmp.resource.constants.RsDictionaryValueConstants;
import com.tydic.mcmp.resource.dao.RsInfoNetworkCardMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.RsRelNetworkCardSecurityGroupMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoNetworkCardPo;
import com.tydic.mcmp.resource.dao.po.RsInfoResourcePo;
import com.tydic.mcmp.resource.dao.po.RsRelNetworkCardSecurityGroupPo;
import com.tydic.mcmp.resource.enums.RsSequencesEnum;
import com.tydic.starter.sequence.autoconfiguration.SequenceManagement;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="rsNetworkCreateBusiService")
public class RsNetworkCreateBusiServiceImpl
implements RsNetworkCreateBusiService {
    @Autowired
    private RsInfoNetworkCardMapper rsInfoNetworkCardMapper;
    @Autowired
    private SequenceManagement sequenceManagement;
    @Autowired
    private RsRelNetworkCardSecurityGroupMapper rsRelNetworkCardSecurityGroupMapper;
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    @Autowired
    private RsSyncResourceInfoToTicketAtomService rsSyncResourceInfoToTicketAtomService;
    private static final Logger LOGGER = LoggerFactory.getLogger(RsNetworkCreateBusiServiceImpl.class);

    public RsNetworkCreateBusiRspBo dealRsNetworkCreate(RsNetworkCreateBusiReqBo reqBo) {
        RsNetworkCreateBusiRspBo rspBo;
        block12: {
            rspBo = new RsNetworkCreateBusiRspBo();
            String check = this.checkReq(reqBo);
            if (!"".equals(check)) {
                rspBo.setRespDesc(check);
                rspBo.setRespCode("2024");
                return rspBo;
            }
            Long relId = 0L;
            Long resourceId = 0L;
            try {
                try {
                    resourceId = this.sequenceManagement.nextId(RsSequencesEnum.RS_INFO_RESOURCE.toString());
                }
                catch (Exception e) {
                    rspBo.setRespDesc("\u521b\u5efa\u5e8f\u5217\u5931\u8d25");
                    rspBo.setRespCode("2024");
                    return rspBo;
                }
                RsInfoResourcePo rsInfoResourcePo = new RsInfoResourcePo();
                rsInfoResourcePo.setResourceId(resourceId);
                rsInfoResourcePo.setResourceName(reqBo.getNetworkName());
                rsInfoResourcePo.setTenementId(reqBo.getTenementId());
                rsInfoResourcePo.setAccountId(reqBo.getAccountId());
                rsInfoResourcePo.setDepartId(reqBo.getDepartId());
                rsInfoResourcePo.setDepartName(reqBo.getDepartName());
                rsInfoResourcePo.setProjectId(reqBo.getProjectId());
                rsInfoResourcePo.setProjectName(reqBo.getProjectName());
                rsInfoResourcePo.setPlatformId(reqBo.getPlatformId());
                rsInfoResourcePo.setServiceId(5L);
                rsInfoResourcePo.setInstanceId(reqBo.getInstanceId());
                rsInfoResourcePo.setZoneId(reqBo.getZoneId());
                rsInfoResourcePo.setZoneName(reqBo.getZoneName());
                rsInfoResourcePo.setRegionId(reqBo.getRegionId());
                rsInfoResourcePo.setRegionName(reqBo.getRegionName());
                rsInfoResourcePo.setResourceStatus(RsDictionaryValueConstants.RS_INFO_RESOURCE_STATUS_RUN);
                rsInfoResourcePo.setCreateTime(new Date());
                this.rsInfoResourceMapper.insertSelective(rsInfoResourcePo);
            }
            catch (Exception e) {
                rspBo.setRespDesc("\u521b\u5efa\u8d44\u6e90\u4fe1\u606f\u5931\u8d25");
                rspBo.setRespCode("2024");
                return rspBo;
            }
            try {
                RsInfoNetworkCardPo rsInfoNetworkCardPo = new RsInfoNetworkCardPo();
                rsInfoNetworkCardPo.setCardResourceId(resourceId);
                rsInfoNetworkCardPo.setCardName(reqBo.getNetworkName());
                rsInfoNetworkCardPo.setInterchange(reqBo.getInterchange());
                rsInfoNetworkCardPo.setExclusiveNetwork(reqBo.getProprietaryNetwork());
                rsInfoNetworkCardPo.setCardType(RsDictionaryValueConstants.RS_INFO_NETWORK_CARD_TYPE_OTHER);
                rsInfoNetworkCardPo.setInstanceId(reqBo.getInstanceId());
                rsInfoNetworkCardPo.setCardRemark(reqBo.getDesc());
                this.rsInfoNetworkCardMapper.insert(rsInfoNetworkCardPo);
            }
            catch (Exception e) {
                rspBo.setRespDesc("\u521b\u5efa\u5931\u8d25");
                rspBo.setRespCode("2024");
                return rspBo;
            }
            try {
                if (CollectionUtils.isEmpty((Collection)reqBo.getSecurityGroups())) break block12;
                for (Long securityGroupId : reqBo.getSecurityGroups()) {
                    try {
                        relId = this.sequenceManagement.nextId(RsSequencesEnum.RS_REL_NETWORK_CARD_SECURITY_GROUP.toString());
                    }
                    catch (Exception e) {
                        rspBo.setRespDesc("\u521b\u5efa\u5e8f\u5217\u5931\u8d25");
                        rspBo.setRespCode("2024");
                        return rspBo;
                    }
                    RsRelNetworkCardSecurityGroupPo relNetworkCardSecurityGroupPo = new RsRelNetworkCardSecurityGroupPo();
                    relNetworkCardSecurityGroupPo.setCardResourceId(resourceId);
                    relNetworkCardSecurityGroupPo.setSecurityGroupResourceId(securityGroupId);
                    relNetworkCardSecurityGroupPo.setRelId(relId);
                    this.rsRelNetworkCardSecurityGroupMapper.insert(relNetworkCardSecurityGroupPo);
                }
            }
            catch (Exception e) {
                rspBo.setRespDesc("\u521b\u5efa\u5b89\u5168\u7ec4\u5173\u7cfb\u5931\u8d25");
                rspBo.setRespCode("2024");
                return rspBo;
            }
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u521b\u5efa\u6210\u529f");
        return rspBo;
    }

    private void syncResourceInfoToTicket(Long resourceId, Set<Long> resourceIds, String ticketNo) {
        RsSyncResourceInfoToTicketAtomReqBo rsSyncResourceInfoToTicketAtomReqBo = new RsSyncResourceInfoToTicketAtomReqBo();
        rsSyncResourceInfoToTicketAtomReqBo.setResourceId(resourceId);
        rsSyncResourceInfoToTicketAtomReqBo.setResourceIds(resourceIds);
        rsSyncResourceInfoToTicketAtomReqBo.setTicketNo(ticketNo);
        this.rsSyncResourceInfoToTicketAtomService.syncResourceInfoToTicket(rsSyncResourceInfoToTicketAtomReqBo);
    }

    private String checkReq(RsNetworkCreateBusiReqBo reqBo) {
        String s = "";
        if (reqBo.getNetworkName() == null) {
            s = "\u8bf7\u8f93\u5165\u7f51\u5361\u540d\u79f0";
        }
        if (reqBo.getTenementId() == null || "".equals(reqBo.getTenementId())) {
            s = "\u8bf7\u8f93\u5165\u79df\u6237ID";
        }
        if (reqBo.getAccountId() == null) {
            s = "\u8bf7\u8f93\u5165\u8d26\u6237ID";
        }
        if (reqBo.getPlatformId() == null) {
            s = "\u8bf7\u8f93\u5165\u4e91\u5e73\u53f0ID";
        }
        return s;
    }
}

