/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.tydic.mcmp.resource.busi.api.RsNetworkDeleteBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsNetworkDeleteBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsNetworkDeleteBusiRspBo;
import com.tydic.mcmp.resource.dao.RsInfoNetworkCardMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.RsRelNetworkCardSecurityGroupMapper;
import com.tydic.mcmp.resource.utils.RsRspBoUtil;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="rsNetworkDeleteBusiService")
public class RsNetworkDeleteBusiServiceImpl
implements RsNetworkDeleteBusiService {
    @Autowired
    private RsInfoNetworkCardMapper rsInfoNetworkCardMapper;
    @Autowired
    private RsRelNetworkCardSecurityGroupMapper rsRelNetworkCardSecurityGroupMapper;
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(RsNetworkDeleteBusiServiceImpl.class);

    public RsNetworkDeleteBusiRspBo dealRsNetworkDelete(RsNetworkDeleteBusiReqBo reqBo) {
        RsNetworkDeleteBusiRspBo rspBo = RsRspBoUtil.genSuccessBo(RsNetworkDeleteBusiRspBo.class);
        if (CollectionUtils.isEmpty((Collection)reqBo.getDeleteIds())) {
            rspBo.setRespCode("2022");
            rspBo.setRespDesc("\u8bf7\u8f93\u5165ID");
            return rspBo;
        }
        try {
            this.rsInfoNetworkCardMapper.batchDeleteById(reqBo.getDeleteIds());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            rspBo.setRespCode("2022");
            rspBo.setRespDesc("\u4fee\u6539\u5931\u8d25");
            return rspBo;
        }
        try {
            this.rsRelNetworkCardSecurityGroupMapper.batchDeleteByCard(reqBo.getDeleteIds());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            rspBo.setRespCode("2022");
            rspBo.setRespDesc("\u5220\u9664\u5b89\u5168\u7ec4\u5173\u7cfb\u5931\u8d25");
            return rspBo;
        }
        try {
            this.rsInfoResourceMapper.batchDeleteByKey(reqBo.getDeleteIds());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            rspBo.setRespCode("2022");
            rspBo.setRespDesc("\u5220\u9664\u5b89\u5168\u7ec4\u5173\u7cfb\u5931\u8d25");
            return rspBo;
        }
        return rspBo;
    }
}

