/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.tydic.mcmp.intf.api.rds.McmpDatabaseDescribeAvailableResourceService;
import com.tydic.mcmp.intf.api.rds.bo.McmpDatabaseDescribeAvailableResourceReqBO;
import com.tydic.mcmp.intf.api.rds.bo.McmpDatabaseDescribeAvailableResourceRspBO;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.busi.api.RsPlatformInstanceSpecListQueryBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsPlatformInstanceSpecListQueryBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsPlatformInstanceSpecListQueryBusiRspBo;
import com.tydic.mcmp.resource.common.bo.RsPlatformInstanceSpecDataBo;
import com.tydic.mcmp.resource.dao.RsInfoAliDbSpecMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoAliDbSpecPo;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="rsPlatformInstanceSpecListQueryBusiService")
public class RsPlatformInstanceSpecListQueryBusiServiceImpl
implements RsPlatformInstanceSpecListQueryBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final Integer STEP = 5;
    @Autowired
    private RsInfoAliDbSpecMapper rsInfoAliDbSpecMapper;
    @Autowired
    private McmpDatabaseDescribeAvailableResourceService mcmpDatabaseDescribeAvailableResourceService;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;

    public RsPlatformInstanceSpecListQueryBusiRspBo qryInsSpecs(RsPlatformInstanceSpecListQueryBusiReqBo reqBo) {
        this.LOGGER.info("\u5b9e\u4f8b\u89c4\u683c\u5217\u8868\u67e5\u8be2 Busi\u670d\u52a1\uff1a" + reqBo);
        RsPlatformInstanceSpecListQueryBusiRspBo retBo = new RsPlatformInstanceSpecListQueryBusiRspBo();
        List<RsPlatformInstanceSpecDataBo> instanceSpecs = 1L == reqBo.getPlatformId() ? this.getAliPublicSpec(reqBo, retBo) : this.getAliPrivateSpec(reqBo, retBo);
        if (CollectionUtils.isEmpty(instanceSpecs)) {
            return retBo;
        }
        retBo.setInstanceSpecs(instanceSpecs);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private List<RsPlatformInstanceSpecDataBo> getAliPrivateSpec(RsPlatformInstanceSpecListQueryBusiReqBo reqBo, RsPlatformInstanceSpecListQueryBusiRspBo retBo) {
        ArrayList<RsPlatformInstanceSpecDataBo> instanceSpecs = new ArrayList<RsPlatformInstanceSpecDataBo>();
        RsInfoAliDbSpecPo reqPo = new RsInfoAliDbSpecPo();
        reqPo.setPlatformId(reqBo.getPlatformId());
        List<RsInfoAliDbSpecPo> specList = this.rsInfoAliDbSpecMapper.selectByCondition(reqPo);
        if (CollectionUtils.isEmpty(specList)) {
            this.LOGGER.error("\u67e5\u8be2\u5b9e\u4f8b\u89c4\u683c\u8fd4\u56de\u4e3a\u7a7a");
            retBo.setRespCode("2011");
            retBo.setRespDesc("\u67e5\u8be2\u5b9e\u4f8b\u89c4\u683c\u8fd4\u56de\u4e3a\u7a7a");
            return instanceSpecs;
        }
        for (RsInfoAliDbSpecPo spec : specList) {
            RsPlatformInstanceSpecDataBo specDataBo = new RsPlatformInstanceSpecDataBo();
            specDataBo.setInstanceSpec(spec.getSpecId());
            specDataBo.setInstanceSpecDesc(spec.getCpuNo() + "\u6838-" + spec.getMemorySize() + "GB");
            specDataBo.setCpuNo(spec.getCpuNo());
            specDataBo.setMemorySize(spec.getMemorySize());
            specDataBo.setStep(STEP);
            specDataBo.setMin(spec.getStorageMinSize());
            specDataBo.setMax(spec.getStorageMaxSize());
            instanceSpecs.add(specDataBo);
        }
        return instanceSpecs;
    }

    private List<RsPlatformInstanceSpecDataBo> getAliPublicSpec(RsPlatformInstanceSpecListQueryBusiReqBo reqBo, RsPlatformInstanceSpecListQueryBusiRspBo retBo) {
        ArrayList<Object> instanceSpecs = new ArrayList<RsPlatformInstanceSpecDataBo>();
        RsQueryAliParamAtomReqBo atomReqBo = new RsQueryAliParamAtomReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)((Object)atomReqBo));
        RsQueryAliParamAtomRspBo atomRetBo = this.rsQueryAliParamAtomService.queryAliParam(atomReqBo);
        if (!"0000".equals(atomRetBo.getRespCode())) {
            this.LOGGER.error("\u67e5\u8be2\u53c2\u6570\u5931\u8d25\uff1a" + atomRetBo.getRespDesc());
            BeanUtils.copyProperties((Object)((Object)atomRetBo), (Object)retBo);
            return instanceSpecs;
        }
        McmpDatabaseDescribeAvailableResourceReqBO qryReqBo = new McmpDatabaseDescribeAvailableResourceReqBO();
        BeanUtils.copyProperties((Object)reqBo, (Object)qryReqBo);
        if (2L == reqBo.getPlatformId()) {
            qryReqBo.setAccessKeyId(atomRetBo.getAccessKeyId());
            qryReqBo.setAccessKeySecret(atomRetBo.getAccessKeySecret());
            qryReqBo.setEndpointPriv(atomRetBo.getEndpoint());
            qryReqBo.setProxyHost(atomRetBo.getProxyHost());
            qryReqBo.setProxyPort(atomRetBo.getProxyPort());
        } else {
            qryReqBo.setAccessKeyId(atomRetBo.getAccessKeyId());
            qryReqBo.setAccessKeySecret(atomRetBo.getAccessKeySecret());
            qryReqBo.setRegion(atomRetBo.getAccountRegionId());
        }
        qryReqBo.setRegion(reqBo.getRegionId());
        qryReqBo.setCloudType(RsInterfaceUtil.convertCloudType(reqBo.getPlatformId()));
        qryReqBo.setInstanceChargeType(RsInterfaceUtil.convertAliDbInsPayType(reqBo.getPayType()));
        qryReqBo.setEngine(RsInterfaceUtil.convertAliInstanceType(reqBo.getInstanceType()));
        qryReqBo.setEngineVersion(RsInterfaceUtil.convertDbVersion(reqBo.getInstanceVersion()));
        qryReqBo.setDBInstanceStorageType(RsInterfaceUtil.convertDbInsStorageType(reqBo.getStorageType()));
        this.LOGGER.info("\u8c03\u7528\u89c4\u683c\u67e5\u8be2\u63a5\u53e3\u5165\u53c2\u4e3a\uff1a" + qryReqBo);
        McmpDatabaseDescribeAvailableResourceRspBO qryRetBo = this.mcmpDatabaseDescribeAvailableResourceService.describeAvailableResource(qryReqBo);
        this.LOGGER.info("\u89c4\u683c\u67e5\u8be2\u63a5\u53e3\u51fa\u53c2\u4e3a:" + qryRetBo);
        if (!"0000".equals(qryRetBo.getRespCode())) {
            this.LOGGER.error("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u67e5\u8be2\u89c4\u683c\u5931\u8d25\uff1a" + qryRetBo.getRespDesc());
            BeanUtils.copyProperties((Object)qryRetBo, (Object)retBo);
            return instanceSpecs;
        }
        HashSet<RsPlatformInstanceSpecDataBo> specSet = new HashSet<RsPlatformInstanceSpecDataBo>(16);
        for (McmpDatabaseDescribeAvailableResourceRspBO.AvailableZone availableZone : qryRetBo.getAvailableZones()) {
            if ("Disable".equals(availableZone.getStatus())) continue;
            for (McmpDatabaseDescribeAvailableResourceRspBO.SupportedEngine supportedEngine : availableZone.getSupportedEngines()) {
                for (McmpDatabaseDescribeAvailableResourceRspBO.SupportedEngineVersion engineVersion : supportedEngine.getSupportedEngineVersions()) {
                    for (McmpDatabaseDescribeAvailableResourceRspBO.SupportedCategory supportedCategory : engineVersion.getSupportedCategorys()) {
                        for (McmpDatabaseDescribeAvailableResourceRspBO.SupportedStorageType supportedStorageType : supportedCategory.getSupportedStorageTypes()) {
                            for (McmpDatabaseDescribeAvailableResourceRspBO.AvailableResource availableResource : supportedStorageType.getAvailableResources()) {
                                McmpDatabaseDescribeAvailableResourceRspBO.DBInstanceStorageRange dbInstanceStorageRange = availableResource.getDBInstanceStorageRange();
                                RsPlatformInstanceSpecDataBo specDataBo = new RsPlatformInstanceSpecDataBo();
                                BeanUtils.copyProperties((Object)dbInstanceStorageRange, (Object)specDataBo);
                                specDataBo.setInstanceSpec(availableResource.getDBInstanceClass());
                                specDataBo.setInstanceSpecDesc(availableResource.getDBInstanceClass());
                                specSet.add(specDataBo);
                            }
                        }
                    }
                }
            }
        }
        instanceSpecs = new ArrayList(specSet);
        return instanceSpecs;
    }
}

