/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.api.vpc.McmpDescribeVpcsBusiService;
import com.tydic.mcmp.intf.api.vpc.bo.McmpDescribeVpcsReqBO;
import com.tydic.mcmp.intf.api.vpc.bo.McmpDescribeVpcsRspBO;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.busi.api.RsQryAliVpcListBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsQryAliVpcListBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsQryAliVpcListBusiRspBo;
import com.tydic.mcmp.resource.common.bo.RsAliVpcInfoBo;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class RsQryAliVpcListBusiServiceImpl
implements RsQryAliVpcListBusiService {
    private static final Logger log = LoggerFactory.getLogger(RsQryAliVpcListBusiServiceImpl.class);
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;
    @Autowired
    private McmpDescribeVpcsBusiService mcmpDescribeVpcsBusiService;

    public RsQryAliVpcListBusiRspBo qryAliVpcList(RsQryAliVpcListBusiReqBo busiReqBo) {
        RsQryAliVpcListBusiRspBo busiRspBo = new RsQryAliVpcListBusiRspBo();
        RsQueryAliParamAtomReqBo atomReqBo = new RsQueryAliParamAtomReqBo();
        atomReqBo.setAccountId(busiReqBo.getAccountId());
        atomReqBo.setPlatformId(busiReqBo.getPlatformId());
        RsQueryAliParamAtomRspBo atomRspBo = this.rsQueryAliParamAtomService.queryAliParam(atomReqBo);
        if (!"0000".equals(atomRspBo.getRespCode())) {
            throw new McmpBusinessException(atomRspBo.getRespCode(), atomRspBo.getRespDesc());
        }
        McmpDescribeVpcsReqBO mcmpDescribeVpcsReqBO = new McmpDescribeVpcsReqBO();
        mcmpDescribeVpcsReqBO.setAccessKeyId(atomRspBo.getAccessKeyId());
        mcmpDescribeVpcsReqBO.setAccessKeySecret(atomRspBo.getAccessKeySecret());
        mcmpDescribeVpcsReqBO.setEndpointPriv(atomRspBo.getEndpoint());
        mcmpDescribeVpcsReqBO.setProxyHost(atomRspBo.getProxyHost());
        mcmpDescribeVpcsReqBO.setProxyPort(atomRspBo.getProxyPort());
        mcmpDescribeVpcsReqBO.setCloudType(RsInterfaceUtil.convertCloudType(busiReqBo.getPlatformId()));
        if (StringUtils.hasText((String)busiReqBo.getRegion())) {
            mcmpDescribeVpcsReqBO.setRegion(busiReqBo.getRegion());
            mcmpDescribeVpcsReqBO.setRegionId(busiReqBo.getRegion());
        }
        if (StringUtils.hasText((String)busiReqBo.getVpcName())) {
            mcmpDescribeVpcsReqBO.setVpcName(busiReqBo.getVpcName());
        }
        mcmpDescribeVpcsReqBO.setPageNumber(busiReqBo.getPageNo());
        mcmpDescribeVpcsReqBO.setPageSize(busiReqBo.getPageSize());
        log.info("\u8c03\u7528\u4e13\u6709\u7f51\u7edcvpc\u5217\u8868\u67e5\u8be2\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpDescribeVpcsReqBO));
        McmpDescribeVpcsRspBO mcmpDescribeVpcsRspBO = this.mcmpDescribeVpcsBusiService.describeVpcs(mcmpDescribeVpcsReqBO);
        log.info("\u8c03\u7528\u4e13\u6709\u7f51\u7edcvpc\u5217\u8868\u67e5\u8be2\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpDescribeVpcsRspBO));
        if (!"0000".equals(mcmpDescribeVpcsRspBO.getRespCode())) {
            throw new McmpBusinessException(mcmpDescribeVpcsRspBO.getRespCode(), mcmpDescribeVpcsRspBO.getRespDesc());
        }
        ArrayList<RsAliVpcInfoBo> rows = new ArrayList<RsAliVpcInfoBo>();
        if (!CollectionUtils.isEmpty((Collection)mcmpDescribeVpcsRspBO.getVpcs())) {
            for (McmpDescribeVpcsRspBO.Vpc vpc : mcmpDescribeVpcsRspBO.getVpcs()) {
                RsAliVpcInfoBo bo = new RsAliVpcInfoBo();
                bo.setVpcId(vpc.getVpcId());
                bo.setVpcName(vpc.getVpcName());
                rows.add(bo);
            }
        }
        busiRspBo.setPageNo(mcmpDescribeVpcsRspBO.getPageNumber());
        busiRspBo.setRecordsTotal(mcmpDescribeVpcsRspBO.getTotalCount());
        busiRspBo.setRows(rows);
        busiRspBo.setRespCode("0000");
        busiRspBo.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return busiRspBo;
    }
}

