/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.api.cloudser.McmpCloudSerOperInstanceService;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerOperInstanceReqBO;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerOperInstanceRspBO;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.busi.api.RsStartHostBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsStartHostBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsStartHostBusiRspBo;
import com.tydic.mcmp.resource.common.bo.RsUpdateResourceStatusBo;
import com.tydic.mcmp.resource.constants.RsDictionaryValueConstants;
import com.tydic.mcmp.resource.dao.RsInfoResourceHostMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoResourceHostPo;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RsStartHostBusiServiceImpl
implements RsStartHostBusiService {
    private static final Logger log = LoggerFactory.getLogger(RsStartHostBusiServiceImpl.class);
    @Autowired
    private McmpCloudSerOperInstanceService mcmpCloudSerOperInstanceService;
    @Autowired
    private RsInfoResourceHostMapper rsInfoResourceHostMapper;
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;

    public RsStartHostBusiRspBo dealStartHost(RsStartHostBusiReqBo busiReqBo) {
        RsStartHostBusiRspBo busiRspBo = new RsStartHostBusiRspBo();
        RsInfoResourceHostPo rsInfoResourceHostPo = new RsInfoResourceHostPo();
        rsInfoResourceHostPo.setHostResourceId(busiReqBo.getHostResourceId());
        rsInfoResourceHostPo.setInstanceStatus("Running");
        int count = this.rsInfoResourceHostMapper.updateByPrimaryKeySelective(rsInfoResourceHostPo);
        if (count != 1) {
            throw new McmpBusinessException("24012", "\u4e3b\u673a\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        RsUpdateResourceStatusBo rsUpdateResourceStatusBo = new RsUpdateResourceStatusBo();
        if ("1".equals(busiReqBo.getOperType())) {
            rsUpdateResourceStatusBo.setOldStatus(RsDictionaryValueConstants.RS_INFO_RESOURCE_STATUS_STOP);
        }
        rsUpdateResourceStatusBo.setResourceId(busiReqBo.getHostResourceId());
        rsUpdateResourceStatusBo.setStatus(RsDictionaryValueConstants.RS_INFO_RESOURCE_STATUS_RUN);
        rsUpdateResourceStatusBo.setServiceId(Long.valueOf(1L));
        ArrayList<String> instanceIds = new ArrayList<String>();
        instanceIds.add(busiReqBo.getInstanceId());
        rsUpdateResourceStatusBo.setInstanceIds(instanceIds);
        int count1 = this.rsInfoResourceMapper.updateByStatus(rsUpdateResourceStatusBo);
        if (count1 != 1) {
            throw new McmpBusinessException("24012", "\u4e3b\u673a\u5f53\u524d\u72b6\u6001\u5fc5\u987b\u4e3a\u505c\u7528");
        }
        McmpCloudSerOperInstanceReqBO mcmpCloudSerOperInstanceReqBO = new McmpCloudSerOperInstanceReqBO();
        mcmpCloudSerOperInstanceReqBO.setCloudType(RsInterfaceUtil.convertCloudType(busiReqBo.getPlatformId()));
        mcmpCloudSerOperInstanceReqBO.setInstanceId(busiReqBo.getInstanceId());
        mcmpCloudSerOperInstanceReqBO.setForceStop(busiReqBo.getForceStop());
        if ("1".equals(busiReqBo.getOperType())) {
            mcmpCloudSerOperInstanceReqBO.setOperType("1");
        } else if ("3".equals(busiReqBo.getOperType())) {
            mcmpCloudSerOperInstanceReqBO.setOperType("3");
        }
        this.getAkSk(mcmpCloudSerOperInstanceReqBO, busiReqBo);
        log.info("\u8c03\u7528\u4e91\u4e3b\u673a\u5b9e\u4f8b\u542f\u52a8/\u505c\u6b62/\u91cd\u542f/\u5220\u9664API\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpCloudSerOperInstanceReqBO));
        McmpCloudSerOperInstanceRspBO mcmpCloudSerOperInstanceRspBO = this.mcmpCloudSerOperInstanceService.operInstance(mcmpCloudSerOperInstanceReqBO);
        log.info("\u8c03\u7528\u4e91\u4e3b\u673a\u5b9e\u4f8b\u542f\u52a8/\u505c\u6b62/\u91cd\u542f/\u5220\u9664API\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpCloudSerOperInstanceRspBO));
        if (!"0000".equals(mcmpCloudSerOperInstanceRspBO.getRespCode())) {
            throw new McmpBusinessException(mcmpCloudSerOperInstanceRspBO.getRespCode(), mcmpCloudSerOperInstanceRspBO.getRespDesc());
        }
        busiRspBo.setRespCode("0000");
        busiRspBo.setRespDesc("\u4e3b\u673a\u64cd\u4f5c\u6210\u529f");
        return busiRspBo;
    }

    private void getAkSk(McmpCloudSerOperInstanceReqBO mcmpCloudSerOperInstanceReqBO, RsStartHostBusiReqBo busiReqBo) {
        RsQueryAliParamAtomReqBo atomReqBo = new RsQueryAliParamAtomReqBo();
        atomReqBo.setAccountId(busiReqBo.getAccountId());
        atomReqBo.setPlatformId(busiReqBo.getPlatformId());
        RsQueryAliParamAtomRspBo atomRspBo = this.rsQueryAliParamAtomService.queryAliParam(atomReqBo);
        if (!"0000".equals(atomRspBo.getRespCode())) {
            throw new McmpBusinessException(atomRspBo.getRespCode(), atomRspBo.getRespDesc());
        }
        mcmpCloudSerOperInstanceReqBO.setEndpointPriv(atomRspBo.getEndpoint());
        mcmpCloudSerOperInstanceReqBO.setProxyHost(atomRspBo.getProxyHost());
        mcmpCloudSerOperInstanceReqBO.setProxyPort(atomRspBo.getProxyPort());
        mcmpCloudSerOperInstanceReqBO.setAccessKeyId(atomRspBo.getAccessKeyId());
        mcmpCloudSerOperInstanceReqBO.setAccessKeySecret(atomRspBo.getAccessKeySecret());
    }
}

