/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.api.vm.McmpVmCreateIntfService;
import com.tydic.mcmp.intf.api.vm.McmpVmOperIntfService;
import com.tydic.mcmp.intf.api.vm.bo.McmpVmCreateIntfReqBO;
import com.tydic.mcmp.intf.api.vm.bo.McmpVmCreateIntfRspBO;
import com.tydic.mcmp.intf.api.vm.bo.McmpVmOperIntfReqBO;
import com.tydic.mcmp.intf.api.vm.bo.McmpVmOperIntfRspBO;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.busi.api.RsVmCreateVmwareBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsVmCreateVmwareBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsVmCreateVmwareBusiRspBo;
import com.tydic.mcmp.resource.common.bo.RsVmDiskTypesInfoBo;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class RsVmCreateVmwareBusiServiceImpl
implements RsVmCreateVmwareBusiService {
    private static final Logger log = LoggerFactory.getLogger(RsVmCreateVmwareBusiServiceImpl.class);
    @Autowired
    private McmpVmCreateIntfService mcmpVmCreateIntfService;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;
    @Autowired
    private McmpVmOperIntfService mcmpVmOperIntfService;

    public RsVmCreateVmwareBusiRspBo vmCreateVmware(RsVmCreateVmwareBusiReqBo busiReqBo) {
        RsVmCreateVmwareBusiRspBo busiRspBo = new RsVmCreateVmwareBusiRspBo();
        RsQueryAliParamAtomReqBo atomReqBo = new RsQueryAliParamAtomReqBo();
        atomReqBo.setAccountId(busiReqBo.getAccountId());
        atomReqBo.setPlatformId(3L);
        RsQueryAliParamAtomRspBo atomRspBo = this.rsQueryAliParamAtomService.queryAliParam(atomReqBo);
        if (!"0000".equals(atomRspBo.getRespCode())) {
            throw new McmpBusinessException(atomRspBo.getRespCode(), atomRspBo.getRespDesc());
        }
        String InstanceId = this.invokeVmCreate(busiReqBo, atomRspBo);
        this.invokeOper(InstanceId, atomRspBo);
        busiRspBo.setInstanceId(InstanceId);
        busiRspBo.setRespCode("0000");
        busiRspBo.setRespDesc("\u521b\u5efa\u6210\u529f");
        return busiRspBo;
    }

    private void invokeOper(String InstanceId, RsQueryAliParamAtomRspBo atomRspBo) {
        McmpVmOperIntfReqBO mcmpVmOperIntfReqBO = new McmpVmOperIntfReqBO();
        mcmpVmOperIntfReqBO.setOperType("1");
        mcmpVmOperIntfReqBO.setLoginName(atomRspBo.getLoginName());
        mcmpVmOperIntfReqBO.setLoginPwd(atomRspBo.getLoginPwd());
        mcmpVmOperIntfReqBO.setServer(atomRspBo.getServer());
        mcmpVmOperIntfReqBO.setVm(InstanceId);
        log.info("\u8c03\u7528\u865a\u62df\u673a\u64cd\u4f5cAPI\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpVmOperIntfReqBO));
        McmpVmOperIntfRspBO mcmpVmOperIntfRspBO = this.mcmpVmOperIntfService.oper(mcmpVmOperIntfReqBO);
        log.info("\u8c03\u7528\u865a\u62df\u673a\u64cd\u4f5cAPI\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpVmOperIntfRspBO));
        if (!"0000".equals(mcmpVmOperIntfRspBO.getRespCode())) {
            throw new McmpBusinessException(mcmpVmOperIntfRspBO.getRespCode(), mcmpVmOperIntfRspBO.getRespDesc());
        }
    }

    private String invokeVmCreate(RsVmCreateVmwareBusiReqBo busiReqBo, RsQueryAliParamAtomRspBo atomRspBo) {
        McmpVmCreateIntfReqBO mcmpVmCreateIntfReqBO = new McmpVmCreateIntfReqBO();
        mcmpVmCreateIntfReqBO.setLoginName(atomRspBo.getLoginName());
        mcmpVmCreateIntfReqBO.setLoginPwd(atomRspBo.getLoginPwd());
        mcmpVmCreateIntfReqBO.setServer(atomRspBo.getServer());
        mcmpVmCreateIntfReqBO.setGuestOs(busiReqBo.getOsVersionId());
        mcmpVmCreateIntfReqBO.setName(busiReqBo.getVmName());
        McmpVmCreateIntfReqBO.Placement placement = new McmpVmCreateIntfReqBO.Placement();
        mcmpVmCreateIntfReqBO.setPlacement(placement);
        placement.setCluster(busiReqBo.getVmClusterId());
        placement.setResourcePool(busiReqBo.getVmResourcePoolId());
        placement.setDatastore(busiReqBo.getVmStorageId());
        placement.setFolder("group-v3");
        mcmpVmCreateIntfReqBO.setHardwareVersion("VMX_14");
        McmpVmCreateIntfReqBO.BootCreate boot = new McmpVmCreateIntfReqBO.BootCreate();
        mcmpVmCreateIntfReqBO.setBoot(boot);
        boot.setType("BIOS");
        boot.setNetworkProtocol("IPV4");
        ArrayList<McmpVmCreateIntfReqBO.BootDevice> bootDevices = new ArrayList<McmpVmCreateIntfReqBO.BootDevice>();
        mcmpVmCreateIntfReqBO.setBootDevices(bootDevices);
        McmpVmCreateIntfReqBO.BootDevice bootDevice = new McmpVmCreateIntfReqBO.BootDevice();
        bootDevice.setType("CDROM");
        bootDevices.add(bootDevice);
        McmpVmCreateIntfReqBO.BootDevice bootDevice1 = new McmpVmCreateIntfReqBO.BootDevice();
        bootDevice1.setType("DISK");
        bootDevices.add(bootDevice1);
        McmpVmCreateIntfReqBO.BootDevice bootDevice2 = new McmpVmCreateIntfReqBO.BootDevice();
        bootDevice2.setType("ETHERNET");
        bootDevices.add(bootDevice2);
        if (busiReqBo.getCpu() != null) {
            McmpVmCreateIntfReqBO.CpuCreate cpu = new McmpVmCreateIntfReqBO.CpuCreate();
            cpu.setCount(Long.valueOf(busiReqBo.getCpu().intValue()));
            mcmpVmCreateIntfReqBO.setCpu(cpu);
        }
        if (busiReqBo.getMemory() != null) {
            McmpVmCreateIntfReqBO.MemoryCreate memory = new McmpVmCreateIntfReqBO.MemoryCreate();
            memory.setSizeMiB(Long.valueOf((long)busiReqBo.getMemory().intValue() * 1024L));
            mcmpVmCreateIntfReqBO.setMemory(memory);
        }
        if (!CollectionUtils.isEmpty((Collection)busiReqBo.getDisks())) {
            ArrayList<McmpVmCreateIntfReqBO.DiskCreate> disks = new ArrayList<McmpVmCreateIntfReqBO.DiskCreate>();
            for (RsVmDiskTypesInfoBo rsVmDiskTypesInfoBo : busiReqBo.getDisks()) {
                McmpVmCreateIntfReqBO.DiskCreate diskCreate = new McmpVmCreateIntfReqBO.DiskCreate();
                diskCreate.setType(RsInterfaceUtil.convertVmDiskType(rsVmDiskTypesInfoBo.getType()));
                McmpVmCreateIntfReqBO.DiskCreate.VmdkCreateSpec vmdkCreateSpec = new McmpVmCreateIntfReqBO.DiskCreate.VmdkCreateSpec();
                vmdkCreateSpec.setCapacity(Long.valueOf(rsVmDiskTypesInfoBo.getCapacity() * 1024L * 1024L));
                vmdkCreateSpec.setName(rsVmDiskTypesInfoBo.getLabel());
                diskCreate.setNewVmdk(vmdkCreateSpec);
                disks.add(diskCreate);
            }
            mcmpVmCreateIntfReqBO.setDisks(disks);
        }
        ArrayList<McmpVmCreateIntfReqBO.EthernetCreate> nics = new ArrayList<McmpVmCreateIntfReqBO.EthernetCreate>();
        mcmpVmCreateIntfReqBO.setNics(nics);
        McmpVmCreateIntfReqBO.EthernetCreate ethernetCreate = new McmpVmCreateIntfReqBO.EthernetCreate();
        ethernetCreate.setType("E1000E");
        ethernetCreate.setMacType("GENERATED");
        McmpVmCreateIntfReqBO.EthernetCreate.BackingSpec backing = new McmpVmCreateIntfReqBO.EthernetCreate.BackingSpec();
        backing.setType(busiReqBo.getVmSwitchType());
        backing.setNetwork(busiReqBo.getVmSwitchId());
        ethernetCreate.setBacking(backing);
        ethernetCreate.setStartConnected(Boolean.valueOf(true));
        nics.add(ethernetCreate);
        if (StringUtils.hasText((String)busiReqBo.getVmImageUrl())) {
            ArrayList<McmpVmCreateIntfReqBO.CdromCreate> cdroms = new ArrayList<McmpVmCreateIntfReqBO.CdromCreate>();
            mcmpVmCreateIntfReqBO.setCdroms(cdroms);
            McmpVmCreateIntfReqBO.CdromCreate cdromCreate = new McmpVmCreateIntfReqBO.CdromCreate();
            McmpVmCreateIntfReqBO.CdromCreate.BackingSpec backing1 = new McmpVmCreateIntfReqBO.CdromCreate.BackingSpec();
            backing1.setType("ISO_FILE");
            backing1.setIsoFile(busiReqBo.getVmImageUrl());
            cdromCreate.setBacking(backing1);
            cdromCreate.setStartConnected(Boolean.valueOf(true));
            cdroms.add(cdromCreate);
        }
        log.info("\u8c03\u7528vm\u865a\u62df\u673a\u521b\u5efaAPI\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpVmCreateIntfReqBO));
        McmpVmCreateIntfRspBO mcmpVmCreateIntfRspBO = this.mcmpVmCreateIntfService.vmCreate(mcmpVmCreateIntfReqBO);
        log.info("\u8c03\u7528vm\u865a\u62df\u673a\u521b\u5efaAPI\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpVmCreateIntfRspBO));
        if (!"0000".equals(mcmpVmCreateIntfRspBO.getRespCode())) {
            throw new McmpBusinessException(mcmpVmCreateIntfRspBO.getRespCode(), mcmpVmCreateIntfRspBO.getRespDesc());
        }
        return mcmpVmCreateIntfRspBO.getVm();
    }
}

