/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.config;

import com.tydic.mcmp.resource.enums.RsPropertiesEnum;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="rsPropertiesManager")
public class RsPropertiesManager {
    @Autowired
    private Environment environment;
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private Properties properties = new Properties();

    public Properties getProperties() {
        return this.properties;
    }

    public void setValue(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public String getValue(String key) {
        if (StringUtils.isEmpty((Object)key)) {
            this.LOGGER.error("\u83b7\u53d6key\u5165\u53c2\u4e3a\u7a7a\u4e86(" + key + ")");
            return null;
        }
        String value = this.properties.getProperty(key);
        this.LOGGER.debug("\u6839\u636ekey(" + key + ")\u83b7\u53d6value\u4e3a(" + value + ")");
        return value;
    }

    @PostConstruct
    public void initProperties() {
        this.init();
    }

    public void init() {
        for (RsPropertiesEnum mp : RsPropertiesEnum.values()) {
            if (StringUtils.isEmpty((Object)this.environment.getProperty(mp.getName()))) continue;
            this.properties.setProperty(mp.getName(), this.environment.getProperty(mp.getName()));
        }
    }
}

