/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.config.quartz;

import com.tydic.mcmp.resource.config.RsPropertiesManager;
import com.tydic.mcmp.resource.config.quartz.RsJobFactory;
import com.tydic.mcmp.resource.config.quartz.RsSchedulerFactoryBean;
import com.tydic.mcmp.resource.enums.RsPropertiesEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.spi.JobFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.util.StringUtils;

public class QuartzConfiguration {
    @Autowired
    private DataSource dataSource;
    @Autowired
    private RsJobFactory rsJobFactory;
    @Autowired
    private RsPropertiesManager rsPropertiesManager;

    @Bean
    public SchedulerFactoryBean rsSchedulerFactoryBean() {
        RsSchedulerFactoryBean schedulerFactoryBean = new RsSchedulerFactoryBean();
        schedulerFactoryBean.setDataSource(this.dataSource);
        Properties properties = this.getQuartzProperties();
        schedulerFactoryBean.setQuartzProperties(properties);
        schedulerFactoryBean.setJobFactory((JobFactory)this.rsJobFactory);
        return schedulerFactoryBean;
    }

    private Properties getQuartzProperties() {
        Map<String, String> propertyMap = this.genMap();
        ArrayList<String> quartzKeys = new ArrayList<String>();
        quartzKeys.add(RsPropertiesEnum.ORG_QUARTZ_JOBSTORE_CLASS.getName());
        quartzKeys.add(RsPropertiesEnum.ORG_QUARTZ_JOBSTORE_DRIVERDELEGATECLASS.getName());
        quartzKeys.add(RsPropertiesEnum.ORG_QUARTZ_JOBSTORE_USEPROPERTIES.getName());
        quartzKeys.add(RsPropertiesEnum.ORG_QUARTZ_THREADPOOL_THREADCOUNT.getName());
        quartzKeys.add(RsPropertiesEnum.ORG_QUARTZ_THREADPOOL_CLASS.getName());
        Properties properties = new Properties();
        for (String key : quartzKeys) {
            String value = this.rsPropertiesManager.getValue(key);
            if (StringUtils.isEmpty((Object)value)) {
                properties.put(key, propertyMap.get(key));
                continue;
            }
            properties.put(key, value);
        }
        return properties;
    }

    private Map<String, String> genMap() {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        propertyMap.put(RsPropertiesEnum.ORG_QUARTZ_JOBSTORE_CLASS.getName(), "org.quartz.impl.jdbcjobstore.JobStoreTX");
        propertyMap.put(RsPropertiesEnum.ORG_QUARTZ_JOBSTORE_DRIVERDELEGATECLASS.getName(), "org.quartz.impl.jdbcjobstore.StdJDBCDelegate");
        propertyMap.put(RsPropertiesEnum.ORG_QUARTZ_JOBSTORE_USEPROPERTIES.getName(), "true");
        propertyMap.put(RsPropertiesEnum.ORG_QUARTZ_THREADPOOL_THREADCOUNT.getName(), "5");
        propertyMap.put(RsPropertiesEnum.ORG_QUARTZ_THREADPOOL_CLASS.getName(), "org.quartz.simpl.SimpleThreadPool");
        return propertyMap;
    }

    @Bean
    public Scheduler scheduler(SchedulerFactoryBean rsSchedulerFactoryBean) throws SchedulerException {
        Scheduler scheduler = rsSchedulerFactoryBean.getScheduler();
        scheduler.start();
        return scheduler;
    }
}

