/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.ssh;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.resource.ability.api.RsWebSshService;
import com.tydic.mcmp.resource.ability.api.bo.RsWebSshServiceRecvHandleBo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

@Component
public class RsWebSshWebSocketHandler
implements WebSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(RsWebSshWebSocketHandler.class);
    @Autowired
    private RsWebSshService webSSHService;

    public void afterConnectionEstablished(WebSocketSession webSocketSession) throws Exception {
        log.info("\u7528\u6237:{},\u8fde\u63a5WebSSH", webSocketSession.getAttributes().get("user_uuid"));
        this.webSSHService.initConnection(webSocketSession);
    }

    public void handleMessage(WebSocketSession webSocketSession, WebSocketMessage<?> webSocketMessage) throws Exception {
        if (webSocketMessage instanceof TextMessage) {
            log.info("\u7528\u6237:{},\u53d1\u9001\u547d\u4ee4:{}", webSocketSession.getAttributes().get("user_uuid"), (Object)JSON.toJSONString((Object)webSocketMessage.getPayload()));
            RsWebSshServiceRecvHandleBo recvHandleBo = new RsWebSshServiceRecvHandleBo();
            recvHandleBo.setBuffer((String)((TextMessage)webSocketMessage).getPayload());
            recvHandleBo.setSession(webSocketSession);
            this.webSSHService.recvHandle(recvHandleBo);
        } else {
            System.out.println("Unexpected WebSocket message type: " + webSocketMessage);
        }
    }

    public void handleTransportError(WebSocketSession webSocketSession, Throwable throwable) throws Exception {
        log.error("\u6570\u636e\u4f20\u8f93\u9519\u8bef");
    }

    public void afterConnectionClosed(WebSocketSession webSocketSession, CloseStatus closeStatus) throws Exception {
        log.info("\u7528\u6237:{}\u65ad\u5f00webssh\u8fde\u63a5", (Object)String.valueOf(webSocketSession.getAttributes().get("user_uuid")));
        this.webSSHService.close(webSocketSession);
    }

    public boolean supportsPartialMessages() {
        return false;
    }
}

