/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.utils;

import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DateUtils {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);

    public static String dateToStr(Date date) {
        if (date == null) {
            return null;
        }
        try {
            SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return DATE_FORMAT.format(date);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38");
        }
    }

    public static Date strToDate(String str) {
        if (StringUtils.isEmpty((Object)str)) {
            return null;
        }
        try {
            SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return DATE_FORMAT.parse(str);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38");
        }
    }

    public static Date strToDateAsFormat(String str, String format) {
        if (StringUtils.isEmpty((Object)str)) {
            return null;
        }
        if (StringUtils.isEmpty((Object)format)) {
            return null;
        }
        try {
            SimpleDateFormat DATE_FORMAT = new SimpleDateFormat(format);
            return DATE_FORMAT.parse(str);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38");
        }
    }

    public static String dateToStrAsFormat(Date date, String format) {
        if (StringUtils.isEmpty((Object)format)) {
            return null;
        }
        if (date == null) {
            return null;
        }
        try {
            SimpleDateFormat DATE_FORMAT = new SimpleDateFormat(format);
            return DATE_FORMAT.format(date);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38");
        }
    }

    public static String timeZoneTransfer(String time, String format) {
        DateTimeFormatter formatter0 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.of("Asia/Shanghai"));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        ZonedDateTime zoneTime = ZonedDateTime.parse(time, formatter0);
        System.out.println(zoneTime.withFixedOffsetZone().format(formatter));
        return zoneTime.withFixedOffsetZone().format(formatter);
    }

    public static String dateToStrWhisSecond(Date date) {
        if (date == null) {
            return null;
        }
        try {
            SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
            return DATE_FORMAT.format(date);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38");
        }
    }

    public static String dateToStrWhisHour(Date date) {
        if (date == null) {
            return null;
        }
        try {
            SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH'Z'");
            return DATE_FORMAT.format(date);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38");
        }
    }
}

