/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.utils;

import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.base.McmpIntfReqBaseBO;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.constants.RsDictionaryValueConstants;
import com.tydic.mcmp.resource.constants.RsPlatformConstants;

public class RsInterfaceUtil {
    public static String convertCloudType(Long platformId) {
        if (1L == platformId) {
            return "1";
        }
        if (2L == platformId) {
            return "2";
        }
        throw new McmpBusinessException("9000", "\u8bf7\u4f20\u5165\u5408\u9002\u7684\u5e73\u53f0id(" + platformId + ")");
    }

    public static String convertAliHostPayType(Integer payType) {
        if (payType == null) {
            return null;
        }
        if (1 == payType) {
            return "PrePaid";
        }
        if (2 == payType) {
            return "PostPaid";
        }
        throw new McmpBusinessException("9000", "payType[" + payType + "]\u6682\u4e0d\u652f\u6301");
    }

    public static String convertAliHdType(Integer HdType) {
        if (HdType == null) {
            return null;
        }
        if (RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_TYPE_SSD == HdType) {
            return "cloud_ssd";
        }
        if (RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_TYPE_CLOUD == HdType) {
            return "cloud_efficiency";
        }
        if (RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_TYPE_GENERAL_CLOUD == HdType) {
            return "cloud";
        }
        if (RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_TYPE_CLOUD_ESSD == HdType) {
            return "cloud_essd";
        }
        return null;
    }

    public static String convertAliHdPayType(Integer HdPayType) {
        if (HdPayType == null) {
            return null;
        }
        if (RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_PAY_TYPE_MONTH == HdPayType) {
            return "Prepaid";
        }
        if (RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_PAY_TYPE_USAGE == HdPayType) {
            return "Postpaid";
        }
        return null;
    }

    public static Integer convertAliDiskCategoryHdType(String category) {
        if ("cloud_ssd".equals(category)) {
            return RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_TYPE_SSD;
        }
        if ("cloud_efficiency".equals(category)) {
            return RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_TYPE_CLOUD;
        }
        return null;
    }

    public static Integer convertAliDiskTypeHdProperty(String diskType) {
        if ("system".equals(diskType)) {
            return RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_PROPERTY_SYS;
        }
        if ("data".equals(diskType)) {
            return RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_PROPERTY_DATA;
        }
        return null;
    }

    public static Integer convertAliDiskChargeTypeHdPayType(String diskChargeType) {
        if ("Prepaid".equals(diskChargeType)) {
            return RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_PAY_TYPE_MONTH;
        }
        if ("Postpaid".equals(diskChargeType)) {
            return RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_PAY_TYPE_USAGE;
        }
        return null;
    }

    public static String convertAliInternetChargeType(Integer bwBillType) {
        if (null == bwBillType) {
            return null;
        }
        if (1 == bwBillType) {
            return "PayByBandwidth";
        }
        if (2 == bwBillType) {
            return "PayByTraffic";
        }
        return null;
    }

    public static String convertAliInstanceSeries(Integer instanceSeries) {
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_DATABASE_INSTANCE_SERIES_HA.equals(instanceSeries)) {
            return "HighAvailability";
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_DATABASE_INSTANCE_SERIES_BASE.equals(instanceSeries)) {
            return "Basic";
        }
        return null;
    }

    public static void setAliParamToIntReqBo(RsQueryAliParamAtomRspBo pBo, McmpIntfReqBaseBO iBo) {
        iBo.setAccessKeyId(pBo.getAccessKeyId());
        iBo.setAccessKeySecret(pBo.getAccessKeySecret());
        iBo.setEndpointPriv(pBo.getEndpoint());
        iBo.setRegion(pBo.getAccountRegionId());
        iBo.setProxyPort(pBo.getProxyPort());
        iBo.setProxyHost(pBo.getProxyHost());
    }

    public static String convertAliInstanceType(Integer instanceType) {
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_DATABASE_INSTANCE_TYPE_MYSQL.equals(instanceType)) {
            return "MySQL";
        }
        return null;
    }

    public static String convertAliDbInsPayType(Integer payType) {
        if (payType == null) {
            return null;
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_DATABASE_PAY_TYPE_MONTH == payType) {
            return "Prepaid";
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_DATABASE_PAY_TYPE_USAGE == payType) {
            return "Postpaid";
        }
        return null;
    }

    public static String convertAliStorageClass(Integer ossType) {
        if (ossType == null) {
            return null;
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_OBJECT_STORAGE_OSS_TYPE_STANDARD == ossType) {
            return "Standard";
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_OBJECT_STORAGE_OSS_TYPE_LF == ossType) {
            return "IA";
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_OBJECT_STORAGE_OSS_TYPE_ARCHIVE == ossType) {
            return "Archive";
        }
        return null;
    }

    public static String convertAliCannedACL(Integer readAuthority) {
        if (readAuthority == null) {
            return null;
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_OBJECT_READ_AUTHORITY_public == readAuthority) {
            return "private";
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_OBJECT_READ_AUTHORITY_READ == readAuthority) {
            return "public-read";
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_OBJECT_READ_AUTHORITY_READ_WRITE == readAuthority) {
            return "public-read-write";
        }
        return null;
    }

    public static String convertPayType(Integer payType) {
        if (payType == null) {
            return null;
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_REDIS_PAY_TYPE_USAGE == payType) {
            return "PostPaid";
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_REDIS_PAY_TYPE_MONTH == payType) {
            return "PrePaid";
        }
        return null;
    }

    public static String convertNetType(Integer netType) {
        if (netType == null) {
            return null;
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_REDIS_NET_TYPE_VPC == netType) {
            return "VPC";
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_REDIS_NET_TYPE_CLASSIC == netType) {
            return "CLASSIC";
        }
        return null;
    }

    public static String convertEngineVersion(Integer engineType) {
        if (engineType == null) {
            return null;
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_REDIS_INSTANCE_VERSION_5 == engineType) {
            return "5.0";
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_REDIS_INSTANCE_VERSION_4 == engineType) {
            return "4.0";
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_REDIS_INSTANCE_VERSION_28 == engineType) {
            return "2.8";
        }
        return null;
    }

    public static String convertEngineVersionType(Integer engineType) {
        if (engineType == null) {
            return null;
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_REDIS_VERSION_TYPE_COMMUNITY == engineType) {
            return "\u793e\u533a\u7248";
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_REDIS_VERSION_TYPE_EE == engineType) {
            return "\u4f01\u4e1a\u7248";
        }
        return null;
    }

    public static String convertDbNetType(Integer netType) {
        if (netType == null) {
            return "Internet";
        }
        if (RsPlatformConstants.DbInsNetType.INTERNET == netType) {
            return "Internet";
        }
        if (RsPlatformConstants.DbInsNetType.INTRANET == netType) {
            return "Intranet";
        }
        return null;
    }

    public static String convertDbVersion(String version) {
        if (version == null) {
            return null;
        }
        if ("1".equals(version)) {
            return "5.5";
        }
        if ("2".equals(version)) {
            return "5.6";
        }
        if ("3".equals(version)) {
            return "5.7";
        }
        return null;
    }

    public static String convertDbInsStorageType(Integer type) {
        if (type == null) {
            return null;
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_DATABASE_STORAGE_TYPE_LOCAL == type) {
            return "local_ssd";
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_DATABASE_STORAGE_TYPE_CLOUD == type) {
            return "cloud_ssd";
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_DATABASE_STORAGE_TYPE_ESSD_CLOUD == type) {
            return "cloud_essd";
        }
        return null;
    }

    public static String convertTimeUnit(Integer buyTime) {
        if (buyTime == null) {
            return null;
        }
        if (9 >= buyTime) {
            return "Month";
        }
        return "Year";
    }

    public static String convertBuyTime(Integer buyTime) {
        if (buyTime == null) {
            return null;
        }
        if (12 > buyTime) {
            return buyTime.toString();
        }
        return buyTime / 12 + "";
    }

    public static Integer convertAliNetworkType(String networkType) {
        if ("Primary".equals(networkType)) {
            return RsDictionaryValueConstants.RS_INFO_NETWORK_CARD_TYPE_MAIN;
        }
        if ("Secondary".equals(networkType)) {
            return RsDictionaryValueConstants.RS_INFO_NETWORK_CARD_TYPE_OTHER;
        }
        return null;
    }

    public static String AliSecurityGroupNetworkType(Integer netType) {
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_HOST_INTENET_TYPE_VPC.equals(netType)) {
            return "vpc";
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_HOST_INTENET_TYPE_CLASSIC.equals(netType)) {
            return "classic";
        }
        return null;
    }

    public static String RsSecurityTypeToAliSecurityType(Integer type) {
        if (RsDictionaryValueConstants.RS_INFO_SECURITY_GROUP_TYPE_NORMAL.equals(type)) {
            return "normal";
        }
        if (RsDictionaryValueConstants.RS_INFO_SECURITY_GROUP_TYPE_ENTERPRISE.equals(type)) {
            return "enterprise";
        }
        return null;
    }

    public static String RsSecurityDirectionToAliDirectionType(Integer type) {
        if (RsDictionaryValueConstants.RS_SECURITY_GROUP_RULE_DIRECTION_TYPE_OUT.equals(type)) {
            return "egress";
        }
        if (RsDictionaryValueConstants.RS_SECURITY_GROUP_RULE_DIRECTION_TYPE_IN.equals(type)) {
            return "ingress";
        }
        if (RsDictionaryValueConstants.RS_SECURITY_GROUP_RULE_DIRECTION_TYPE_ALL.equals(type)) {
            return "all";
        }
        return null;
    }

    public static String RsSlbInstanceTypeConvert(Integer instanceType) {
        Integer internet = 1;
        Integer intranet = 2;
        if (internet.equals(instanceType)) {
            return "internet";
        }
        if (intranet.equals(instanceType)) {
            return "intranet";
        }
        return null;
    }

    public static String RsSlbInsChargeTypeConvert(Integer feeType) {
        Integer traffic = 1;
        Integer bandWidth = 2;
        if (traffic.equals(feeType)) {
            return "paybytraffic";
        }
        if (bandWidth.equals(feeType)) {
            return "paybybandwidth";
        }
        return null;
    }

    public static String convertSlbPayType(Integer payType) {
        Integer PayOnDemand = 1;
        Integer PrePay = 2;
        if (PayOnDemand.equals(payType)) {
            return "PayOnDemand";
        }
        if (PrePay.equals(payType)) {
            return "PrePay";
        }
        return null;
    }

    public static String convertIpVersion(Integer ipVersion) {
        Integer ipv4 = 1;
        Integer ipv6 = 2;
        if (ipv4.equals(ipVersion)) {
            return "ipv4";
        }
        if (ipv6.equals(ipVersion)) {
            return "ipv6";
        }
        return null;
    }

    public static String transAliSlbStatus(String statusCode) {
        if ("inactive".equals(statusCode)) {
            return "\u5df2\u505c\u6b62";
        }
        if ("active".equals(statusCode)) {
            return "\u8fd0\u884c\u4e2d";
        }
        if ("locked".equals(statusCode)) {
            return "\u5df2\u9501\u5b9a";
        }
        return null;
    }

    public static String transAliSlbNetworkType(String networkType) {
        if ("vpc".equals(networkType)) {
            return "\u4e13\u6709\u7f51\u7edc";
        }
        if ("classic".equals(networkType)) {
            return "\u7ecf\u5178\u7f51\u7edc";
        }
        return null;
    }

    public static String transAliSlbChargeType(String chargeType) {
        if ("paybybandwidth".equals(chargeType)) {
            return "\u6309\u5e26\u5bbd\u8ba1\u8d39";
        }
        if ("paybytraffic".equals(chargeType)) {
            return "\u6309\u6d41\u91cf\u8ba1\u8d39";
        }
        return null;
    }

    public static String transPayType(String payType) {
        if ("PayOnDemand".equals(payType)) {
            return "\u6309\u91cf\u4ed8\u8d39";
        }
        if ("PrePay".equals(payType)) {
            return "\u5305\u5e74\u5305\u6708";
        }
        return null;
    }

    public static String convertVmDiskType(Integer ipVersion) {
        Integer ide = 1;
        Integer scsi = 2;
        Integer sata = 3;
        if (ide.equals(ipVersion)) {
            return "IDE";
        }
        if (scsi.equals(ipVersion)) {
            return "SCSI";
        }
        if (sata.equals(ipVersion)) {
            return "SATA";
        }
        return null;
    }

    public static String transAliECSStatus(String statusCode) {
        if ("Running".equals(statusCode)) {
            return "\u8fd0\u884c\u4e2d";
        }
        if ("Starting".equals(statusCode)) {
            return "\u542f\u52a8\u4e2d";
        }
        if ("Stopping".equals(statusCode)) {
            return "\u505c\u6b62\u4e2d";
        }
        if ("Stopped".equals(statusCode)) {
            return "\u5df2\u505c\u6b62";
        }
        return null;
    }

    public static String transAddressType(String addressType) {
        if ("internet".equals(addressType)) {
            return "\u516c\u7f51";
        }
        if ("intranet".equals(addressType)) {
            return "\u79c1\u7f51";
        }
        return null;
    }

    public static String transSlbListenerStatus(String status) {
        if ("running".equals(status)) {
            return "\u8fd0\u884c\u4e2d";
        }
        if ("stopped".equals(status)) {
            return "\u5df2\u505c\u6b62";
        }
        return null;
    }
}

