/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.ticket.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.ticket.ability.McmpEndWorkOrderAbilityService;
import com.tydic.mcmp.ticket.ability.bo.McmpEndWorkOrderAbilityReqBO;
import com.tydic.mcmp.ticket.ability.bo.McmpEndWorkOrderAbilityRspBO;
import com.tydic.mcmp.ticket.ability.constant.ProcessRspConstant;
import com.tydic.mcmp.ticket.ability.dao.WoHiWoFaultMapper;
import com.tydic.mcmp.ticket.ability.dao.WoHiWoFileMapper;
import com.tydic.mcmp.ticket.ability.dao.WoHiWoInstMapper;
import com.tydic.mcmp.ticket.ability.dao.WoHiWoTacheMapper;
import com.tydic.mcmp.ticket.ability.dao.WoRuWoFaultMapper;
import com.tydic.mcmp.ticket.ability.dao.WoRuWoFileMapper;
import com.tydic.mcmp.ticket.ability.dao.WoRuWoInstMapper;
import com.tydic.mcmp.ticket.ability.dao.WoRuWoTacheMapper;
import com.tydic.mcmp.ticket.ability.po.WoHiWoFaultPO;
import com.tydic.mcmp.ticket.ability.po.WoHiWoFilePO;
import com.tydic.mcmp.ticket.ability.po.WoHiWoInstPO;
import com.tydic.mcmp.ticket.ability.po.WoHiWoTachePO;
import com.tydic.mcmp.ticket.ability.po.WoRuWoFaultPO;
import com.tydic.mcmp.ticket.ability.po.WoRuWoFilePO;
import com.tydic.mcmp.ticket.ability.po.WoRuWoInstPO;
import com.tydic.mcmp.ticket.ability.po.WoRuWoTachePO;
import com.tydic.mcmp.ticket.ability.util.McmpTicketSequence;
import com.tydic.osworkflow.engine.exception.OsworkflowException;
import com.tydic.osworkflow.engine.runtime.ProcessService;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"MCMP_GROUP/1.0.0/com.tydic.mcmp.ticket.ability.McmpEndWorkOrderAbilityService"})
public class McmpEndWorkOrderAbilityServiceImpl
implements McmpEndWorkOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(McmpEndWorkOrderAbilityServiceImpl.class);
    @Autowired
    private WoRuWoTacheMapper woRuWoTacheMapper;
    @Autowired
    private WoHiWoTacheMapper woHiWoTacheMapper;
    @Autowired
    private ProcessService osWorkflowProcessService;
    @Autowired
    private WoRuWoInstMapper woRuWoInstMapper;
    @Autowired
    private WoHiWoInstMapper woHiWoInstMapper;
    @Autowired
    private WoRuWoFileMapper woRuWoFileMapper;
    @Autowired
    private WoHiWoFileMapper woHiWoFileMapper;
    @Autowired
    private WoRuWoFaultMapper woRuWoFaultMapper;
    @Autowired
    private WoHiWoFaultMapper woHiWoFaultMapper;

    @Transactional
    @PostMapping(value={"endWorkOrder"})
    public McmpEndWorkOrderAbilityRspBO endWorkOrder(@RequestBody McmpEndWorkOrderAbilityReqBO reqBO) {
        if (StringUtils.isBlank((String)reqBO.getWorkOrderId())) {
            throw new McmpBusinessException("1001", "\u5de5\u5355\u7ed3\u675f\u5931\u8d25\uff1aworkOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        WoRuWoTachePO selectWoRuWoTachePO = new WoRuWoTachePO();
        selectWoRuWoTachePO.setWorkOrderId(reqBO.getWorkOrderId());
        List<WoRuWoTachePO> woRuWoTachePOList = this.woRuWoTacheMapper.queryWorkOrderTaskList(selectWoRuWoTachePO, null, null);
        if (woRuWoTachePOList != null && woRuWoTachePOList.size() == 1) {
            try {
                this.osWorkflowProcessService.deleteProcessInstanceSingle(reqBO.getWorkOrderId());
                this.moveWoTacheDataToHis(reqBO, woRuWoTachePOList.get(0));
                WoRuWoInstPO selectWoRuWoInstPO = new WoRuWoInstPO();
                selectWoRuWoInstPO.setWorkOrderId(reqBO.getWorkOrderId());
                List<WoRuWoInstPO> woRuWoInstPOList = this.woRuWoInstMapper.selectByCondition(selectWoRuWoInstPO, null, null);
                if (woRuWoInstPOList == null || woRuWoInstPOList.size() != 1) {
                    if (woRuWoInstPOList != null && woRuWoInstPOList.size() > 1) {
                        throw new McmpBusinessException("8888", "\u5de5\u5355\u7ed3\u675f\u5931\u8d25\uff1a\u67e5\u8be2\u5230\u591a\u4e2a\u7b26\u5408\u6761\u4ef6\u7684\u5de5\u5355\u5b9e\u4f8b");
                    }
                    throw new McmpBusinessException("8888", "\u5de5\u5355\u7ed3\u675f\u5931\u8d25\uff1a\u6ca1\u6709\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u5de5\u5355\u5b9e\u4f8b");
                }
                this.moveWoInstDataToHis(reqBO, woRuWoInstPOList.get(0));
                WoRuWoFilePO selectWoRuWoFilePO = new WoRuWoFilePO();
                selectWoRuWoFilePO.setWorkOrderId(reqBO.getWorkOrderId());
                List<WoRuWoFilePO> woRuWoFilePOList = this.woRuWoFileMapper.selectByCondition(selectWoRuWoFilePO);
                if (woRuWoFilePOList != null && woRuWoFilePOList.size() > 0) {
                    this.moveWoFileDataToHis(reqBO, woRuWoFilePOList);
                }
                WoRuWoFaultPO selectWoRuWoFaultPO = new WoRuWoFaultPO();
                selectWoRuWoFaultPO.setWorkOrderId(reqBO.getWorkOrderId());
                List<WoRuWoFaultPO> woRuWoFaultPOList = this.woRuWoFaultMapper.selectByCondition(selectWoRuWoFaultPO);
                if (woRuWoFaultPOList != null && woRuWoFaultPOList.size() == 1) {
                    this.moveWoFaultDataToHis(reqBO, woRuWoFaultPOList.get(0));
                } else if (woRuWoFaultPOList != null && woRuWoFaultPOList.size() > 1) {
                    throw new McmpBusinessException("8888", "\u5de5\u5355\u7ed3\u675f\u5931\u8d25\uff1a\u67e5\u8be2\u5230\u591a\u4e2a\u7b26\u5408\u6761\u4ef6\u7684\u5de5\u5355\u6545\u969c");
                }
                McmpEndWorkOrderAbilityRspBO mcmpEndWorkOrderAbilityRspBO = new McmpEndWorkOrderAbilityRspBO();
                mcmpEndWorkOrderAbilityRspBO.setRespCode("0000");
                mcmpEndWorkOrderAbilityRspBO.setRespDesc("\u6210\u529f");
                return mcmpEndWorkOrderAbilityRspBO;
            }
            catch (OsworkflowException e) {
                throw new McmpBusinessException("8888", "\u5de5\u5355\u7ed3\u675f\u6d41\u7a0b\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        if (woRuWoTachePOList != null && woRuWoTachePOList.size() > 1) {
            throw new McmpBusinessException("8888", "\u5de5\u5355\u7ed3\u675f\u5931\u8d25\uff1a\u67e5\u8be2\u5230\u591a\u4e2a\u7b26\u5408\u6761\u4ef6\u7684\u5de5\u5355\u4efb\u52a1");
        }
        throw new McmpBusinessException("8888", "\u5de5\u5355\u7ed3\u675f\u5931\u8d25\uff1a\u6ca1\u6709\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u5de5\u5355\u4efb\u52a1");
    }

    private void moveWoTacheDataToHis(McmpEndWorkOrderAbilityReqBO reqBO, WoRuWoTachePO woRuWoTachePO) {
        String woRuWoTachePOStr = JSONObject.toJSONString((Object)woRuWoTachePO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        WoHiWoTachePO insertWoHiWoTachePO = (WoHiWoTachePO)JSON.parseObject((String)woRuWoTachePOStr, WoHiWoTachePO.class);
        Long id = McmpTicketSequence.getInstance().nextId();
        insertWoHiWoTachePO.setId(id);
        insertWoHiWoTachePO.setRemark(reqBO.getRemark());
        insertWoHiWoTachePO.setFinishTime(new Date());
        insertWoHiWoTachePO.setFinishType(ProcessRspConstant.COMMON_TYPE.MANUAL_TYPE_CODE);
        insertWoHiWoTachePO.setFinishTypeDesc("\u624b\u52a8\u7ed3\u675f");
        int insertWoHiWoTachePONum = this.woHiWoTacheMapper.insert(insertWoHiWoTachePO);
        if (insertWoHiWoTachePONum != 1) {
            throw new McmpBusinessException("8888", "\u5de5\u5355\u7ed3\u675f\u5931\u8d25\uff1a\u63d2\u5165\u5386\u53f2\u5de5\u5355\u73af\u8282\u6570\u636e\u5931\u8d25");
        }
        WoRuWoTachePO deleteWoRuWoTachePO = new WoRuWoTachePO();
        deleteWoRuWoTachePO.setWorkOrderId(reqBO.getWorkOrderId());
        int deleteWoRuWoTachePONum = this.woRuWoTacheMapper.delete(deleteWoRuWoTachePO);
        if (deleteWoRuWoTachePONum != 1) {
            throw new McmpBusinessException("8888", "\u5de5\u5355\u7ed3\u675f\u5931\u8d25\uff1a\u5220\u9664\u8fd0\u884c\u65f6\u5de5\u5355\u73af\u8282\u6570\u636e\u5931\u8d25");
        }
    }

    private void moveWoInstDataToHis(McmpEndWorkOrderAbilityReqBO reqBO, WoRuWoInstPO woRuWoInstPO) {
        String woRuWoInstPOStr = JSONObject.toJSONString((Object)woRuWoInstPO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        WoHiWoInstPO insertWoHiWoInstPO = (WoHiWoInstPO)JSON.parseObject((String)woRuWoInstPOStr, WoHiWoInstPO.class);
        insertWoHiWoInstPO.setFinishTime(new Date());
        insertWoHiWoInstPO.setFinishType(ProcessRspConstant.COMMON_TYPE.MANUAL_TYPE_CODE);
        insertWoHiWoInstPO.setFinishTypeDesc("\u624b\u52a8\u7ed3\u675f");
        int insertWoHiWoInstPONum = this.woHiWoInstMapper.insert(insertWoHiWoInstPO);
        if (insertWoHiWoInstPONum != 1) {
            throw new McmpBusinessException("8888", "\u5de5\u5355\u7ed3\u675f\u5931\u8d25\uff1a\u63d2\u5165\u5386\u53f2\u5de5\u5355\u5b9e\u4f8b\u6570\u636e\u5931\u8d25");
        }
        WoRuWoInstPO deleteWoRuWoInstPO = new WoRuWoInstPO();
        deleteWoRuWoInstPO.setWorkOrderId(reqBO.getWorkOrderId());
        int deleteWoRuWoInstPONum = this.woRuWoInstMapper.delete(deleteWoRuWoInstPO);
        if (deleteWoRuWoInstPONum != 1) {
            throw new McmpBusinessException("8888", "\u5de5\u5355\u7ed3\u675f\u5931\u8d25\uff1a\u5220\u9664\u8fd0\u884c\u65f6\u5de5\u5355\u5b9e\u4f8b\u6570\u636e\u5931\u8d25");
        }
    }

    private void moveWoFileDataToHis(McmpEndWorkOrderAbilityReqBO reqBO, List<WoRuWoFilePO> woRuWoFilePOList) {
        String woRuWoFilePOListStr = JSONObject.toJSONString(woRuWoFilePOList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        List insertWoHiWoFilePOList = (List)JSON.parseObject((String)woRuWoFilePOListStr, (TypeReference)new TypeReference<List<WoHiWoFilePO>>(){}, (Feature[])new Feature[0]);
        for (WoHiWoFilePO insertWoHiWoFilePO : insertWoHiWoFilePOList) {
            int insertWoHiWoFilePONum = this.woHiWoFileMapper.insert(insertWoHiWoFilePO);
            if (insertWoHiWoFilePONum == 1) continue;
            throw new McmpBusinessException("8888", "\u5de5\u5355\u7ed3\u675f\u5931\u8d25\uff1a\u63d2\u5165\u5386\u53f2\u5de5\u5355\u9644\u4ef6\u6570\u636e\u5931\u8d25");
        }
        WoRuWoFilePO deleteWoRuWoFilePO = new WoRuWoFilePO();
        deleteWoRuWoFilePO.setWorkOrderId(reqBO.getWorkOrderId());
        int deleteWoRuWoFilePONum = this.woRuWoFileMapper.delete(deleteWoRuWoFilePO);
        if (deleteWoRuWoFilePONum != woRuWoFilePOList.size()) {
            throw new McmpBusinessException("8888", "\u5de5\u5355\u7ed3\u675f\u5931\u8d25\uff1a\u5220\u9664\u8fd0\u884c\u65f6\u9644\u4ef6\u6570\u636e\u5931\u8d25");
        }
    }

    private void moveWoFaultDataToHis(McmpEndWorkOrderAbilityReqBO reqBO, WoRuWoFaultPO woRuWoFaultPO) {
        String woRuWoFaultPOStr = JSONObject.toJSONString((Object)woRuWoFaultPO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        WoHiWoFaultPO insertWoHiWoFaultPO = (WoHiWoFaultPO)JSON.parseObject((String)woRuWoFaultPOStr, WoHiWoFaultPO.class);
        int insertWoHiWoFaultPONum = this.woHiWoFaultMapper.insert(insertWoHiWoFaultPO);
        if (insertWoHiWoFaultPONum != 1) {
            throw new McmpBusinessException("8888", "\u5de5\u5355\u7ed3\u675f\u5931\u8d25\uff1a\u63d2\u5165\u5386\u53f2\u5de5\u5355\u6545\u969c\u6570\u636e\u5931\u8d25");
        }
        WoRuWoFaultPO deleteWoRuWoFaultPO = new WoRuWoFaultPO();
        deleteWoRuWoFaultPO.setWorkOrderId(reqBO.getWorkOrderId());
        int deleteWoRuWoFaultPONum = this.woRuWoFaultMapper.delete(deleteWoRuWoFaultPO);
        if (deleteWoRuWoFaultPONum != 1) {
            throw new McmpBusinessException("8888", "\u5de5\u5355\u7ed3\u675f\u5931\u8d25\uff1a\u5220\u9664\u8fd0\u884c\u65f6\u5de5\u5355\u6545\u969c\u6570\u636e\u5931\u8d25");
        }
    }
}

