/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.ticket.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.ticket.ability.McmpStartWorkOrderAbilityService;
import com.tydic.mcmp.ticket.ability.bo.McmpStartWorkOrderAbilityReqBO;
import com.tydic.mcmp.ticket.ability.bo.McmpStartWorkOrderAbilityRspBO;
import com.tydic.mcmp.ticket.ability.bo.McmpWorkOrderFileInfoBO;
import com.tydic.mcmp.ticket.ability.constant.ProcessRspConstant;
import com.tydic.mcmp.ticket.ability.dao.WoMatchRuleMapper;
import com.tydic.mcmp.ticket.ability.dao.WoReModelMapper;
import com.tydic.mcmp.ticket.ability.dao.WoRuWoFaultMapper;
import com.tydic.mcmp.ticket.ability.dao.WoRuWoFileMapper;
import com.tydic.mcmp.ticket.ability.dao.WoRuWoInstMapper;
import com.tydic.mcmp.ticket.ability.dao.WoRuWoTacheMapper;
import com.tydic.mcmp.ticket.ability.po.WoMatchRulePO;
import com.tydic.mcmp.ticket.ability.po.WoReModelPO;
import com.tydic.mcmp.ticket.ability.po.WoRuWoFaultPO;
import com.tydic.mcmp.ticket.ability.po.WoRuWoFilePO;
import com.tydic.mcmp.ticket.ability.po.WoRuWoInstPO;
import com.tydic.mcmp.ticket.ability.po.WoRuWoTachePO;
import com.tydic.mcmp.ticket.ability.util.McmpTicketSequence;
import com.tydic.osworkflow.engine.exception.OsworkflowException;
import com.tydic.osworkflow.engine.runtime.NextStepsResult;
import com.tydic.osworkflow.engine.runtime.ProcessService;
import com.tydic.osworkflow.engine.runtime.Task;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"MCMP_GROUP/1.0.0/com.tydic.mcmp.ticket.ability.McmpStartWorkOrderAbilityService"})
public class McmpStartWorkOrderAbilityServiceImpl
implements McmpStartWorkOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(McmpStartWorkOrderAbilityServiceImpl.class);
    @Value(value="${prodef.sysCode}")
    private String sysCode;
    @Autowired
    private ProcessService osWorkflowProcessService;
    @Autowired
    private WoRuWoInstMapper woRuWoInstMapper;
    @Autowired
    private WoRuWoTacheMapper woRuWoTacheMapper;
    @Autowired
    private WoRuWoFileMapper woRuWoFileMapper;
    @Autowired
    private WoRuWoFaultMapper woRuWoFaultMapper;
    @Autowired
    private WoMatchRuleMapper woMatchRuleMapper;
    @Autowired
    private WoReModelMapper woReModelMapper;

    @Transactional
    @PostMapping(value={"startWorkOrder"})
    public McmpStartWorkOrderAbilityRspBO startWorkOrder(@RequestBody McmpStartWorkOrderAbilityReqBO reqBO) {
        if (StringUtils.isBlank((String)reqBO.getTenant())) {
            throw new McmpBusinessException("1001", "\u5de5\u5355\u53d1\u8d77\u5931\u8d25\uff1atenant\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getProjectCode())) {
            throw new McmpBusinessException("1001", "\u5de5\u5355\u53d1\u8d77\u5931\u8d25\uff1aprojectCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getProjectName())) {
            throw new McmpBusinessException("1001", "\u5de5\u5355\u53d1\u8d77\u5931\u8d25\uff1aprojectName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getWorkOrderType() == null) {
            throw new McmpBusinessException("1001", "\u5de5\u5355\u53d1\u8d77\u5931\u8d25\uff1aworkOrderType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getFlowType() == null) {
            throw new McmpBusinessException("1001", "\u5de5\u5355\u53d1\u8d77\u5931\u8d25\uff1aflowType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getCreatorId())) {
            throw new McmpBusinessException("1001", "\u5de5\u5355\u53d1\u8d77\u5931\u8d25\uff1acreatorId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getCreatorName())) {
            throw new McmpBusinessException("1001", "\u5de5\u5355\u53d1\u8d77\u5931\u8d25\uff1acreatorName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        WoMatchRulePO selectWoMatchRulePO = new WoMatchRulePO();
        selectWoMatchRulePO.setWorkOrderType(reqBO.getWorkOrderType());
        List<WoMatchRulePO> woMatchRulePOList = this.woMatchRuleMapper.selectByCondition(selectWoMatchRulePO, null, null);
        if (woMatchRulePOList != null && woMatchRulePOList.size() == 1) {
            String processKey = "";
            if (ProcessRspConstant.FLOW_TYPE.FLOW_TYPE_OPEN_CODE == reqBO.getFlowType()) {
                processKey = woMatchRulePOList.get(0).getOpenWorkflowKey();
            } else if (ProcessRspConstant.FLOW_TYPE.FLOW_TYPE_APPLY_CODE == reqBO.getFlowType()) {
                processKey = woMatchRulePOList.get(0).getApplyWorkflowKey();
            } else {
                throw new McmpBusinessException("8888", "\u5de5\u5355\u53d1\u8d77\u5931\u8d25\uff1a\u4e0d\u652f\u6301\u7684\u6d41\u7a0b\u7c7b\u578b");
            }
            WoReModelPO selectApplyWoReModelPO = new WoReModelPO();
            selectApplyWoReModelPO.setModelKey(processKey);
            List<WoReModelPO> woReModelPOList = this.woReModelMapper.selectByCondition(selectApplyWoReModelPO, null, null);
            if (woReModelPOList != null && woReModelPOList.size() == 1) {
                try {
                    NextStepsResult nextStepsResult = this.osWorkflowProcessService.newProcessStartBuilder().procDefKey(processKey).procInstName(reqBO.getProjectName()).sysCode(this.sysCode).startWithInstance();
                    if (nextStepsResult.getTaskList() != null && nextStepsResult.getTaskList().size() == 1) {
                        String insertWoRuWoInstPOStr = JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                        WoRuWoInstPO insertWoRuWoInstPO = (WoRuWoInstPO)JSON.parseObject((String)insertWoRuWoInstPOStr, WoRuWoInstPO.class);
                        Long id = McmpTicketSequence.getInstance().nextId();
                        insertWoRuWoInstPO.setId(id);
                        insertWoRuWoInstPO.setProcessKey(processKey);
                        insertWoRuWoInstPO.setWorkOrderTypeDesc(woMatchRulePOList.get(0).getWorkOrderTypeDesc());
                        insertWoRuWoInstPO.setProcessId(((Task)nextStepsResult.getTaskList().get(0)).getProcDefId());
                        insertWoRuWoInstPO.setWorkOrderId(((Task)nextStepsResult.getTaskList().get(0)).getProcInstId());
                        insertWoRuWoInstPO.setModelType(woReModelPOList.get(0).getModelType());
                        if (ProcessRspConstant.COMMON_TYPE.RES_TYPE_CODE.equals(woReModelPOList.get(0).getModelType())) {
                            insertWoRuWoInstPO.setModelTypeDesc("\u8d44\u6e90\u7c7b\u578b");
                        } else if (ProcessRspConstant.COMMON_TYPE.FAULT_TYPE_CODE.equals(woReModelPOList.get(0).getModelType())) {
                            insertWoRuWoInstPO.setModelTypeDesc("\u6545\u969c\u7c7b\u578b");
                        } else if (ProcessRspConstant.COMMON_TYPE.COST_TYPE_CODE.equals(woReModelPOList.get(0).getModelType())) {
                            insertWoRuWoInstPO.setModelTypeDesc("\u8d39\u7528\u7c7b\u578b");
                        }
                        insertWoRuWoInstPO.setWorkOrderCode(woMatchRulePOList.get(0).getWorkOrderCode());
                        insertWoRuWoInstPO.setWorkOrderCodeDesc(woMatchRulePOList.get(0).getWorkOrderCodeDesc());
                        insertWoRuWoInstPO.setWorkOrderState(ProcessRspConstant.WORK_ORDER_STATE.ACTIVE_VALUE);
                        insertWoRuWoInstPO.setWorkOrderStateDesc("\u6fc0\u6d3b");
                        insertWoRuWoInstPO.setCreateTime(new Date());
                        int insertWoRuWoInstPONum = this.woRuWoInstMapper.insert(insertWoRuWoInstPO);
                        if (insertWoRuWoInstPONum == 1) {
                            int insertWoRuWoTachePONum;
                            String insertWoRuWoTachePOStr = JSONObject.toJSONString((Object)insertWoRuWoInstPO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                            WoRuWoTachePO insertWoRuWoTachePO = (WoRuWoTachePO)JSON.parseObject((String)insertWoRuWoTachePOStr, WoRuWoTachePO.class);
                            insertWoRuWoTachePO.setTacheName(((Task)nextStepsResult.getTaskList().get(0)).getStepName());
                            insertWoRuWoTachePO.setTacheKey(((Task)nextStepsResult.getTaskList().get(0)).getTaskId());
                            if ("NONAUTO".equals(((Task)nextStepsResult.getTaskList().get(0)).getStepType())) {
                                insertWoRuWoTachePO.setTacheType(ProcessRspConstant.TACHE_TYPE.NOAUTO_VALUE);
                                insertWoRuWoTachePO.setTacheTypeDesc("\u975e\u81ea\u52a8");
                            } else if ("AUTO".equals(((Task)nextStepsResult.getTaskList().get(0)).getStepType())) {
                                insertWoRuWoTachePO.setTacheType(ProcessRspConstant.TACHE_TYPE.AUTO_VALUE);
                                insertWoRuWoTachePO.setTacheTypeDesc("\u81ea\u52a8");
                            }
                            insertWoRuWoTachePO.setTacheState(ProcessRspConstant.WORK_ORDER_STATE.ACTIVE_VALUE);
                            insertWoRuWoTachePO.setTacheStateDesc("\u6fc0\u6d3b");
                            insertWoRuWoTachePO.setProcessorId(reqBO.getCreatorId());
                            insertWoRuWoTachePO.setProcessorName(reqBO.getCreatorName());
                            if (StringUtils.isBlank((String)insertWoRuWoTachePO.getProcessorName())) {
                                insertWoRuWoTachePO.setProcessorName(reqBO.getCreatorName());
                            }
                            if ((insertWoRuWoTachePONum = this.woRuWoTacheMapper.insert(insertWoRuWoTachePO)) == 1) {
                                for (McmpWorkOrderFileInfoBO mcmpWorkOrderFileInfoBO : reqBO.getFileInfo()) {
                                    WoRuWoFilePO insertWoRuWoFilePO = new WoRuWoFilePO();
                                    Long fileId = McmpTicketSequence.getInstance().nextId();
                                    insertWoRuWoFilePO.setId(fileId);
                                    insertWoRuWoFilePO.setTenant(reqBO.getTenant());
                                    insertWoRuWoFilePO.setWorkOrderId(((Task)nextStepsResult.getTaskList().get(0)).getProcInstId());
                                    insertWoRuWoFilePO.setFileName(mcmpWorkOrderFileInfoBO.getFileName());
                                    insertWoRuWoFilePO.setFileType(mcmpWorkOrderFileInfoBO.getFileType());
                                    insertWoRuWoFilePO.setFileUrl(mcmpWorkOrderFileInfoBO.getFileUrl());
                                    int insertWoRuWoFilePONum = this.woRuWoFileMapper.insert(insertWoRuWoFilePO);
                                    if (insertWoRuWoFilePONum == 1) continue;
                                    throw new McmpBusinessException("8888", "\u5de5\u5355\u53d1\u8d77\u5931\u8d25\uff1a\u63d2\u5165\u5de5\u5355\u9644\u4ef6\u6570\u636e\u5931\u8d25");
                                }
                                if (reqBO.getWorkOrderFaultInfo() != null) {
                                    String insertWoRuWoFaultPOStr = JSONObject.toJSONString((Object)reqBO.getWorkOrderFaultInfo(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                                    WoRuWoFaultPO insertWoRuWoFaultPO = (WoRuWoFaultPO)JSON.parseObject((String)insertWoRuWoFaultPOStr, WoRuWoFaultPO.class);
                                    insertWoRuWoFaultPO.setId(id);
                                    insertWoRuWoFaultPO.setTenant(reqBO.getTenant());
                                    insertWoRuWoFaultPO.setWorkOrderId(((Task)nextStepsResult.getTaskList().get(0)).getProcInstId());
                                    int insertWoRuWoFaultPONum = this.woRuWoFaultMapper.insert(insertWoRuWoFaultPO);
                                    if (insertWoRuWoFaultPONum != 1) {
                                        throw new McmpBusinessException("8888", "\u5de5\u5355\u53d1\u8d77\u5931\u8d25\uff1a\u63d2\u5165\u5de5\u5355\u6545\u969c\u6570\u636e\u5931\u8d25");
                                    }
                                }
                                McmpStartWorkOrderAbilityRspBO mcmpStartWorkOrderAbilityRspBO = new McmpStartWorkOrderAbilityRspBO();
                                mcmpStartWorkOrderAbilityRspBO.setRespCode("0000");
                                mcmpStartWorkOrderAbilityRspBO.setRespDesc("\u6210\u529f");
                                return mcmpStartWorkOrderAbilityRspBO;
                            }
                            throw new McmpBusinessException("8888", "\u5de5\u5355\u53d1\u8d77\u5931\u8d25\uff1a\u63d2\u5165\u5de5\u5355\u4efb\u52a1\u6570\u636e\u5931\u8d25");
                        }
                        throw new McmpBusinessException("8888", "\u5de5\u5355\u53d1\u8d77\u5931\u8d25\uff1a\u63d2\u5165\u5de5\u5355\u5b9e\u4f8b\u6570\u636e\u5931\u8d25");
                    }
                    if (nextStepsResult.getTaskList() != null && nextStepsResult.getTaskList().size() > 1) {
                        throw new McmpBusinessException("1001", "\u5de5\u5355\u53d1\u8d77\u5931\u8d25\uff1a\u751f\u6210\u4e86\u591a\u4e2a\u6d41\u7a0b\u4efb\u52a1");
                    }
                    throw new McmpBusinessException("1001", "\u5de5\u5355\u53d1\u8d77\u5931\u8d25\uff1a\u6ca1\u6709\u751f\u6210\u6d41\u7a0b\u4efb\u52a1");
                }
                catch (OsworkflowException e) {
                    throw new McmpBusinessException("8888", "\u5de5\u5355\u53d1\u8d77\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
            if (woMatchRulePOList != null && woMatchRulePOList.size() > 1) {
                throw new McmpBusinessException("8888", "\u5de5\u5355\u53d1\u8d77\u5931\u8d25\uff1a\u67e5\u8be2\u5230\u591a\u4e2a\u7b26\u5408\u6761\u4ef6\u7684\u6d41\u7a0b\u5b9a\u4e49");
            }
            throw new McmpBusinessException("8888", "\u5de5\u5355\u53d1\u8d77\u5931\u8d25\uff1a\u6ca1\u6709\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6d41\u7a0b\u5b9a\u4e49");
        }
        if (woMatchRulePOList != null && woMatchRulePOList.size() > 1) {
            throw new McmpBusinessException("8888", "\u5de5\u5355\u53d1\u8d77\u5931\u8d25\uff1a\u67e5\u8be2\u5230\u591a\u4e2a\u7b26\u5408\u6761\u4ef6\u7684\u6d41\u7a0b\u5339\u914d\u89c4\u5219\u6570\u636e");
        }
        throw new McmpBusinessException("8888", "\u5de5\u5355\u53d1\u8d77\u5931\u8d25\uff1a\u6ca1\u6709\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6d41\u7a0b\u5339\u914d\u89c4\u5219\u6570\u636e");
    }
}

