/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mdp.core.controller;

import com.tydic.mdp.util.FileZipUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"mdp/gen"})
public class DownGroovyGenCodeController {
    @Value(value="${gen.base_path:/gencode}")
    private String BASE_PATH;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"downloadFile"})
    public void downloadFile(@RequestParam Long moduleId, HttpServletResponse response) throws Exception {
        String downloadPath = this.BASE_PATH + File.separator + "zip_code.zip";
        FileZipUtil.compress((String)downloadPath, (String[])new String[]{this.BASE_PATH + File.separator + moduleId});
        InputStream inputStream = null;
        File zipFile = null;
        try {
            zipFile = new File(downloadPath);
            inputStream = new FileInputStream(zipFile);
            response.setContentType("application/zip");
            response.setHeader("Content-Length", String.valueOf(zipFile.length()));
            response.setHeader("Content-Disposition", "attachment;filename=".concat(String.valueOf(URLEncoder.encode(downloadPath, "UTF-8"))));
            DownGroovyGenCodeController.readAndWrite(inputStream, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (zipFile != null) {
                zipFile.delete();
            }
        }
    }

    private static void readAndWrite(InputStream inputStream, HttpServletResponse response) throws Exception {
        ServletOutputStream os = response.getOutputStream();
        byte[] buffer = new byte[1024];
        int i = inputStream.read(buffer);
        while (i != -1) {
            os.write(buffer, 0, i);
            i = inputStream.read(buffer);
        }
    }
}

