/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.ability.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.merchant.mmc.ability.MmcShopMaintainArticleAddAbilityService;
import com.tydic.merchant.mmc.ability.bo.MmcShopMaintainArticleAddAbilityReqBo;
import com.tydic.merchant.mmc.ability.bo.MmcShopMaintainArticleAddAbilityRspBo;
import com.tydic.merchant.mmc.config.MmcPropertiesManager;
import com.tydic.merchant.mmc.constants.MmcConstants;
import com.tydic.merchant.mmc.enums.MmcPropertiesEnum;
import com.tydic.uac.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="MMC_GROUP", serviceInterface=MmcShopMaintainArticleAddAbilityService.class)
public class MmcShopMaintainArticleAddAbilityServiceImpl
implements MmcShopMaintainArticleAddAbilityService {
    private static final Logger log = LoggerFactory.getLogger(MmcShopMaintainArticleAddAbilityServiceImpl.class);
    private static final String UNDERLINE = "_";
    @Autowired
    private MmcPropertiesManager mmcPropertiesManager;

    public MmcShopMaintainArticleAddAbilityRspBo addArticle(MmcShopMaintainArticleAddAbilityReqBo reqBo) {
        String result;
        if (log.isDebugEnabled()) {
            log.debug("====\u5e97\u94fa\u7ef4\u62a4-\u6587\u7ae0\u65b0\u589e\uff08CMS\uff09\u5f00\u59cb\uff0c\u5165\u53c2\uff1a{}", (Object)reqBo);
        }
        MmcShopMaintainArticleAddAbilityRspBo retBo = new MmcShopMaintainArticleAddAbilityRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("114051");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff0c" + validateStr);
            return retBo;
        }
        String path = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_ARTICLE_ADD_RUL.getName());
        if (StringUtils.isEmpty((Object)path)) {
            log.error("CMS\u6587\u6863\u65b0\u589e\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.mass.article.push.url");
            throw new BusinessException("118002", "CMS\u6587\u6863\u65b0\u589e\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.mass.article.push.url");
        }
        String columnPath = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_COLUMN_ADD_URL.getName());
        if (StringUtils.isEmpty((Object)columnPath)) {
            log.error("CMS\u680f\u76ee\u65b0\u589e\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.column.add.url");
            throw new BusinessException("118002", "CMS\u680f\u76ee\u65b0\u589e\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.column.add.url");
        }
        String columnCode = this.createCmcColumn(reqBo, columnPath);
        if (MmcConstants.ARTICLE_TYPE.INTRO.getType().equals(reqBo.getArticleType())) {
            this.deleteArticleByColumnCode(columnCode);
        }
        String cmsRequestStr = this.getCmsRequestData(reqBo, columnCode);
        log.info("\u65b0\u589e\u6587\u7ae0\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)cmsRequestStr);
        log.info("\u65b0\u589e\u6587\u7ae0\u8bf7\u6c42\u5730\u5740\u4e3a\uff1a{}", (Object)path);
        try {
            result = HttpUtil.post((String)path, (String)cmsRequestStr);
        }
        catch (Exception e) {
            throw new BusinessException("118002", "\u8c03\u7528CMS\u63a5\u53e3\u5f02\u5e38\uff1a", (Throwable)e);
        }
        log.info("\u65b0\u589e\u6587\u7ae0\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)result);
        if (StringUtils.isEmpty((Object)result)) {
            throw new BusinessException("118002", "CMS\u8fd4\u56de\u53c2\u6570\u4e3a\u7a7a");
        }
        JSONObject resultJson = JSON.parseObject((String)result);
        if (!MmcConstants.CMS_SUCCESS.equals(resultJson.get((Object)"code"))) {
            log.error("\u8c03\u7528CMS\u7684\u6587\u6863\u65b0\u589e\u63a5\u53e3\u5931\u8d25\uff1a{}", resultJson.get((Object)"message"));
            retBo.setRespCode("114051");
            retBo.setRespDesc("\u8c03\u7528CMS\u7684\u6587\u6863\u65b0\u589e\u63a5\u53e3\u5931\u8d25\uff1a" + resultJson.get((Object)"message"));
            return retBo;
        }
        this.generateColumn(columnCode);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        if (log.isDebugEnabled()) {
            log.debug("====\u5e97\u94fa\u7ef4\u62a4-\u6587\u7ae0\u65b0\u589e\uff08CMS\uff09\u7ed3\u675f\uff0c\u51fa\u53c2\uff1a{}", (Object)retBo);
        }
        return retBo;
    }

    private void generateColumn(String columnCode) {
        log.debug("\u5f00\u59cb\u9759\u6001\u5316\u680f\u76ee\uff1a{}", (Object)columnCode);
        String generateUrl = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_GENERATE_BY_CODE.getName());
        if (StringUtils.isEmpty((Object)generateUrl)) {
            log.error("CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u9759\u6001\u5316\u6587\u7ae0\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.generate.by.code.url");
            throw new BusinessException("118002", "CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u9759\u6001\u5316\u6587\u7ae0\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.generate.by.code.url");
        }
        JSONObject reqJson = new JSONObject();
        reqJson.put("columnCode", (Object)columnCode);
        log.info("CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u9759\u6001\u5316\u6587\u7ae0\u5165\u53c2\uff1a{}", (Object)reqJson);
        log.info("CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u9759\u6001\u5316\u6587\u7ae0\u5730\u5740\uff1a{}", (Object)generateUrl);
        String result = HttpUtil.post((String)generateUrl, (String)reqJson.toJSONString());
        log.info("CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u9759\u6001\u5316\u6587\u7ae0\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a{}", (Object)result);
        JSONObject resultJson = JSON.parseObject((String)result);
        if (!MmcConstants.CMS_SUCCESS.equals(resultJson.get((Object)"code"))) {
            log.error("CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u9759\u6001\u5316\u6587\u7ae0\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a{}", resultJson.get((Object)"message"));
        }
    }

    private void deleteArticleByColumnCode(String columnCode) {
        log.debug("\u65b0\u589e\u516c\u53f8\u7b80\u4ecb\u6587\u7ae0\uff0c\u5148\u6839\u636e\u680f\u76ee{}\u5220\u9664\u6587\u7ae0", (Object)columnCode);
        String path = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_MASS_DELETE_BY_CODE.getName());
        if (StringUtils.isEmpty((Object)path)) {
            log.error("CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u5220\u9664\u6587\u7ae0\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.mass.delete.by.code");
            throw new BusinessException("118002", "CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u5220\u9664\u6587\u7ae0\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.mass.delete.by.code");
        }
        JSONObject reqJson = new JSONObject();
        reqJson.put("code", (Object)columnCode);
        log.info("CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u5220\u9664\u6587\u7ae0\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)reqJson);
        log.info("CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u5220\u9664\u6587\u7ae0\u5730\u5740\u4e3a\uff1a{}", (Object)path);
        String result = HttpUtil.post((String)path, (String)reqJson.toJSONString());
        log.info("CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u5220\u9664\u6587\u7ae0\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a{}", (Object)result);
        JSONObject resultJson = JSON.parseObject((String)result);
        if (!MmcConstants.CMS_SUCCESS.equals(resultJson.get((Object)"code"))) {
            log.error("\u8c03\u7528CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u5220\u9664\u6587\u7ae0\u63a5\u53e3\u5931\u8d25\uff1a{}", resultJson.get((Object)"message"));
        }
    }

    private String createCmcColumn(MmcShopMaintainArticleAddAbilityReqBo reqBo, String columnPath) {
        String result;
        String table;
        String columnModel;
        if (log.isDebugEnabled()) {
            log.debug("======\u5f00\u59cb\u521b\u5efaCMS\u680f\u76ee======");
        }
        String articleCode = MmcConstants.ARTICLE_TYPE.getArticleType((String)reqBo.getArticleType()).getCode();
        StringBuilder columnCodeBuilder = new StringBuilder();
        columnCodeBuilder.append(reqBo.getShopId()).append(UNDERLINE).append(articleCode);
        log.debug("\u5165\u53c2shopId:{}, articleType:{},\u5f97\u5230\u7684\u680f\u76ee\u7f16\u7801\u4e3a:{}", new Object[]{reqBo.getShopId(), reqBo.getArticleType(), columnCodeBuilder.toString()});
        if (MmcConstants.ARTICLE_TYPE.BANNER.getType().equals(reqBo.getArticleType())) {
            columnModel = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_SHOP_BANNER_COLUMN_MODEL.getName());
            table = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_SHOP_BANNER_TABLE.getName());
        } else if (MmcConstants.ARTICLE_TYPE.ADVERT.getType().equals(reqBo.getArticleType())) {
            columnModel = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_SHOP_ADVERT_COLUMN_MODEL.getName());
            table = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_SHOP_ADVERT_TABLE.getName());
        } else {
            columnModel = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_SHOP_INTRO_COLUMN_MODEL.getName());
            table = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_SHOP_INTRO_TABLE.getName());
        }
        JSONObject columnJson = new JSONObject();
        columnJson.put("columnCode", (Object)columnCodeBuilder.toString());
        columnJson.put("columnTitle", (Object)new StringBuilder().append("\u5e97\u94fa").append(reqBo.getShopId()).append(UNDERLINE).append(articleCode.toUpperCase()));
        columnJson.put("columnSmallimg", (Object)"");
        columnJson.put("columnUrlName", (Object)columnModel);
        columnJson.put("columnListUrlName", (Object)columnModel);
        columnJson.put("columnSort", (Object)0);
        columnJson.put("columnFieldOne", (Object)"");
        columnJson.put("columnFieldTwo", (Object)"");
        columnJson.put("columnCmTable", (Object)table);
        columnJson.put("columnParentCode", (Object)articleCode);
        log.info("CMS\u65b0\u589e\u680f\u76ee\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)columnJson.toJSONString());
        log.info("\u672c\u6b21\u7684CMS\u680f\u76ee\u521b\u5efa\u5730\u5740\u4e3a\uff1a{}", (Object)columnPath);
        try {
            result = HttpUtil.post((String)columnPath, (String)columnJson.toJSONString());
        }
        catch (Exception e) {
            throw new BusinessException("118002", "\u8c03\u7528CMS\u63a5\u53e3\u5f02\u5e38\uff1a", (Throwable)e);
        }
        log.info("CMS\u680f\u76ee\u65b0\u589e\u8fd4\u56de\u7684\u53c2\u6570\u4e3a\uff1a" + result);
        if (StringUtils.isEmpty((Object)result)) {
            throw new BusinessException("118002", "\u8c03\u7528CMS\u63a5\u53e3\u5931\u8d25\uff0c\u8fd4\u56de\u4e3a\u7a7a");
        }
        JSONObject resultJson = JSON.parseObject((String)result);
        if (!MmcConstants.CMS_SUCCESS.equals(resultJson.get((Object)"code"))) {
            log.error("\u8c03\u7528CMS\u7684\u6587\u6863\u65b0\u589e\u63a5\u53e3\u5931\u8d25\uff1a{}", resultJson.get((Object)"message"));
        }
        return columnCodeBuilder.toString();
    }

    private String getCmsRequestData(MmcShopMaintainArticleAddAbilityReqBo reqBo, String columnCode) {
        JSONObject requestJson;
        String articleCode = MmcConstants.ARTICLE_TYPE.getArticleType((String)reqBo.getArticleType()).getCode();
        log.debug("\u5165\u53c2shopId:{}, articleType:{},\u5f97\u5230\u7684\u680f\u76ee\u7f16\u7801\u4e3a:{}", new Object[]{reqBo.getShopId(), reqBo.getArticleType(), columnCode});
        if (MmcConstants.ARTICLE_TYPE.INTRO.getType().equals(reqBo.getArticleType())) {
            MmcShopMaintainArticleAddAbilityReqBo.Company company = reqBo.getCompanyInfo();
            requestJson = JSON.parseObject((String)JSON.toJSONString((Object)company));
            requestJson.put("basicTitle", (Object)company.getTitle());
        } else {
            MmcShopMaintainArticleAddAbilityReqBo.AdvertisementOrBanner instance = reqBo.getInstance();
            requestJson = JSON.parseObject((String)JSON.toJSONString((Object)instance));
            requestJson.put("basicTitle", (Object)(reqBo.getShopId() + UNDERLINE + articleCode + UNDERLINE + System.currentTimeMillis()));
        }
        requestJson.put("columnCode", (Object)columnCode);
        log.debug("\u7ec4\u88c5\u5f97\u5230\u7684CMS\u5165\u53c2\u4e3a\uff1a{}", (Object)requestJson.toJSONString());
        return "[" + requestJson.toJSONString() + "]";
    }

    private String validateArgs(MmcShopMaintainArticleAddAbilityReqBo reqBo) {
        if (null == reqBo) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getShopId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'shopId'(\u5e97\u94faID)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String articleType = reqBo.getArticleType();
        if (StringUtils.isEmpty((Object)articleType)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'articleType'(\u6587\u7ae0\u7c7b\u578b)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == MmcConstants.ARTICLE_TYPE.getArticleType((String)articleType)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'articleType'\u7684\u53d6\u503c\u8303\u56f4(1.\u8f6e\u64ad\u56fe 2.\u5e7f\u544a\u56fe 3 \u516c\u53f8\u4fe1\u606f)";
        }
        if (MmcConstants.ARTICLE_TYPE.BANNER.getType().equals(articleType) || MmcConstants.ARTICLE_TYPE.ADVERT.getType().equals(articleType)) {
            MmcShopMaintainArticleAddAbilityReqBo.AdvertisementOrBanner instance = reqBo.getInstance();
            if (StringUtils.isEmpty((Object)instance.getImage())) {
                return "\u6587\u7ae0\u7c7b\u578b(articleType)\uff0c\u53d6\u503c\u4e3a(1\uff0c2)\u65f6, \u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'instance'\u4e2d\u7684'imageUrl'\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (MmcConstants.ARTICLE_TYPE.ADVERT.getType().equals(articleType) && StringUtils.isEmpty((Object)instance.getRoute())) {
                return "\u6587\u7ae0\u7c7b\u578b(articleType)\uff0c\u53d6\u503c\u4e3a(2)\u65f6, \u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'instance'\u4e2d\u7684'route'\u4e0d\u80fd\u4e3a\u7a7a";
            }
        }
        if (MmcConstants.ARTICLE_TYPE.INTRO.getType().equals(articleType)) {
            MmcShopMaintainArticleAddAbilityReqBo.Company companyInfo = reqBo.getCompanyInfo();
            if (StringUtils.isEmpty((Object)companyInfo.getTitle())) {
                return "\u6587\u7ae0\u7c7b\u578b(articleType)\uff0c\u53d6\u503c\u4e3a(3)\u65f6, \u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'companyInfo'\u4e2d\u7684'title'\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (StringUtils.isEmpty((Object)companyInfo.getIntro())) {
                return "\u6587\u7ae0\u7c7b\u578b(articleType)\uff0c\u53d6\u503c\u4e3a(3)\u65f6, \u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'companyInfo'\u4e2d\u7684'intro'\u4e0d\u80fd\u4e3a\u7a7a";
            }
        }
        return null;
    }
}

