/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.busi.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.merchant.mmc.busi.MmcShopApproveBusiService;
import com.tydic.merchant.mmc.busi.bo.MmcShopApproveBusiReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopApproveBusiRspBo;
import com.tydic.merchant.mmc.config.MmcPropertiesManager;
import com.tydic.merchant.mmc.constants.MmcConstants;
import com.tydic.merchant.mmc.dao.MmcInfoShopContentMapper;
import com.tydic.merchant.mmc.dao.MmcInfoShopMapper;
import com.tydic.merchant.mmc.dao.MmcRelShopContentSettingMapper;
import com.tydic.merchant.mmc.dao.po.MmcInfoShopContentPo;
import com.tydic.merchant.mmc.dao.po.MmcInfoShopPo;
import com.tydic.merchant.mmc.dao.po.MmcRelShopContentSettingPo;
import com.tydic.merchant.mmc.dao.po.MmcShopApproveListQueryPo;
import com.tydic.merchant.mmc.enums.MmcPropertiesEnum;
import com.tydic.merchant.mmc.exception.MmcBusinessException;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uac.bo.common.UacNoneInstanceBO;
import com.tydic.uac.exception.BusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="mmcShopApproveBusiService")
public class MmcShopApproveBusiServiceImpl
implements MmcShopApproveBusiService {
    private static final Logger log = LoggerFactory.getLogger(MmcShopApproveBusiServiceImpl.class);
    private static final String UNDERLINE = "_";
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MmcInfoShopMapper mmcInfoShopMapper;
    @Autowired
    private MmcInfoShopContentMapper mmcInfoShopContentMapper;
    @Autowired
    private MmcRelShopContentSettingMapper mmcRelShopContentSettingMapper;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private MmcPropertiesManager mmcPropertiesManager;

    public MmcShopApproveBusiRspBo updateShopStatus(MmcShopApproveBusiReqBo reqBo) {
        this.LOGGER.info("\u5e97\u94fa\u5ba1\u6279busi\u670d\u52a1\uff1a" + reqBo);
        MmcShopApproveBusiRspBo retBo = new MmcShopApproveBusiRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("112015");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        for (Long shopId : reqBo.getApproveIds()) {
            MmcShopApproveListQueryPo queryPo = new MmcShopApproveListQueryPo();
            queryPo.setShopId(shopId);
            queryPo.setType(Integer.parseInt("1"));
            MmcInfoShopPo rspPo = this.mmcInfoShopMapper.selectTacheCodeByShopId(queryPo);
            if (rspPo == null) {
                this.LOGGER.error("\u83b7\u53d6\u5e97\u94fa\uff08" + shopId + "\uff09\u7684\u6b65\u9aa4ID\u5931\u8d25");
                throw new MmcBusinessException("116005", "\u83b7\u53d6\u5e97\u94fa\uff08" + shopId + "\uff09\u7684\u6b65\u9aa4ID\u5931\u8d25");
            }
            boolean isFinish = this.uacShopApprove(rspPo, reqBo, shopId);
            if (!isFinish) continue;
            this.updateInfo(rspPo, reqBo, shopId);
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private boolean uacShopApprove(MmcInfoShopPo rspPo, MmcShopApproveBusiReqBo reqBo, Long shopId) {
        UacNoTaskAuditOrderAuditRspBO uacRspBo;
        boolean isFinish = true;
        UacNoTaskAuditOrderAuditReqBO uacReqBo = new UacNoTaskAuditOrderAuditReqBO();
        ArrayList<Long> objIds = new ArrayList<Long>();
        objIds.add(shopId);
        uacReqBo.setStepId(rspPo.getTacheCode());
        uacReqBo.setOperId(reqBo.getUserId());
        uacReqBo.setUsername(reqBo.getUserName());
        uacReqBo.setAuditAdvice(reqBo.getDesc());
        uacReqBo.setObjId(objIds);
        uacReqBo.setObjType(Integer.valueOf(Integer.parseInt("1")));
        uacReqBo.setAuditResult(Integer.valueOf(Integer.parseInt("0")));
        if ("2".equals(reqBo.getApproveAction())) {
            uacReqBo.setAuditResult(Integer.valueOf(Integer.parseInt("1")));
        }
        this.LOGGER.info("\u4f20\u5165\u5ba1\u6279API\u7684\u5165\u53c2\uff1a" + uacReqBo);
        try {
            uacRspBo = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(uacReqBo);
        }
        catch (Exception e) {
            this.LOGGER.error("\u8c03\u7528\u5ba1\u6279\u63a5\u53e3\u5931\u8d25\uff1a" + e);
            throw new MmcBusinessException("116005", "\u8c03\u7528\u5ba1\u6279\u63a5\u53e3\u5931\u8d25\uff1a" + e);
        }
        if (!"0000".equals(uacRspBo.getRespCode())) {
            this.LOGGER.error("\u8c03\u7528\u5ba1\u6279\u63a5\u53e3\u5931\u8d25\uff1a" + uacRspBo.getRespDesc());
            throw new MmcBusinessException("116005", "\u8c03\u7528\u5ba1\u6279\u63a5\u53e3\u5931\u8d25\uff1a" + uacRspBo.getRespDesc());
        }
        UacNoneInstanceBO uacNoneInstanceBo = uacRspBo.getNoneInstanceBO();
        if (!uacNoneInstanceBo.getFinish().booleanValue()) {
            isFinish = false;
            this.LOGGER.error("\u5e97\u94fa\uff08" + shopId + "\uff09\u5ba1\u6279\u6d41\u7a0b\u672a\u7ed3\u675f\uff0c\u4e0d\u66f4\u65b0\u4fe1\u606f");
        }
        return isFinish;
    }

    private void updateInfo(MmcInfoShopPo rspPo, MmcShopApproveBusiReqBo reqBo, Long shopId) {
        int result;
        MmcInfoShopPo updatePo = new MmcInfoShopPo();
        updatePo.setShopId(shopId);
        updatePo.setStatus(Integer.parseInt("3"));
        updatePo.setUpdateTime(this.mmcInfoShopMapper.getDbDate());
        if ("2".equals(reqBo.getApproveAction())) {
            updatePo.setStatus(Integer.parseInt("0"));
        }
        if ((result = this.mmcInfoShopMapper.updateByPrimaryKeySelective(updatePo)) < 1) {
            this.LOGGER.error("\u66f4\u65b0\u5e97\u94fa\uff08" + shopId + "\uff09\u7684\u72b6\u6001\u5931\u8d25");
            throw new MmcBusinessException("116005", "\u66f4\u65b0\u5e97\u94fa\uff08" + shopId + "\uff09\u7684\u72b6\u6001\u5931\u8d25");
        }
        if ("2".equals(reqBo.getApproveAction())) {
            return;
        }
        this.updateShopContent(shopId);
    }

    private void updateShopContent(Long shopId) {
        List<MmcRelShopContentSettingPo> contentSettingPos = this.mmcRelShopContentSettingMapper.selectByShopId(String.valueOf(shopId));
        List<MmcInfoShopContentPo> contentPos = this.mmcInfoShopContentMapper.selectByShopId(String.valueOf(shopId));
        if (contentSettingPos.size() <= 0 && contentPos.size() <= 0) {
            return;
        }
        String deleteCmsPath = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_ARTICLE_DELETE_RUL.getName());
        if (StringUtils.isEmpty((Object)deleteCmsPath)) {
            log.error("CMS\u6587\u6863\u5220\u9664\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.mass.article.remove.by.id.url");
            throw new BusinessException("116005", "CMS\u6587\u6863\u5220\u9664\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.mass.article.remove.by.id.url");
        }
        String cmsDeleteRequestStr = this.getDeleteCmsRequestData(contentPos);
        String deleteContentResult = HttpUtil.post((String)deleteCmsPath, (String)cmsDeleteRequestStr);
        log.debug("\u8c03\u7528CMS\u63a5\u53e3\u7ed3\u679c\uff1a{}", (Object)deleteContentResult);
        JSONObject deleteResultJson = JSON.parseObject((String)deleteContentResult);
        if (!MmcConstants.CMS_SUCCESS.equals(deleteResultJson.get((Object)"code"))) {
            log.error("\u8c03\u7528CMS\u7684\u6587\u6863\u5220\u9664\u63a5\u53e3\u5931\u8d25\uff1a{}", deleteResultJson.get((Object)"message"));
            throw new BusinessException("116005", "\u5ba1\u6279\u901a\u8fc7\u540e\uff0cCMS\u6570\u636e\u5220\u9664\u5931\u8d25");
        }
        int deleteResult = this.mmcInfoShopContentMapper.deleteByShopId(String.valueOf(shopId));
        if (deleteResult != contentPos.size()) {
            log.error("\u8c03\u7528mapper\u5220\u9664\u5e97\u94fa\u5185\u5bb9\uff0c\u8fd4\u56de\u503c\u4e3a{}\uff0c\u5e94\u5220\u9664\u7684\u6570\u636e\u4e3a{}", (Object)deleteResult, (Object)contentPos.size());
            throw new BusinessException("116005", "\u5e97\u94faid:" + shopId + " \u5185\u5bb9\u5220\u9664\u5931\u8d25");
        }
        String addCmsPath = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_ARTICLE_ADD_RUL.getName());
        if (StringUtils.isEmpty((Object)addCmsPath)) {
            log.error("CMS\u6587\u6863\u65b0\u589e\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.mass.article.push.url");
            throw new BusinessException("116005", "CMS\u6587\u6863\u65b0\u589e\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.mass.article.push.url");
        }
        String columnPath = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_COLUMN_ADD_URL.getName());
        if (StringUtils.isEmpty((Object)columnPath)) {
            log.error("CMS\u680f\u76ee\u65b0\u589e\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.column.add.url");
            throw new BusinessException("116005", "CMS\u680f\u76ee\u65b0\u589e\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.column.add.url");
        }
        String columnCode = this.createCmcColumn(shopId, columnPath);
        String cmsAddRequestStr = this.getAddCmsRequestData(contentSettingPos, columnCode);
        log.info("\u65b0\u589e\u6587\u7ae0\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)cmsAddRequestStr);
        log.info("\u65b0\u589e\u6587\u7ae0\u8bf7\u6c42\u5730\u5740\u4e3a\uff1a{}", (Object)addCmsPath);
        String addContentResult = HttpUtil.post((String)addCmsPath, (String)cmsAddRequestStr);
        log.debug("\u8c03\u7528CMS\u65b0\u589e\u63a5\u53e3\u7ed3\u679c\uff1a{}", (Object)addContentResult);
        JSONObject addResultJson = JSON.parseObject((String)addContentResult);
        if (!MmcConstants.CMS_SUCCESS.equals(addResultJson.get((Object)"code"))) {
            log.error("\u8c03\u7528CMS\u7684\u6587\u6863\u65b0\u589e\u63a5\u53e3\u5931\u8d25\uff1a{}", addResultJson.get((Object)"message"));
            throw new BusinessException("116005", "\u5ba1\u6279\u901a\u8fc7\u540e\uff0cCMS\u6570\u636e\u65b0\u589e\u5931\u8d25");
        }
        this.generateColumn(columnCode);
        JSONArray articleIds = JSONArray.parseArray((String)addResultJson.getString("data"));
        if (articleIds.size() != contentSettingPos.size()) {
            log.error("\u8c03\u7528cms\u65b0\u589e\u5185\u5bb9\uff0c\u8fd4\u56de\u7684\u6587\u7ae0id\u6570\u636e\u91cf\u4e0d\u7b49\u4e8e\u539f\u8bbe\u7f6e\u4e2d\u6570\u636e\u91cf");
            throw new BusinessException("116005", "\u5e97\u94fa:" + shopId + " \u8bbe\u7f6e\u4e2d\u5185\u5bb9\u6dfb\u52a0\u5230\u5185\u5bb9\u8868\u5931\u8d25");
        }
        for (int i = 0; i < contentSettingPos.size(); ++i) {
            MmcInfoShopContentPo contentPo = new MmcInfoShopContentPo();
            BeanUtils.copyProperties((Object)contentSettingPos.get(i), (Object)contentPo);
            contentPo.setStatus(1);
            contentPo.setArticleId(String.valueOf(articleIds.get(i)));
            int addResult = this.mmcInfoShopContentMapper.insert(contentPo);
            if (addResult != 1) {
                log.error("\u8c03\u7528mapper\u65b0\u589e\u5e97\u94fa\u5185\u5bb9\uff0c\u8fd4\u56de\u503c\u4e0d\u4e3a1\uff0c\u5185\u5bb9\u4e3a\uff1a{}", (Object)contentPo);
                throw new BusinessException("116005", "\u5185\u5bb9:" + contentPo + " \u65b0\u589e\u5931\u8d25");
            }
            MmcRelShopContentSettingPo settingPo = new MmcRelShopContentSettingPo();
            BeanUtils.copyProperties((Object)contentSettingPos.get(i), (Object)settingPo);
            settingPo.setStatus(1);
            int updateSettingResult = this.mmcRelShopContentSettingMapper.updateByPrimaryKey(settingPo);
            if (updateSettingResult == 1) continue;
            log.error("\u8c03\u7528mapper\u66f4\u65b0\u5e97\u94fa\u5185\u5bb9\u8bbe\u7f6e\u8868\u72b6\u6001\uff0c\u8fd4\u56de\u503c\u4e0d\u4e3a1\uff0c\u8bbe\u7f6e\u4e2d\u5185\u5bb9\u4e3a\uff1a{}", (Object)settingPo);
            throw new BusinessException("116005", "\u8bbe\u7f6e\u4e2d\u5185\u5bb9:" + settingPo + " \u66f4\u65b0\u5931\u8d25");
        }
    }

    private String getDeleteCmsRequestData(List<MmcInfoShopContentPo> contentPos) {
        JSONObject requestJson = new JSONObject();
        ArrayList<String> articleIds = new ArrayList<String>();
        for (MmcInfoShopContentPo contentPo : contentPos) {
            articleIds.add(contentPo.getArticleId());
        }
        requestJson.put("articleIds", articleIds);
        log.debug("\u7ec4\u88c5\u5f97\u5230\u5f85\u5220\u9664\u7684CMS\u5165\u53c2\u4e3a\uff1a{}", (Object)requestJson.toJSONString());
        return requestJson.toJSONString();
    }

    private String getAddCmsRequestData(List<MmcRelShopContentSettingPo> contentSettingPos, String columnCode) {
        String articleCode = "publishedContent";
        log.debug("\u5165\u53c2contentSettingPos:{},\u5f97\u5230\u7684\u680f\u76ee\u7f16\u7801\u4e3a:{}", contentSettingPos, (Object)columnCode);
        JSONArray objects = new JSONArray();
        for (MmcRelShopContentSettingPo settingPo : contentSettingPos) {
            JSONObject obj = new JSONObject();
            obj = JSON.parseObject((String)JSON.toJSONString((Object)settingPo));
            obj.put("basicTitle", (Object)(settingPo.getShopId() + UNDERLINE + articleCode + UNDERLINE + System.currentTimeMillis()));
            obj.put("columnCode", (Object)columnCode);
            objects.add((Object)obj);
        }
        log.debug("\u7ec4\u88c5\u5f97\u5230\u7684CMS\u5165\u53c2\u4e3a\uff1a{}", (Object)objects.toJSONString());
        return objects.toJSONString();
    }

    private String createCmcColumn(Long shopId, String columnPath) {
        String result;
        if (log.isDebugEnabled()) {
            log.debug("======\u5f00\u59cb\u521b\u5efaCMS\u680f\u76ee======");
        }
        String articleCode = "publishedContent";
        StringBuilder columnCodeBuilder = new StringBuilder();
        columnCodeBuilder.append(shopId).append(UNDERLINE).append(articleCode);
        log.debug("\u5165\u53c2shopId:{},\u5f97\u5230\u7684\u680f\u76ee\u7f16\u7801\u4e3a:{}", (Object)shopId, (Object)columnCodeBuilder.toString());
        String columnModel = null;
        String table = null;
        columnModel = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_SHOP_CONTENT_COLUMN_MODEL.getName());
        table = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_SHOP_CONTENT_TABLE.getName());
        JSONObject columnJson = new JSONObject();
        columnJson.put("columnCode", (Object)columnCodeBuilder.toString());
        columnJson.put("columnTitle", (Object)new StringBuilder().append("\u5e97\u94fa").append(shopId).append(UNDERLINE).append(articleCode.toUpperCase()));
        columnJson.put("columnSmallimg", (Object)"");
        columnJson.put("columnUrlName", (Object)columnModel);
        columnJson.put("columnListUrlName", (Object)columnModel);
        columnJson.put("columnSort", (Object)0);
        columnJson.put("columnFieldOne", (Object)"");
        columnJson.put("columnFieldTwo", (Object)"");
        columnJson.put("columnCmTable", (Object)table);
        columnJson.put("columnParentCode", (Object)articleCode);
        log.info("CMS\u65b0\u589e\u680f\u76ee\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)columnJson.toJSONString());
        log.info("\u672c\u6b21\u7684CMS\u680f\u76ee\u521b\u5efa\u5730\u5740\u4e3a\uff1a{}", (Object)columnPath);
        try {
            result = HttpUtil.post((String)columnPath, (String)columnJson.toJSONString());
        }
        catch (Exception e) {
            throw new BusinessException("116005", "\u8c03\u7528CMS\u63a5\u53e3\u5f02\u5e38\uff1a", (Throwable)e);
        }
        log.info("CMS\u680f\u76ee\u65b0\u589e\u8fd4\u56de\u7684\u53c2\u6570\u4e3a\uff1a" + result);
        if (StringUtils.isEmpty((Object)result)) {
            throw new BusinessException("116005", "\u8c03\u7528CMS\u63a5\u53e3\u5931\u8d25\uff0c\u8fd4\u56de\u4e3a\u7a7a");
        }
        JSONObject resultJson = JSON.parseObject((String)result);
        if (!MmcConstants.CMS_SUCCESS.equals(resultJson.get((Object)"code"))) {
            log.error("\u8c03\u7528CMS\u7684\u6587\u6863\u65b0\u589e\u63a5\u53e3\u5931\u8d25\uff1a{}", resultJson.get((Object)"message"));
        }
        return columnCodeBuilder.toString();
    }

    private void generateColumn(String columnCode) {
        log.debug("\u5f00\u59cb\u9759\u6001\u5316\u680f\u76ee\uff1a{}", (Object)columnCode);
        String generateUrl = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_GENERATE_BY_CODE.getName());
        if (StringUtils.isEmpty((Object)generateUrl)) {
            log.error("CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u9759\u6001\u5316\u6587\u7ae0\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.generate.by.code.url");
            throw new BusinessException("116005", "CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u9759\u6001\u5316\u6587\u7ae0\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.generate.by.code.url");
        }
        JSONObject reqJson = new JSONObject();
        reqJson.put("columnCode", (Object)columnCode);
        log.info("CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u9759\u6001\u5316\u6587\u7ae0\u5165\u53c2\uff1a{}", (Object)reqJson);
        log.info("CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u9759\u6001\u5316\u6587\u7ae0\u5730\u5740\uff1a{}", (Object)generateUrl);
        String result = HttpUtil.post((String)generateUrl, (String)reqJson.toJSONString());
        log.info("CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u9759\u6001\u5316\u6587\u7ae0\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a{}", (Object)result);
        JSONObject resultJson = JSON.parseObject((String)result);
        if (!MmcConstants.CMS_SUCCESS.equals(resultJson.get((Object)"code"))) {
            log.error("CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u9759\u6001\u5316\u6587\u7ae0\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a{}", resultJson.get((Object)"message"));
        }
    }

    private String validateArgs(MmcShopApproveBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getApproveAction())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'approveAction'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getDesc())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'desc'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getApproveIds())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'approveIds'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOpType())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'opType'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getUserId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'userId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

