/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.busi.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.merchant.mmc.busi.MmcShopContentCopyBusiService;
import com.tydic.merchant.mmc.busi.bo.MmcShopContentCopyBusiReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopContentCopyBusiRspBo;
import com.tydic.merchant.mmc.config.MmcPropertiesManager;
import com.tydic.merchant.mmc.config.MmcSequence;
import com.tydic.merchant.mmc.constants.MmcConstants;
import com.tydic.merchant.mmc.dao.MmcRelShopContentSettingMapper;
import com.tydic.merchant.mmc.dao.po.MmcRelShopContentSettingPo;
import com.tydic.merchant.mmc.enums.MmcPropertiesEnum;
import com.tydic.uac.exception.BusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="mmcShopContentCopyBusiService")
public class MmcShopContentCopyBusiServiceImpl
implements MmcShopContentCopyBusiService {
    private static final Logger log = LoggerFactory.getLogger(MmcShopContentCopyBusiServiceImpl.class);
    private static final String UNDERLINE = "_";
    @Autowired
    private MmcPropertiesManager mmcPropertiesManager;
    @Autowired
    private MmcRelShopContentSettingMapper mmcRelShopContentSettingMapper;

    public MmcShopContentCopyBusiRspBo copyShopContent(MmcShopContentCopyBusiReqBo reqBo) {
        String result;
        if (log.isDebugEnabled()) {
            log.debug("\u5e97\u94fa\u7ba1\u7406-\u5e97\u94fa\u5185\u5bb9\u7ef4\u62a4-\u6587\u7ae0\u590d\u5236busi\u670d\u52a1\uff0c\u5165\u53c2\uff1a{}", (Object)reqBo);
        }
        MmcShopContentCopyBusiRspBo retBo = new MmcShopContentCopyBusiRspBo();
        String validateStr = this.valiDataArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        String path = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_ARTICLE_ADD_RUL.getName());
        if (StringUtils.isEmpty((Object)path)) {
            log.error("CMS\u6587\u6863\u65b0\u589e\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.mass.article.push.url");
            throw new BusinessException("116014", "CMS\u6587\u6863\u65b0\u589e\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.mass.article.push.url");
        }
        String columnPath = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_COLUMN_ADD_URL.getName());
        if (StringUtils.isEmpty((Object)columnPath)) {
            log.error("CMS\u680f\u76ee\u65b0\u589e\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.column.add.url");
            throw new BusinessException("116014", "CMS\u680f\u76ee\u65b0\u589e\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.column.add.url");
        }
        ArrayList<MmcRelShopContentSettingPo> contentSettingPos = new ArrayList<MmcRelShopContentSettingPo>();
        for (String contentId : reqBo.getContentIds()) {
            MmcRelShopContentSettingPo contentSettingPo = this.mmcRelShopContentSettingMapper.selectByPrimaryKey(contentId);
            if (contentSettingPo == null) continue;
            contentSettingPo.setContentId(String.valueOf(MmcSequence.nextId()));
            contentSettingPo.setStatus(0);
            Date nowDate = this.mmcRelShopContentSettingMapper.getDbDate();
            contentSettingPo.setReleaseTime(nowDate);
            contentSettingPos.add(contentSettingPo);
        }
        String articleCode = "settingContent";
        StringBuilder columnCodeBuilder = new StringBuilder();
        columnCodeBuilder.append(((MmcRelShopContentSettingPo)contentSettingPos.get(0)).getShopId()).append(UNDERLINE).append(articleCode);
        String columnCode = columnCodeBuilder.toString();
        String cmsRequestStr = this.getCmsRequestData(contentSettingPos, columnCode);
        log.info("\u65b0\u589e\u6587\u7ae0\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)cmsRequestStr);
        log.info("\u65b0\u589e\u6587\u7ae0\u8bf7\u6c42\u5730\u5740\u4e3a\uff1a{}", (Object)path);
        try {
            result = HttpUtil.post((String)path, (String)cmsRequestStr);
        }
        catch (Exception e) {
            throw new BusinessException("116014", "\u8c03\u7528CMS\u63a5\u53e3\u5f02\u5e38\uff1a", (Throwable)e);
        }
        log.info("\u65b0\u589e\u6587\u7ae0\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)result);
        if (StringUtils.isEmpty((Object)result)) {
            throw new BusinessException("116014", "CMS\u8fd4\u56de\u53c2\u6570\u4e3a\u7a7a");
        }
        JSONObject resultJson = JSON.parseObject((String)result);
        if (!MmcConstants.CMS_SUCCESS.equals(resultJson.get((Object)"code"))) {
            log.error("\u8c03\u7528CMS\u7684\u6587\u6863\u65b0\u589e\u63a5\u53e3\u5931\u8d25\uff1a{}", resultJson.get((Object)"message"));
            retBo.setRespCode("112041");
            retBo.setRespDesc("\u8c03\u7528CMS\u7684\u6587\u6863\u65b0\u589e\u63a5\u53e3\u5931\u8d25\uff1a" + resultJson.get((Object)"message"));
            return retBo;
        }
        this.generateColumn(columnCode);
        JSONArray articleIds = JSONArray.parseArray((String)resultJson.getString("data"));
        if (articleIds.size() != contentSettingPos.size()) {
            throw new BusinessException("116014", "\u590d\u5236\u5e97\u94fa\u5185\u5bb9\uff0c\u8c03\u7528cms\u8fd4\u56de\u6570\u636e\u6709\u8bef");
        }
        for (int i = 0; i < contentSettingPos.size(); ++i) {
            MmcRelShopContentSettingPo contentSettingPo = (MmcRelShopContentSettingPo)contentSettingPos.get(i);
            contentSettingPo.setArticleId(String.valueOf(articleIds.get(i)));
            int addResult = this.mmcRelShopContentSettingMapper.insert(contentSettingPo);
            if (addResult == 1) continue;
            throw new BusinessException("116014", "\u590d\u5236\u5e97\u94fa\u5185\u5bb9\uff0c\u6570\u636e\u5165\u5e93\u5931\u8d25");
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        if (log.isDebugEnabled()) {
            log.debug("\u5e97\u94fa\u7ba1\u7406-\u5e97\u94fa\u5185\u5bb9\u7ef4\u62a4-\u6587\u7ae0\u590d\u5236\u7ed3\u675f\uff0c\u51fa\u53c2\uff1a{}", (Object)retBo);
        }
        return retBo;
    }

    private void generateColumn(String columnCode) {
        log.debug("\u5f00\u59cb\u9759\u6001\u5316\u680f\u76ee\uff1a{}", (Object)columnCode);
        String generateUrl = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_GENERATE_BY_CODE.getName());
        if (StringUtils.isEmpty((Object)generateUrl)) {
            log.error("CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u9759\u6001\u5316\u6587\u7ae0\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.generate.by.code.url");
            throw new BusinessException("116013", "CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u9759\u6001\u5316\u6587\u7ae0\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.generate.by.code.url");
        }
        JSONObject reqJson = new JSONObject();
        reqJson.put("columnCode", (Object)columnCode);
        log.info("CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u9759\u6001\u5316\u6587\u7ae0\u5165\u53c2\uff1a{}", (Object)reqJson);
        log.info("CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u9759\u6001\u5316\u6587\u7ae0\u5730\u5740\uff1a{}", (Object)generateUrl);
        String result = HttpUtil.post((String)generateUrl, (String)reqJson.toJSONString());
        log.info("CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u9759\u6001\u5316\u6587\u7ae0\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a{}", (Object)result);
        JSONObject resultJson = JSON.parseObject((String)result);
        if (!MmcConstants.CMS_SUCCESS.equals(resultJson.get((Object)"code"))) {
            log.error("CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u9759\u6001\u5316\u6587\u7ae0\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a{}", resultJson.get((Object)"message"));
        }
    }

    private String getCmsRequestData(List<MmcRelShopContentSettingPo> contentSettingPos, String columnCode) {
        JSONArray requestJson = new JSONArray();
        for (int i = 0; i < contentSettingPos.size(); ++i) {
            MmcRelShopContentSettingPo contentSettingPo = contentSettingPos.get(i);
            JSONObject requestObj = new JSONObject();
            requestObj.put("image", (Object)contentSettingPo.getImage());
            requestObj.put("route", (Object)contentSettingPo.getRoute());
            String articleCode = "settingContent";
            requestObj.put("basicTitle", (Object)(contentSettingPo.getShopId() + UNDERLINE + articleCode + UNDERLINE + System.currentTimeMillis()));
            requestObj.put("columnCode", (Object)columnCode);
            requestJson.add((Object)requestObj);
        }
        log.debug("\u7ec4\u88c5\u5f97\u5230\u7684CMS\u5165\u53c2\u4e3a\uff1a{}", (Object)requestJson.toJSONString());
        return requestJson.toJSONString();
    }

    private String valiDataArgs(MmcShopContentCopyBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBo.getContentIds() == null || reqBo.getContentIds().length <= 0) {
            return "\u5165\u53c2'reqBo'\u7684\u5c5e\u6027'contentIds'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

