/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.busi.impl;

import com.tydic.merchant.mmc.busi.MmcShopFreezeBusiService;
import com.tydic.merchant.mmc.busi.bo.MmcShopFreezeBusiReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopFreezeBusiRspBo;
import com.tydic.merchant.mmc.config.MmcPropertiesManager;
import com.tydic.merchant.mmc.dao.MmcInfoShopMapper;
import com.tydic.merchant.mmc.dao.po.MmcInfoShopPo;
import com.tydic.merchant.mmc.exception.MmcBusinessException;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class MmcShopFreezeBusiServiceImpl
implements MmcShopFreezeBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MmcInfoShopMapper mmcInfoShopMapper;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private MmcPropertiesManager mmcPropertiesManager;

    public MmcShopFreezeBusiRspBo freezeShop(MmcShopFreezeBusiReqBo reqBo) {
        this.LOGGER.info("\u5e97\u94fa\u6279\u91cf\u51bb\u7ed3busi\u670d\u52a1\uff1a" + reqBo);
        MmcShopFreezeBusiRspBo retBo = new MmcShopFreezeBusiRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("112045");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        for (Long shopId : reqBo.getShopIds()) {
            MmcInfoShopPo mmcInfoShopPo = this.mmcInfoShopMapper.selectByPrimaryKey(shopId);
            if (mmcInfoShopPo == null) {
                this.LOGGER.error("\u5e97\u94fa:{} \u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u51bb\u7ed3", (Object)shopId);
                retBo.setRespCode("112045");
                retBo.setRespDesc("\u5e97\u94fa:" + shopId + "\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u51bb\u7ed3");
                return retBo;
            }
            if (!"4".equals(String.valueOf(mmcInfoShopPo.getStatus()))) {
                this.LOGGER.error("\u5e97\u94fa:{} \u4e0d\u662f\u8fd0\u8425\u4e2d\u72b6\u6001\uff0c\u65e0\u6cd5\u51bb\u7ed3", (Object)shopId);
                retBo.setRespCode("112045");
                retBo.setRespDesc("\u5e97\u94fa:" + shopId + "\u4e0d\u662f\u8fd0\u8425\u4e2d\u72b6\u6001\uff0c\u65e0\u6cd5\u51bb\u7ed3");
                return retBo;
            }
            mmcInfoShopPo.setStatus(Integer.parseInt("7"));
            int updateResult = this.mmcInfoShopMapper.updateByPrimaryKey(mmcInfoShopPo);
            if (updateResult == 1) continue;
            throw new MmcBusinessException("116018", "\u5e97\u94fa" + shopId + "\u51bb\u7ed3\u5931\u8d25");
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArgs(MmcShopFreezeBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getShopIds())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'shopIds'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getUserId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'userId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

