/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.atom.impl;

import com.tydic.merchant.mmc.atom.api.MmcMerchantAddAtomService;
import com.tydic.merchant.mmc.atom.bo.MmcMerchantAddAtomReqBo;
import com.tydic.merchant.mmc.atom.bo.MmcMerchantAddAtomRspBo;
import com.tydic.merchant.mmc.dao.MmcInfoMerchantMapper;
import com.tydic.merchant.mmc.dao.po.MmcInfoMerchantPo;
import com.tydic.merchant.mmc.enums.MmcSequencesEnum;
import com.tydic.merchant.mmc.utils.MmcRspBoUtil;
import com.tydic.starter.sequence.autoconfiguration.SequenceManagement;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="mmcMerchantAddAtomService")
public class MmcMerchantAddAtomServiceImpl
implements MmcMerchantAddAtomService {
    private Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MmcInfoMerchantMapper mmcInfoMerchantMapper;
    @Autowired
    private SequenceManagement sequenceManagement;

    @Override
    public MmcMerchantAddAtomRspBo addMerchant(MmcMerchantAddAtomReqBo reqBo) {
        long merchantId;
        this.LOGGER.info("\u5546\u6237\u65b0\u589eAtom\u670d\u52a1\uff1a" + reqBo);
        try {
            merchantId = this.sequenceManagement.nextId(MmcSequencesEnum.SEQUENCE_MERCHANT_ID.toString());
        }
        catch (SQLException e) {
            this.LOGGER.error("\u83b7\u53d6\u4e3b\u952e\u5f02\u5e38:" + e);
            return MmcRspBoUtil.genFailedBo(MmcMerchantAddAtomRspBo.class, "\u83b7\u53d6\u4e3b\u952e\u5f02\u5e38:" + e.getMessage(), "1002");
        }
        MmcInfoMerchantPo insertPo = new MmcInfoMerchantPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)insertPo);
        insertPo.setMerchantId(merchantId);
        int insert = this.mmcInfoMerchantMapper.insert(insertPo);
        if (insert < 1) {
            return MmcRspBoUtil.genFailedBo(MmcMerchantAddAtomRspBo.class, "\u63d2\u5165\u5931\u8d25\uff0c\u8fd4\u56de\u503c\u4e0d\u4e3a1", "1002");
        }
        MmcMerchantAddAtomRspBo retBo = MmcRspBoUtil.genSuccessBo(MmcMerchantAddAtomRspBo.class);
        retBo.setMerchantId(merchantId);
        return retBo;
    }
}

