/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.busi.impl;

import com.tydic.merchant.mmc.atom.api.MmcFitmentMaterialGroupAddAtomService;
import com.tydic.merchant.mmc.atom.api.MmcFitmentMaterialInfoUpdateAtomService;
import com.tydic.merchant.mmc.atom.api.MmcFitmentMaterialListQueryAtomService;
import com.tydic.merchant.mmc.atom.bo.MmcFitmentMaterialGroupAddAtomReqBo;
import com.tydic.merchant.mmc.atom.bo.MmcFitmentMaterialGroupAddAtomRspBo;
import com.tydic.merchant.mmc.atom.bo.MmcFitmentMaterialInfoAtomDataBo;
import com.tydic.merchant.mmc.atom.bo.MmcFitmentMaterialInfoUpdateAtomReqBo;
import com.tydic.merchant.mmc.atom.bo.MmcFitmentMaterialInfoUpdateAtomRspBo;
import com.tydic.merchant.mmc.atom.bo.MmcFitmentMaterialListQueryAtomReqBo;
import com.tydic.merchant.mmc.atom.bo.MmcFitmentMaterialListQueryAtomRspBo;
import com.tydic.merchant.mmc.busi.MmcFitmentMaterialGroupDeleteBusiService;
import com.tydic.merchant.mmc.busi.bo.MmcFitmentMaterialGroupDeleteBusiReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcFitmentMaterialGroupDeleteBusiRspBo;
import com.tydic.merchant.mmc.common.exception.MmcBusinessException;
import com.tydic.merchant.mmc.dao.MmcFitmentRelMaterialShopGroupMapper;
import com.tydic.merchant.mmc.dao.po.MmcFitmentRelMaterialShopGroupPo;
import com.tydic.merchant.mmc.enums.MmcSequencesEnum;
import com.tydic.starter.sequence.autoconfiguration.SequenceManagement;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="mmcFitmentMaterialGroupDeleteBusiService")
public class MmcFitmentMaterialGroupDeleteBusiServiceImpl
implements MmcFitmentMaterialGroupDeleteBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SequenceManagement sequenceManagement;
    @Autowired
    private MmcFitmentRelMaterialShopGroupMapper mmcFitmentRelMaterialShopGroupMapper;
    @Autowired
    private MmcFitmentMaterialListQueryAtomService mmcFitmentMaterialListQueryAtomService;
    @Autowired
    private MmcFitmentMaterialGroupAddAtomService mmcFitmentMaterialGroupAddAtomService;
    @Autowired
    private MmcFitmentMaterialInfoUpdateAtomService mmcFitmentMaterialInfoUpdateAtomService;

    public MmcFitmentMaterialGroupDeleteBusiRspBo deleteGroup(MmcFitmentMaterialGroupDeleteBusiReqBo reqBo) {
        this.LOGGER.info("\u5e97\u94fa\u88c5\u4fee-\u7d20\u6750\u5206\u7ec4-\u5220\u9664 busi\u670d\u52a1\uff1a" + reqBo);
        MmcFitmentMaterialGroupDeleteBusiRspBo retBo = new MmcFitmentMaterialGroupDeleteBusiRspBo();
        MmcFitmentRelMaterialShopGroupPo qryGroupReqPo = new MmcFitmentRelMaterialShopGroupPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)qryGroupReqPo);
        MmcFitmentRelMaterialShopGroupPo qryGroupRetPo = this.mmcFitmentRelMaterialShopGroupMapper.selectByPrimaryKeyOrIndex(qryGroupReqPo);
        if (qryGroupRetPo == null) {
            this.LOGGER.error("\u7d20\u6750\u5206\u7ec4\uff1a\u5206\u7ec4ID:" + reqBo.getGroupId() + "\u4e0d\u5b58\u5728");
            retBo.setRespCode("2021");
            retBo.setRespDesc("\u7d20\u6750\u5206\u7ec4\uff1a\u5206\u7ec4ID:" + reqBo.getGroupId() + "\u4e0d\u5b58\u5728");
            return retBo;
        }
        if ("1".equals(qryGroupRetPo.getDefaultGroup() + "")) {
            this.LOGGER.error("\u6b64\u5206\u5206\u7ec4\u662f\u9ed8\u8ba4\u5206\u7ec4\uff0c\u4e0d\u53ef\u5220\u9664");
            retBo.setRespCode("2021");
            retBo.setRespDesc("\u7d20\u6750\u5206\u7ec4\uff1a\u6b64\u5206\u5206\u7ec4\u662f\u9ed8\u8ba4\u5206\u7ec4\uff0c\u4e0d\u53ef\u5220\u9664");
            return retBo;
        }
        int groupType = qryGroupRetPo.getGroupType();
        MmcFitmentMaterialListQueryAtomReqBo qryMaterialReqBo = new MmcFitmentMaterialListQueryAtomReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)qryMaterialReqBo);
        qryMaterialReqBo.setGroupType(groupType);
        MmcFitmentMaterialListQueryAtomRspBo qryMaterialRetBo = this.mmcFitmentMaterialListQueryAtomService.queryMaterial(qryMaterialReqBo);
        List<MmcFitmentMaterialInfoAtomDataBo> materials = qryMaterialRetBo.getMaterials();
        if (CollectionUtils.isEmpty(materials)) {
            this.LOGGER.info("\u8be5\u5206\u7ec4\u4e0b\u6ca1\u6709\u7d20\u6750\uff0c\u76f4\u63a5\u5220\u9664\u6b64\u5206\u7ec4");
            this.removeGroup(reqBo);
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u6210\u529f");
            return retBo;
        }
        Long defaultGroupId = this.getDefaultGroupId(reqBo, groupType);
        this.removeMaterial(defaultGroupId, materials);
        this.removeGroup(reqBo);
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private Long getDefaultGroupId(MmcFitmentMaterialGroupDeleteBusiReqBo reqBo, int groupType) {
        MmcFitmentRelMaterialShopGroupPo qryDefaultGroupReqPo = new MmcFitmentRelMaterialShopGroupPo();
        qryDefaultGroupReqPo.setShopId(reqBo.getShopId());
        qryDefaultGroupReqPo.setGroupType(groupType);
        qryDefaultGroupReqPo.setDefaultGroup(Integer.valueOf("1"));
        List<MmcFitmentRelMaterialShopGroupPo> qryDefaultGroupRetPo = this.mmcFitmentRelMaterialShopGroupMapper.selectByCondition(qryDefaultGroupReqPo);
        if (CollectionUtils.isEmpty(qryDefaultGroupRetPo)) {
            long defaultGroupId;
            this.LOGGER.info("\u6ca1\u6709\u67e5\u8be2\u5230\u9ed8\u8ba4\u5206\u7ec4\uff0c\u5c06\u65b0\u589e\u4e00\u4e2a\u9ed8\u8ba4\u5206\u7ec4");
            MmcFitmentMaterialGroupAddAtomReqBo addGroupReqBo = new MmcFitmentMaterialGroupAddAtomReqBo();
            try {
                defaultGroupId = this.sequenceManagement.nextId(MmcSequencesEnum.SEQUENCE_FITMENT_REL_MATERIAL_SHOP_GROUP_ID.toString());
            }
            catch (SQLException e) {
                this.LOGGER.error("\u65b0\u589e\u9ed8\u8ba4\u5206\u7ec4\u65f6\uff0c\u83b7\u53d6\u4e3b\u952e\u5f02\u5e38\uff1a" + e.getMessage());
                throw new MmcBusinessException("6008", "\u65b0\u589e\u9ed8\u8ba4\u5206\u7ec4\u65f6\uff0c\u83b7\u53d6\u4e3b\u952e\u5f02\u5e38\uff1a" + e.getMessage());
            }
            addGroupReqBo.setShopId(reqBo.getShopId());
            addGroupReqBo.setGroupType(groupType);
            addGroupReqBo.setGroupId(defaultGroupId);
            addGroupReqBo.setGroupName("\u9ed8\u8ba4\u5206\u7ec4");
            addGroupReqBo.setDefaultGroup(Integer.valueOf("1"));
            MmcFitmentMaterialGroupAddAtomRspBo addGroupRetBo = this.mmcFitmentMaterialGroupAddAtomService.addGroup(addGroupReqBo);
            if (!"0000".equals(addGroupRetBo.getRespCode())) {
                this.LOGGER.error("\u8c03\u7528\u5e97\u94fa\u88c5\u4fee-\u7d20\u6750\u5206\u7ec4-\u65b0\u589e Atom\u670d\u52a1\u65b0\u589e\u9ed8\u8ba4\u5206\u7ec4\u5931\u8d25\uff1a" + addGroupRetBo.getRespDesc());
                throw new MmcBusinessException("6008", "\u8c03\u7528\u5e97\u94fa\u88c5\u4fee-\u7d20\u6750\u5206\u7ec4-\u65b0\u589e Atom\u670d\u52a1\u65b0\u589e\u9ed8\u8ba4\u5206\u7ec4\u5931\u8d25\uff1a" + addGroupRetBo.getRespDesc());
            }
            return defaultGroupId;
        }
        long defaultGroupId = qryDefaultGroupRetPo.get(0).getGroupId();
        return defaultGroupId;
    }

    private void removeMaterial(Long defaultGroupId, List<MmcFitmentMaterialInfoAtomDataBo> materials) {
        MmcFitmentMaterialInfoUpdateAtomReqBo materialUpdateReqBo = new MmcFitmentMaterialInfoUpdateAtomReqBo();
        for (MmcFitmentMaterialInfoAtomDataBo material : materials) {
            BeanUtils.copyProperties((Object)material, (Object)materialUpdateReqBo);
            materialUpdateReqBo.setGroupId(defaultGroupId);
            MmcFitmentMaterialInfoUpdateAtomRspBo materialUpdateRetBo = this.mmcFitmentMaterialInfoUpdateAtomService.updateMaterial(materialUpdateReqBo);
            if ("0000".equals(materialUpdateRetBo.getRespCode())) continue;
            this.LOGGER.error("\u8c03\u7528\u5e97\u94fa\u88c5\u4fee-\u7d20\u6750\u4fe1\u606f-\u66f4\u65b0 Atom\u670d\u52a1\u66f4\u65b0\u5931\u8d25\uff1a" + materialUpdateRetBo.getRespDesc());
            throw new MmcBusinessException("6008", "\u8c03\u7528\u5e97\u94fa\u88c5\u4fee-\u7d20\u6750\u4fe1\u606f-\u66f4\u65b0 Atom\u670d\u52a1\u66f4\u65b0\u5931\u8d25\uff1a" + materialUpdateRetBo.getRespDesc());
        }
    }

    private void removeGroup(MmcFitmentMaterialGroupDeleteBusiReqBo reqBo) {
        MmcFitmentRelMaterialShopGroupPo deleteReqPo = new MmcFitmentRelMaterialShopGroupPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)deleteReqPo);
        int result = this.mmcFitmentRelMaterialShopGroupMapper.deleteByPrimaryKeyOrIndex(deleteReqPo);
        if (result < 1) {
            this.LOGGER.error("\u8c03\u7528mapper\u5220\u9664\u5206\u7ec4\u5931\u8d25\uff0c\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            throw new MmcBusinessException("6008", "\u8c03\u7528mapper\u5220\u9664\u5206\u7ec4\u5931\u8d25\uff0c\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
    }
}

