/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.busi.impl;

import com.tydic.merchant.mmc.ability.bo.MmcFitmentSelfComponentCreateAbilityReqBo;
import com.tydic.merchant.mmc.ability.bo.MmcFitmentSelfComponentCreateAbilityReqComponentsDataBo;
import com.tydic.merchant.mmc.ability.bo.MmcFitmentSelfComponentCreateAbilityReqComponentsPropertiesDataBo;
import com.tydic.merchant.mmc.busi.MmcFitmentSelfComponentCreateBusiService;
import com.tydic.merchant.mmc.busi.bo.MmcFitmentSelfComponentCreateBusiRspBo;
import com.tydic.merchant.mmc.common.exception.MmcBusinessException;
import com.tydic.merchant.mmc.constants.MmcFitmentDicValueConstants;
import com.tydic.merchant.mmc.dao.MmcFitmentRelSelfComponentMapper;
import com.tydic.merchant.mmc.dao.MmcFitmentRelSelfComponentPropertiesMapper;
import com.tydic.merchant.mmc.dao.MmcFitmentShopSelfComponentMapper;
import com.tydic.merchant.mmc.dao.MmcInfoMerchantMapper;
import com.tydic.merchant.mmc.dao.po.MmcFitmentRelSelfComponentPo;
import com.tydic.merchant.mmc.dao.po.MmcFitmentRelSelfComponentPropertiesPo;
import com.tydic.merchant.mmc.dao.po.MmcFitmentShopSelfComponentPo;
import com.tydic.merchant.mmc.enums.MmcSequencesEnum;
import com.tydic.merchant.mmc.utils.MmcRspBoUtil;
import com.tydic.starter.sequence.autoconfiguration.SequenceManagement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MmcFitmentSelfComponentCreateBusiServiceImpl
implements MmcFitmentSelfComponentCreateBusiService {
    @Autowired
    private MmcFitmentShopSelfComponentMapper mmcFitmentShopSelfComponentMapper;
    @Autowired
    private MmcFitmentRelSelfComponentMapper mmcFitmentRelSelfComponentMapper;
    @Autowired
    private MmcFitmentRelSelfComponentPropertiesMapper mmcFitmentRelSelfComponentPropertiesMapper;
    @Autowired
    private SequenceManagement sequenceManagement;
    @Autowired
    private MmcInfoMerchantMapper mmcInfoMerchantMapper;

    public MmcFitmentSelfComponentCreateBusiRspBo saveComponent(MmcFitmentSelfComponentCreateAbilityReqBo reqBo) {
        Date now = this.mmcInfoMerchantMapper.getDbDate().getDate();
        MmcFitmentSelfComponentCreateBusiRspBo rspBo = MmcRspBoUtil.genSuccessBo(MmcFitmentSelfComponentCreateBusiRspBo.class);
        MmcFitmentShopSelfComponentPo insertComPo = new MmcFitmentShopSelfComponentPo();
        Long shopId = reqBo.getShopId();
        Long componentId = 0L;
        try {
            componentId = this.sequenceManagement.nextId(MmcSequencesEnum.MMC_FITMENT_SHOP_SELF_COMPONENT_ID.toString());
        }
        catch (SQLException e) {
            throw new MmcBusinessException("6011", "\u83b7\u53d6\u81ea\u5b9a\u4e49\u7ec4\u4ef6-\u4e3b\u952e\u5f02\u5e38", (Throwable)e);
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)insertComPo);
        insertComPo.setComponentId(componentId);
        insertComPo.setCreateTime(now);
        insertComPo.setAdvertising(Integer.parseInt("0"));
        int insertCompRet = this.mmcFitmentShopSelfComponentMapper.insert(insertComPo);
        if (insertCompRet < 1) {
            throw new MmcBusinessException("6011", "\u63d2\u5165\u81ea\u5b9a\u4e49\u7ec4\u4ef6\u5f02\u5e38\uff1a\u8fd4\u56de\u503c\u4e0d\u4e3a1");
        }
        rspBo.setComponentId(componentId);
        this.insertComponentAndProperty(reqBo.getComponents(), shopId, componentId, 0L);
        return rspBo;
    }

    public void insertComponentAndProperty(List<MmcFitmentSelfComponentCreateAbilityReqComponentsDataBo> components, Long shopId, Long componentId, Long parentId) {
        int sortNo = 0;
        for (MmcFitmentSelfComponentCreateAbilityReqComponentsDataBo component : components) {
            Long compRelId = 0L;
            try {
                compRelId = this.sequenceManagement.nextId(MmcSequencesEnum.MMC_FITMENT_REL_SELF_COMPONENT_ID.toString());
            }
            catch (SQLException e) {
                throw new MmcBusinessException("6011", "\u83b7\u53d6\u81ea\u5b9a\u4e49\u7ec4\u4ef6-\u7cfb\u7edf\u7ec4\u4ef6\u5173\u7cfb\u4e3b\u952e\u5f02\u5e38", (Throwable)e);
            }
            MmcFitmentRelSelfComponentPo insertRelPo = new MmcFitmentRelSelfComponentPo();
            insertRelPo.setRelId(compRelId);
            insertRelPo.setParentId(parentId);
            insertRelPo.setShopId(shopId);
            insertRelPo.setComponentId(componentId);
            insertRelPo.setStatusFlag(MmcFitmentDicValueConstants.MMC_FITMENT_REL_SELF_COMPONENT_STATUS_FLAG_YES);
            insertRelPo.setSortNo(sortNo);
            insertRelPo.setComponentCode(component.getComponentCode());
            int insertRelRet = this.mmcFitmentRelSelfComponentMapper.insert(insertRelPo);
            if (insertRelRet < 1) {
                throw new MmcBusinessException("6011", "\u63d2\u5165\u81ea\u5b9a\u4e49\u7ec4\u4ef6-\u7cfb\u7edf\u7ec4\u4ef6\u5173\u7cfb\u5f02\u5e38\uff1a\u8fd4\u56de\u503c\u4e0d\u4e3a1");
            }
            List properties = component.getProperties();
            for (MmcFitmentSelfComponentCreateAbilityReqComponentsPropertiesDataBo property : properties) {
                Long propertyId = 0L;
                try {
                    propertyId = this.sequenceManagement.nextId(MmcSequencesEnum.MMC_FITMENT_REL_SELF_COMPONENT_PROPERTIES_ID.toString());
                }
                catch (SQLException e) {
                    throw new MmcBusinessException("6011", "\u83b7\u53d6\u81ea\u5b9a\u4e49\u7ec4\u4ef6-\u7cfb\u7edf\u7ec4\u4ef6\u5173\u7cfb-\u5c5e\u6027 \u4e3b\u952e\u5f02\u5e38", (Throwable)e);
                }
                MmcFitmentRelSelfComponentPropertiesPo insertProPo = new MmcFitmentRelSelfComponentPropertiesPo();
                insertProPo.setPropertyId(propertyId);
                insertProPo.setShopId(shopId);
                insertProPo.setComponentId(componentId);
                insertProPo.setRelId(compRelId);
                insertProPo.setSortNo(0);
                insertProPo.setComponentCode(component.getComponentCode());
                insertProPo.setPropertyCode(property.getPropertyCode());
                insertProPo.setPropertyValue(property.getPropertyValue());
                int insertProRet = this.mmcFitmentRelSelfComponentPropertiesMapper.insert(insertProPo);
                if (insertProRet >= 1) continue;
                throw new MmcBusinessException("6011", "\u63d2\u5165\u81ea\u5b9a\u4e49\u7ec4\u4ef6-\u7cfb\u7edf\u7ec4\u4ef6-\u5c5e\u6027 \u5f02\u5e38\uff1a\u8fd4\u56de\u503c\u4e0d\u4e3a1");
            }
            if (!CollectionUtils.isEmpty((Collection)component.getChildren())) {
                this.insertComponentAndProperty(component.getChildren(), shopId, componentId, compRelId);
            }
            ++sortNo;
        }
    }
}

