/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.busi.impl;

import com.tydic.merchant.mmc.busi.MmcShopDeployBusiService;
import com.tydic.merchant.mmc.busi.bo.MmcShopDeployBusiReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopDeployBusiRspBo;
import com.tydic.merchant.mmc.common.exception.MmcBusinessException;
import com.tydic.merchant.mmc.dao.MmcInfoMerchantMapper;
import com.tydic.merchant.mmc.dao.MmcInfoShopMapper;
import com.tydic.merchant.mmc.dao.po.MmcInfoShopPo;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="mmcShopDeployBusiService")
public class MmcShopDeployBusiServiceImpl
implements MmcShopDeployBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MmcInfoShopMapper mmcInfoShopMapper;
    @Autowired
    private MmcInfoMerchantMapper mmcInfoMerchantMapper;

    public MmcShopDeployBusiRspBo dealShopDeploy(MmcShopDeployBusiReqBo reqBo) {
        this.LOGGER.info("\u5e97\u94fa\u64cd\u4f5cbusi\u670d\u52a1\uff1a" + reqBo);
        MmcShopDeployBusiRspBo retBo = new MmcShopDeployBusiRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("2005");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        this.filterOrder(reqBo);
        MmcInfoShopPo po = new MmcInfoShopPo();
        Date nowTime = this.mmcInfoMerchantMapper.getDbDate().getDate();
        po.setUpdateTime(nowTime);
        po.setStatus(Integer.parseInt("4"));
        if ("1".equals(reqBo.getAction())) {
            po.setStatus(Integer.parseInt("3"));
        }
        for (Long id : reqBo.getShopList()) {
            po.setShopId(id);
            int reslut = this.mmcInfoShopMapper.updateForShopDeploy(po);
            if (reslut >= 1) continue;
            this.LOGGER.error("\u64cd\u4f5c\u5e97\u94fa\uff08" + id + "\uff09\u5931\u8d25");
            throw new MmcBusinessException("6007", "\u64cd\u4f5c\u5e97\u94fa\uff08" + id + "\uff09\u5931\u8d25");
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private void filterOrder(MmcShopDeployBusiReqBo reqBo) {
        for (Long id : reqBo.getShopList()) {
            MmcInfoShopPo retPo = this.mmcInfoShopMapper.selectByPrimaryKey(id);
            if (retPo == null) {
                this.LOGGER.error("\u672a\u67e5\u8be2\u5230shopId(" + id + ")\u7684\u76f8\u5173\u4fe1\u606f");
                throw new MmcBusinessException("6007", "\u672a\u67e5\u8be2\u5230shopId(" + id + ")\u7684\u76f8\u5173\u4fe1\u606f");
            }
            if ("0".equals(reqBo.getAction()) && !"3".equals(retPo.getStatus() + "")) {
                this.LOGGER.error("\u5e97\u94fa\uff08" + id + "\uff09\u72b6\u6001\u975e\u5f85\u90e8\u7f72");
                throw new MmcBusinessException("6007", "\u5e97\u94fa\uff08" + id + "\uff09\u72b6\u6001\u975e\u5f85\u90e8\u7f72");
            }
            if (!"1".equals(reqBo.getAction()) || "4".equals(retPo.getStatus() + "")) continue;
            this.LOGGER.error("\u5e97\u94fa\uff08" + id + "\uff09\u72b6\u6001\u975e\u8425\u4e1a\u4e2d\u4e0d\u53ef\u8fdb\u884c\u64a4\u5e97\u64cd\u4f5c");
            throw new MmcBusinessException("6007", "\u5e97\u94fa\uff08" + id + "\uff09\u72b6\u6001\u975e\u8425\u4e1a\u4e2d\u4e0d\u53ef\u8fdb\u884c\u64a4\u5e97\u64cd\u4f5c");
        }
    }

    private String validateArgs(MmcShopDeployBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getShopList())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'shopList'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getAction())) {
            throw new MmcBusinessException("6007", "\u5185\u90e8\u670d\u52a1\u9519\u8bef:'action'\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return null;
    }
}

