/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.busi.impl;

import com.tydic.merchant.mmc.atom.api.MmcAuditRequestAtomService;
import com.tydic.merchant.mmc.atom.api.MmcShopChannelCreateAtomService;
import com.tydic.merchant.mmc.atom.bo.MmcAuditRequestAtomReqBo;
import com.tydic.merchant.mmc.atom.bo.MmcAuditRequestAtomRspBo;
import com.tydic.merchant.mmc.atom.bo.MmcShopChannelCreateAtomReqBo;
import com.tydic.merchant.mmc.atom.bo.MmcShopChannelCreateAtomRspBo;
import com.tydic.merchant.mmc.busi.MmcShopSaveBusiService;
import com.tydic.merchant.mmc.busi.bo.MmcShopSaveBusiMerchantReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopSaveBusiReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopSaveBusiRspBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopSaveBusiShopReqBo;
import com.tydic.merchant.mmc.common.exception.MmcBusinessException;
import com.tydic.merchant.mmc.dao.MmcInfoMerchantMapper;
import com.tydic.merchant.mmc.dao.MmcInfoShopMapper;
import com.tydic.merchant.mmc.dao.MmcRelShopTemplateMapper;
import com.tydic.merchant.mmc.dao.MmcRuleTemplateMapper;
import com.tydic.merchant.mmc.dao.po.MmcInfoMerchantPo;
import com.tydic.merchant.mmc.dao.po.MmcInfoShopPo;
import com.tydic.merchant.mmc.dao.po.MmcRelShopTemplatePo;
import com.tydic.merchant.mmc.dao.po.MmcRuleTemplatePo;
import com.tydic.merchant.mmc.enums.MmcSequencesEnum;
import com.tydic.starter.sequence.autoconfiguration.SequenceManagement;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="mmcShopSaveBusiService")
public class MmcShopSaveBusiServiceImpl
implements MmcShopSaveBusiService {
    @Value(value="${mmc.approval.shop.request.prokey}")
    private String shopRequestProKey;
    @Value(value="${CALL_PRC_SYS_CODE}")
    private String approvalSysCode;
    @Autowired
    private MmcInfoShopMapper mmcInfoShopMapper;
    @Autowired
    private MmcInfoMerchantMapper mmcInfoMerchantMapper;
    @Autowired
    private MmcRelShopTemplateMapper mmcRelShopTemplateMapper;
    @Autowired
    private MmcRuleTemplateMapper mmcRuleTemplateMapper;
    @Autowired
    private SequenceManagement sequenceManagement;
    @Autowired
    private MmcShopChannelCreateAtomService mmcShopChannelCreateAtomService;
    @Autowired
    private MmcAuditRequestAtomService mmcAuditRequestAtomService;
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    public MmcShopSaveBusiRspBo createShop(MmcShopSaveBusiReqBo reqBo) {
        MmcShopSaveBusiRspBo rspBo = new MmcShopSaveBusiRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            rspBo.setRespCode("2007");
            rspBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return rspBo;
        }
        Date dbDate = this.mmcInfoShopMapper.getDbDate();
        MmcShopSaveBusiShopReqBo shopInfo = reqBo.getShopInfo();
        this.createMerchant(reqBo, dbDate);
        MmcInfoMerchantPo merchantPo = this.mmcInfoMerchantMapper.selectByPrimaryKey(shopInfo.getMerchantId());
        if (merchantPo == null) {
            throw new MmcBusinessException("6002", "\u5546\u6237(" + shopInfo.getMerchantId() + ")\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        Long shopId = this.createShopInfo(dbDate, shopInfo);
        this.createShopChannelInfo(dbDate, shopInfo, shopId);
        this.createShopTemplate(dbDate, shopId);
        if (reqBo.isAudit()) {
            MmcAuditRequestAtomReqBo auditBo = this.assembleAuditBo(reqBo, shopId.toString());
            MmcAuditRequestAtomRspBo auditRspBo = this.mmcAuditRequestAtomService.auditRequest(auditBo);
            if (!"0000".equals(auditRspBo.getRespCode())) {
                throw new MmcBusinessException("6003", "\u8c03\u7528\u5ba1\u6279\u670d\u52a1\u9519\u8bef\uff1a" + auditRspBo.getRespDesc());
            }
            MmcInfoShopPo updateShopBo = new MmcInfoShopPo();
            updateShopBo.setShopId(shopId);
            updateShopBo.setStatus(Integer.parseInt("2"));
            this.mmcInfoShopMapper.updateByPrimaryKeySelective(updateShopBo);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setShopId(shopId);
        rspBo.setCreateTime(dbDate);
        rspBo.setMerchantId(shopInfo.getMerchantId());
        rspBo.setShopLogo(shopInfo.getShopLogo());
        rspBo.setShopName(shopInfo.getShopName());
        rspBo.setShopSpecialty(shopInfo.getShopSpecialty());
        return rspBo;
    }

    private MmcAuditRequestAtomReqBo assembleAuditBo(MmcShopSaveBusiReqBo reqBo, String shopId) {
        MmcAuditRequestAtomReqBo auditBo = new MmcAuditRequestAtomReqBo();
        auditBo.setProcDefKey(this.shopRequestProKey);
        auditBo.setSysCode(this.approvalSysCode);
        auditBo.setCreateOperId(reqBo.getShopInfo().getCreateOper());
        auditBo.setCreateOperName(reqBo.getShopInfo().getCreateOper());
        auditBo.setRemark("\u5e97\u94fa(" + shopId + ")\u5f00\u5e97\u5ba1\u6279");
        auditBo.setObjId(shopId);
        auditBo.setObjType(Integer.parseInt("1"));
        auditBo.setObjCode(shopId);
        auditBo.setObjName(shopId + "_Name");
        return auditBo;
    }

    private void createShopTemplate(Date dbDate, Long shopId) {
        Long relShopTempId;
        MmcRelShopTemplatePo insertShopTempPo = new MmcRelShopTemplatePo();
        try {
            relShopTempId = this.sequenceManagement.nextId(MmcSequencesEnum.SEQUENCE_REL_SHOP_TEMPLATE_ID.toString());
        }
        catch (SQLException e) {
            throw new MmcBusinessException("6002", "\u83b7\u53d6\u5e97\u94fa-\u6a21\u677f\u5173\u7cfbID\u5f02\u5e38", (Throwable)e);
        }
        MmcRuleTemplatePo queryTempPo = new MmcRuleTemplatePo();
        queryTempPo.setDefaultTemplate(Integer.parseInt("1"));
        List<MmcRuleTemplatePo> mmcRuleTemplatePos = this.mmcRuleTemplateMapper.selectByCondition(queryTempPo);
        if (mmcRuleTemplatePos == null || mmcRuleTemplatePos.isEmpty()) {
            throw new MmcBusinessException("6002", "\u83b7\u53d6\u5e97\u94fa\u6a21\u677f\u5f02\u5e38\uff0c\u5e97\u94fa\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        insertShopTempPo.setTemplateId(mmcRuleTemplatePos.get(0).getTemplateId());
        insertShopTempPo.setType(Integer.parseInt("1"));
        insertShopTempPo.setCreateTime(dbDate);
        insertShopTempPo.setRelId(relShopTempId);
        insertShopTempPo.setRemark("\u5e97\u94fa\u521b\u5efa\u6a21\u677f");
        insertShopTempPo.setShopId(shopId);
        insertShopTempPo.setStatus(Integer.parseInt("1"));
        int insertShopTempResult = this.mmcRelShopTemplateMapper.insert(insertShopTempPo);
        if (insertShopTempResult < 1) {
            throw new MmcBusinessException("6002", "\u63d2\u5165\u5e97\u94fa\u9ed8\u8ba4\u6a21\u677f\u5f02\u5e38\uff1a\u63d2\u5165\u8fd4\u56de\u503c<1");
        }
    }

    private void createMerchant(MmcShopSaveBusiReqBo reqBo, Date dbDate) {
        if ("1".equals(reqBo.getCreatedMerchant())) {
            MmcInfoMerchantPo merchantPo;
            MmcShopSaveBusiShopReqBo shopInfo = reqBo.getShopInfo();
            MmcShopSaveBusiMerchantReqBo merchantInfo = reqBo.getMerchantInfo();
            try {
                merchantPo = this.generateMerchantInfo(merchantInfo);
            }
            catch (SQLException e) {
                throw new MmcBusinessException("6002", "\u7ec4\u88c5\u5546\u6237\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            }
            merchantPo.setCreateTime(dbDate);
            int insertMerchant = this.mmcInfoMerchantMapper.insert(merchantPo);
            if (insertMerchant < 1) {
                throw new MmcBusinessException("6002", "\u63d2\u5165\u5546\u6237\u5f02\u5e38\uff1a\u63d2\u5165\u8fd4\u56de\u503c<1");
            }
            shopInfo.setMerchantId(merchantPo.getMerchantId());
        }
        this.LOGGER.info("\u4e0d\u9700\u8981\u521b\u5efa\u5546\u6237(\u5546\u6237\u521b\u5efabusi\u670d\u52a1)");
    }

    private Long createShopInfo(Date dbDate, MmcShopSaveBusiShopReqBo shopInfo) {
        int insertShop;
        Long shopId;
        MmcInfoShopPo shopPo = new MmcInfoShopPo();
        BeanUtils.copyProperties((Object)shopInfo, (Object)shopPo);
        try {
            shopId = this.sequenceManagement.nextId(MmcSequencesEnum.SEQUENCE_SHOP_ID.toString());
        }
        catch (SQLException e) {
            throw new MmcBusinessException("6002", "\u83b7\u53d6\u5e97\u94faID\u5f02\u5e38", (Throwable)e);
        }
        shopPo.setShopId(shopId);
        shopPo.setCreateTime(dbDate);
        if (shopInfo.getExpireTime() == null) {
            shopPo.setExpireTime(new DateTime((Object)dbDate).plusYears(1).toDate());
        }
        if ((insertShop = this.mmcInfoShopMapper.insert(shopPo)) < 1) {
            throw new MmcBusinessException("6002", "\u63d2\u5165\u5e97\u94fa\u5f02\u5e38\uff1a\u63d2\u5165\u8fd4\u56de\u503c<1");
        }
        return shopId;
    }

    private void createShopChannelInfo(Date dbDate, MmcShopSaveBusiShopReqBo shopInfo, Long shopId) {
        List channels = shopInfo.getChannel();
        if (channels != null && !channels.isEmpty()) {
            MmcShopChannelCreateAtomReqBo createChannelBo = new MmcShopChannelCreateAtomReqBo();
            createChannelBo.setChannels(channels);
            createChannelBo.setCreateDate(dbDate);
            createChannelBo.setRemark("\u5e97\u94fa\u521b\u5efa\u5199\u5165\u6e20\u9053");
            createChannelBo.setShopId(shopId);
            createChannelBo.setType("1");
            MmcShopChannelCreateAtomRspBo creteShopChannelRspBo = this.mmcShopChannelCreateAtomService.createShopChannel(createChannelBo);
            if (!"0000".equals(creteShopChannelRspBo.getRespCode())) {
                throw new MmcBusinessException("6002", "\u63d2\u5165\u5e97\u94fa-\u6e20\u9053\u9519\u8bef\uff1a" + creteShopChannelRspBo.getRespDesc());
            }
        }
    }

    private MmcInfoMerchantPo generateMerchantInfo(MmcShopSaveBusiMerchantReqBo merchantInfo) throws SQLException {
        MmcInfoMerchantPo merchantPo = new MmcInfoMerchantPo();
        BeanUtils.copyProperties((Object)merchantInfo, (Object)merchantPo);
        long merchantId = this.sequenceManagement.nextId(MmcSequencesEnum.SEQUENCE_MERCHANT_ID.toString());
        merchantPo.setMerchantId(merchantId);
        return merchantPo;
    }

    private String validateArg(MmcShopSaveBusiReqBo reqBo) {
        String validateMerchantResult;
        if (reqBo == null) {
            return "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if ("1".equals(reqBo.getCreatedMerchant()) && !StringUtils.isEmpty((Object)(validateMerchantResult = this.validateMerchantInfo(reqBo.getMerchantInfo())))) {
            return validateMerchantResult;
        }
        String validateShop = this.validateShopInfo(reqBo.getShopInfo(), reqBo);
        if (!StringUtils.isEmpty((Object)validateShop)) {
            return validateShop;
        }
        return null;
    }

    private String validateShopInfo(MmcShopSaveBusiShopReqBo shopInfo, MmcShopSaveBusiReqBo reqBo) {
        if (shopInfo == null) {
            return "\u5165\u53c2\u5c5e\u6027shopInfo\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!"1".equals(reqBo.getCreatedMerchant()) && StringUtils.isEmpty((Object)shopInfo.getMerchantId())) {
            return "\u5165\u53c2\u5c5e\u6027shopInfo\u7684\u5c5e\u6027merchantId\u4e0d\u80fd\u4e3a\u7a7a(\u5f53\u4f7f\u7528\u5df2\u6709\u5546\u6237\u65f6)";
        }
        if (StringUtils.isEmpty((Object)shopInfo.getOrgId())) {
            return "\u5165\u53c2\u5c5e\u6027shopInfo\u7684\u5c5e\u6027orgId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)shopInfo.getShopName())) {
            return "\u5165\u53c2\u5c5e\u6027shopInfo\u7684\u5c5e\u6027shopName\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)shopInfo.getStatus())) {
            shopInfo.setStatus(Integer.valueOf(Integer.parseInt("1")));
        }
        return null;
    }

    private String validateMerchantInfo(MmcShopSaveBusiMerchantReqBo merchantInfo) {
        if (merchantInfo == null) {
            return "\u5f53\u9700\u8981\u521b\u5efa\u5546\u6237\u65f6\uff0c\u5c5e\u6027merchantInfo\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)merchantInfo.getMerchantName())) {
            return "\u5c5e\u6027merchantName\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

