/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.busi.impl;

import com.tydic.merchant.mmc.busi.MmcShopSetingApproveBusiService;
import com.tydic.merchant.mmc.busi.bo.MmcShopSetingApproveBusiReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopSetingApproveBusiRspBo;
import com.tydic.merchant.mmc.common.exception.MmcBusinessException;
import com.tydic.merchant.mmc.dao.MmcInfoShopMapper;
import com.tydic.merchant.mmc.dao.MmcRelShopSettingMapper;
import com.tydic.merchant.mmc.dao.po.MmcInfoShopPo;
import com.tydic.merchant.mmc.dao.po.MmcRelShopSettingPo;
import com.tydic.merchant.mmc.dao.po.MmcShopApproveListQueryPo;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uac.bo.common.UacNoneInstanceBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="mmcShopSettingApproveBusiService")
public class MmcShopSetingApproveBusiServiceImpl
implements MmcShopSetingApproveBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MmcRelShopSettingMapper mmcRelShopSettingMapper;
    @Autowired
    private MmcInfoShopMapper mmcInfoShopMapper;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;

    public MmcShopSetingApproveBusiRspBo updateShopStatus(MmcShopSetingApproveBusiReqBo reqBo) {
        this.LOGGER.info("\u5e97\u94fa\u8bbe\u7f6e\u4e2d\u5ba1\u6279busi\u670d\u52a1\uff1a" + reqBo);
        MmcShopSetingApproveBusiRspBo retBo = new MmcShopSetingApproveBusiRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("2016");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        for (Long shopId : reqBo.getApproveIds()) {
            MmcShopApproveListQueryPo queryPo = new MmcShopApproveListQueryPo();
            queryPo.setShopId(shopId);
            queryPo.setSetStatus(Integer.parseInt("2"));
            queryPo.setType(Integer.parseInt("2"));
            MmcRelShopSettingPo rspPo = this.mmcRelShopSettingMapper.selectTacheCodeByShopId(queryPo);
            if (rspPo == null) {
                this.LOGGER.error("\u83b7\u53d6\u5e97\u94fa\uff08" + shopId + "\uff09\u7684\u6b65\u9aa4ID\u5931\u8d25");
                throw new MmcBusinessException("6006", "\u83b7\u53d6\u5e97\u94fa\uff08" + shopId + "\uff09\u7684\u6b65\u9aa4ID\u5931\u8d25");
            }
            boolean isFinish = this.uacShopApprove(rspPo, reqBo, shopId);
            if (!isFinish) continue;
            this.updateInfo(rspPo, reqBo, shopId);
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private boolean uacShopApprove(MmcRelShopSettingPo rspPo, MmcShopSetingApproveBusiReqBo reqBo, Long shopId) {
        UacNoTaskAuditOrderAuditRspBO uacRspBo;
        boolean isFinish = true;
        UacNoTaskAuditOrderAuditReqBO uacReqBo = new UacNoTaskAuditOrderAuditReqBO();
        ArrayList<Long> objIds = new ArrayList<Long>();
        objIds.add(rspPo.getSettingId());
        uacReqBo.setStepId(rspPo.getTacheCode());
        uacReqBo.setOperId(reqBo.getUserId());
        uacReqBo.setAuditAdvice(reqBo.getDesc());
        uacReqBo.setObjId(objIds);
        uacReqBo.setObjType(Integer.valueOf(Integer.parseInt("2")));
        uacReqBo.setAuditResult(Integer.valueOf(Integer.parseInt("0")));
        if ("2".equals(reqBo.getApproveAction())) {
            uacReqBo.setAuditResult(Integer.valueOf(Integer.parseInt("1")));
        }
        this.LOGGER.error("\u4f20\u5165\u5ba1\u6279API\u7684\u5165\u53c2\uff1a" + uacReqBo);
        try {
            uacRspBo = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(uacReqBo);
        }
        catch (Exception e) {
            this.LOGGER.error("\u8c03\u7528\u5ba1\u6279\u63a5\u53e3\u5931\u8d25\uff1a" + e);
            throw new MmcBusinessException("6005", "\u8c03\u7528\u5ba1\u6279\u63a5\u53e3\u5931\u8d25\uff1a" + e);
        }
        if (!"0000".equals(uacRspBo.getRespCode())) {
            this.LOGGER.error("\u8c03\u7528\u5ba1\u6279\u63a5\u53e3\u5931\u8d25\uff1a" + uacRspBo.getRespDesc());
            throw new MmcBusinessException("6005", "\u8c03\u7528\u5ba1\u6279\u63a5\u53e3\u5931\u8d25\uff1a" + uacRspBo.getRespDesc());
        }
        UacNoneInstanceBO uacNoneInstanceBo = uacRspBo.getNoneInstanceBO();
        if (!uacNoneInstanceBo.getFinish().booleanValue()) {
            isFinish = false;
            this.LOGGER.error("\u5e97\u94fa\uff08" + shopId + "\uff09\u8bbe\u7f6e\u4e2d\u8d44\u6599\u5ba1\u6279\u6d41\u7a0b\u672a\u7ed3\u675f\uff0c\u4e0d\u66f4\u65b0\u4fe1\u606f");
        }
        return isFinish;
    }

    private void updateInfo(MmcRelShopSettingPo rspPo, MmcShopSetingApproveBusiReqBo reqBo, Long shopId) {
        int setResult;
        MmcRelShopSettingPo settingPo = new MmcRelShopSettingPo();
        settingPo.setSettingId(rspPo.getSettingId());
        settingPo.setStatus(Integer.parseInt("2"));
        List<MmcRelShopSettingPo> settingPos = this.mmcRelShopSettingMapper.selectByCondition(settingPo);
        settingPo.setStatus(Integer.parseInt("3"));
        MmcInfoShopPo shopPo = new MmcInfoShopPo();
        BeanUtils.copyProperties((Object)settingPos.get(0), (Object)shopPo);
        shopPo.setStatus(Integer.parseInt("4"));
        if ("2".equals(reqBo.getApproveAction())) {
            settingPo.setStatus(Integer.parseInt("1"));
            shopPo.setStatus(Integer.parseInt("6"));
        }
        if ((setResult = this.mmcRelShopSettingMapper.updateByPrimaryKeySelective(settingPo)) < 1) {
            this.LOGGER.error("\u66f4\u65b0\u5e97\u94fa\uff08" + shopId + "\uff09\u7684\u8bbe\u7f6e\u4e2d\u8d44\u6599\u8868\u7684\u72b6\u6001\u5931\u8d25");
            throw new MmcBusinessException("6005", "\u66f4\u65b0\u5e97\u94fa\uff08" + shopId + "\uff09\u7684\u8bbe\u7f6e\u4e2d\u8d44\u6599\u8868\u7684\u72b6\u6001\u5931\u8d25");
        }
        int result = this.mmcInfoShopMapper.updateByPrimaryKeySelective(shopPo);
        if (result < 1) {
            this.LOGGER.error("\u66f4\u65b0\u5e97\u94fa\uff08" + shopId + "\uff09\u7684\u72b6\u6001\u5931\u8d25");
            throw new MmcBusinessException("6005", "\u66f4\u65b0\u5e97\u94fa\uff08" + shopId + "\uff09\u7684\u72b6\u6001\u5931\u8d25");
        }
    }

    private String validateArgs(MmcShopSetingApproveBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getApproveIds())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'approveIds'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getApproveAction())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'approveAction'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getDesc())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'desc'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOpType())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'opType'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getUserId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'userId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

