/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.busi.impl;

import com.tydic.merchant.mmc.atom.api.MmcAuditRequestAtomService;
import com.tydic.merchant.mmc.atom.api.MmcShopChannelCreateAtomService;
import com.tydic.merchant.mmc.atom.bo.MmcAuditRequestAtomReqBo;
import com.tydic.merchant.mmc.atom.bo.MmcAuditRequestAtomRspBo;
import com.tydic.merchant.mmc.atom.bo.MmcShopChannelCreateAtomReqBo;
import com.tydic.merchant.mmc.atom.bo.MmcShopChannelCreateAtomRspBo;
import com.tydic.merchant.mmc.busi.MmcShopSettingSaveBusiService;
import com.tydic.merchant.mmc.busi.bo.MmcShopSettingSaveBusiReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopSettingSaveBusiRspBo;
import com.tydic.merchant.mmc.common.exception.MmcBusinessException;
import com.tydic.merchant.mmc.dao.MmcInfoShopMapper;
import com.tydic.merchant.mmc.dao.MmcRelShopSettingMapper;
import com.tydic.merchant.mmc.dao.po.MmcInfoShopPo;
import com.tydic.merchant.mmc.dao.po.MmcRelShopSettingPo;
import com.tydic.merchant.mmc.enums.MmcSequencesEnum;
import com.tydic.starter.sequence.autoconfiguration.SequenceManagement;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.joda.time.DateTime;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="mmcShopSettingSaveBusiService")
public class MmcShopSettingSaveBusiServiceImpl
implements MmcShopSettingSaveBusiService {
    @Value(value="${mmc.approval.shop.setting.prokey}")
    private String shopSettingProKey;
    @Value(value="${CALL_PRC_SYS_CODE}")
    private String approvalSysCode;
    @Autowired
    private MmcRelShopSettingMapper mmcRelShopSettingMapper;
    @Autowired
    private MmcInfoShopMapper mmcInfoShopMapper;
    @Autowired
    private MmcShopChannelCreateAtomService mmcShopChannelCreateAtomService;
    @Autowired
    private SequenceManagement sequenceManagement;
    @Autowired
    private MmcAuditRequestAtomService mmcAuditRequestAtomService;

    public MmcShopSettingSaveBusiRspBo saveShopSetting(MmcShopSettingSaveBusiReqBo reqBo) {
        Long settingId;
        MmcShopSettingSaveBusiRspBo rspBo = new MmcShopSettingSaveBusiRspBo();
        String validateArgStr = this.validateReqArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            rspBo.setRespCode("2017");
            rspBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return rspBo;
        }
        Date dbDate = this.mmcInfoShopMapper.getDbDate();
        MmcRelShopSettingPo insertShopPo = new MmcRelShopSettingPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)insertShopPo);
        insertShopPo.setCreateTime(dbDate);
        if (reqBo.getExpireTime() == null) {
            insertShopPo.setExpireTime(new DateTime((Object)dbDate).plusYears(1).toDate());
        }
        try {
            settingId = this.sequenceManagement.nextId(MmcSequencesEnum.SEQUENCE_REL_SHOP_SETTING_ID.toString());
            insertShopPo.setSettingId(settingId);
        }
        catch (SQLException e) {
            throw new MmcBusinessException("6003", "\u83b7\u53d6\u5e97\u94fa-\u8bbe\u7f6eID\u5f02\u5e38", (Throwable)e);
        }
        int insertShopResult = this.mmcRelShopSettingMapper.insert(insertShopPo);
        if (insertShopResult < 1) {
            throw new MmcBusinessException("6003", "\u63d2\u5165\u5e97\u94fa\u8bbe\u7f6e\u4e2d\u8fd4\u56de\u503c\u4e0d\u4e3a1");
        }
        List channels = reqBo.getChannel();
        if (channels != null && !channels.isEmpty()) {
            MmcShopChannelCreateAtomReqBo createChannelBo = new MmcShopChannelCreateAtomReqBo();
            createChannelBo.setChannels(channels);
            createChannelBo.setCreateDate(dbDate);
            createChannelBo.setRemark("\u5e97\u94fa\u8bbe\u7f6e\u521b\u5efa\u5199\u5165\u6e20\u9053");
            createChannelBo.setShopId(reqBo.getShopId());
            createChannelBo.setType("2");
            createChannelBo.setSettingId(settingId);
            MmcShopChannelCreateAtomRspBo creteShopChannelRspBo = this.mmcShopChannelCreateAtomService.createShopChannel(createChannelBo);
            if (!"0000".equals(creteShopChannelRspBo.getRespCode())) {
                throw new MmcBusinessException("6003", "\u63d2\u5165\u5e97\u94fa-\u6e20\u9053\u9519\u8bef\uff1a" + creteShopChannelRspBo.getRespDesc());
            }
        }
        MmcInfoShopPo updateShopBoToSetting = new MmcInfoShopPo();
        updateShopBoToSetting.setShopId(reqBo.getShopId());
        updateShopBoToSetting.setStatus(Integer.parseInt("6"));
        this.mmcInfoShopMapper.updateByPrimaryKeySelective(updateShopBoToSetting);
        if (reqBo.isAudit()) {
            MmcAuditRequestAtomReqBo auditBo = this.assembleAuditBo(reqBo, settingId);
            MmcAuditRequestAtomRspBo auditRspBo = this.mmcAuditRequestAtomService.auditRequest(auditBo);
            if (!"0000".equals(auditRspBo.getRespCode())) {
                throw new MmcBusinessException("6003", "\u8c03\u7528\u5ba1\u6279\u670d\u52a1\u9519\u8bef\uff1a" + auditRspBo.getRespDesc());
            }
            MmcInfoShopPo updateShopBo = new MmcInfoShopPo();
            updateShopBo.setShopId(reqBo.getShopId());
            updateShopBo.setStatus(Integer.parseInt("5"));
            this.mmcInfoShopMapper.updateByPrimaryKeySelective(updateShopBo);
            MmcRelShopSettingPo updateSettingPo = new MmcRelShopSettingPo();
            updateSettingPo.setSettingId(settingId);
            updateSettingPo.setStatus(Integer.parseInt("2"));
            this.mmcRelShopSettingMapper.updateByPrimaryKeySelective(updateSettingPo);
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)rspBo);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        rspBo.setCreateTime(dbDate);
        return rspBo;
    }

    private MmcAuditRequestAtomReqBo assembleAuditBo(MmcShopSettingSaveBusiReqBo reqBo, Long settingId) {
        MmcAuditRequestAtomReqBo auditBo = new MmcAuditRequestAtomReqBo();
        auditBo.setProcDefKey(this.shopSettingProKey);
        auditBo.setSysCode(this.approvalSysCode);
        auditBo.setCreateOperId(reqBo.getCreateOper());
        auditBo.setCreateOperName(reqBo.getCreateOper());
        auditBo.setRemark("\u5e97\u94fa(" + reqBo.getShopId() + ")\u8bbe\u7f6e\u5ba1\u6279");
        auditBo.setObjId(settingId.toString());
        auditBo.setObjType(Integer.parseInt("2"));
        auditBo.setObjCode(reqBo.getShopId().toString());
        auditBo.setObjName(reqBo.getShopName());
        return auditBo;
    }

    private String validateReqArg(MmcShopSettingSaveBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBo.getShopId() == null || reqBo.getShopId() <= 0L) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027shop\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getShopName())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027shopName\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

