/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.ability.impl;

import com.tydic.merchant.mmc.ability.MmcShopRejectAbilityService;
import com.tydic.merchant.mmc.ability.bo.MmcShopRejectAbilityReqBo;
import com.tydic.merchant.mmc.ability.bo.MmcShopRejectAbilityRspBo;
import com.tydic.merchant.mmc.comb.MmcShopApproveCombService;
import com.tydic.merchant.mmc.comb.bo.MmcShopApproveCombReqBo;
import com.tydic.merchant.mmc.comb.bo.MmcShopApproveCombRspBo;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="mmcShopRejectAbilityService")
@org.apache.dubbo.config.annotation.Service(version="1.0.0", group="MMC_GROUP", interfaceClass=MmcShopRejectAbilityService.class)
public class MmcShopRejectAbilityServiceImpl
implements MmcShopRejectAbilityService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MmcShopApproveCombService mmcShopApproveCombService;

    public MmcShopRejectAbilityRspBo rejectShop(MmcShopRejectAbilityReqBo reqBo) {
        this.LOGGER.info("\u5e97\u94fa\u5ba1\u6279\u9a73\u56deAbility\u670d\u52a1:" + reqBo);
        MmcShopRejectAbilityRspBo retBo = new MmcShopRejectAbilityRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("114015");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        MmcShopApproveCombReqBo combReqBo = new MmcShopApproveCombReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)combReqBo);
        combReqBo.setApproveIds(reqBo.getRejectIds());
        combReqBo.setApproveAction("2");
        MmcShopApproveCombRspBo combRspBo = this.mmcShopApproveCombService.approveShop(combReqBo);
        if (!"0000".equals(combRspBo.getRespCode())) {
            this.LOGGER.error("\u8c03\u7528\u5e97\u94fa\u5ba1\u6279comb\u670d\u52a1\u5904\u7406\u5931\u8d25\uff1a" + combRspBo.getRespDesc());
            retBo.setRespCode("114015");
            retBo.setRespDesc(combRspBo.getRespDesc());
            return retBo;
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArgs(MmcShopRejectAbilityReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getRejectIds())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'rejectIds'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getDesc())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'desc'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOpType())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'opType'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getUserId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'userId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

