/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.busi.impl;

import com.tydic.merchant.mmc.atom.api.MmcDicMapQueryAtomService;
import com.tydic.merchant.mmc.atom.bo.MmcDicMapQueryAtomReqBo;
import com.tydic.merchant.mmc.atom.bo.MmcDicMapQueryAtomRspBo;
import com.tydic.merchant.mmc.busi.MmcShopTemplateConfirmBusiService;
import com.tydic.merchant.mmc.busi.bo.MmcShopTemplateConfirmBusiReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopTemplateConfirmBusiRspBo;
import com.tydic.merchant.mmc.dao.MmcInfoMerchantMapper;
import com.tydic.merchant.mmc.dao.MmcRelShopTemplateMapper;
import com.tydic.merchant.mmc.dao.po.MmcRelShopTemplatePo;
import com.tydic.merchant.mmc.exception.MmcBusinessException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class MmcShopTemplateConfirmBusiServiceImpl
implements MmcShopTemplateConfirmBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MmcRelShopTemplateMapper mmcRelShopTemplateMapper;
    @Autowired
    private MmcInfoMerchantMapper mmcInfoMerchantMapper;
    @Autowired
    private MmcDicMapQueryAtomService mmcDicMapQueryAtomService;

    public MmcShopTemplateConfirmBusiRspBo confirmShopTemplate(MmcShopTemplateConfirmBusiReqBo reqBo) {
        int result;
        this.LOGGER.info("\u5e97\u94fa\u6a21\u677f\u786e\u8ba4busi\u670d\u52a1\uff1a" + reqBo);
        MmcShopTemplateConfirmBusiRspBo retBo = new MmcShopTemplateConfirmBusiRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("112002");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        MmcRelShopTemplatePo reqPo = new MmcRelShopTemplatePo();
        reqPo.setShopId(reqBo.getShopId());
        reqPo.setType(reqBo.getType());
        List<MmcRelShopTemplatePo> relList = this.mmcRelShopTemplateMapper.selectByCondition(reqPo);
        BeanUtils.copyProperties((Object)reqBo, (Object)reqPo);
        reqPo.setStatus(Integer.valueOf("1"));
        Date nowTime = this.mmcInfoMerchantMapper.getDbDate().getDate();
        if (CollectionUtils.isEmpty(relList)) {
            reqPo.setCreateTime(nowTime);
            result = this.mmcRelShopTemplateMapper.insert(reqPo);
        } else {
            MmcRelShopTemplatePo relShopTemplatePo = relList.get(0);
            reqPo.setRelId(relShopTemplatePo.getRelId());
            reqPo.setUpdateTime(nowTime);
            result = this.mmcRelShopTemplateMapper.updateByPrimaryKeySelective(reqPo);
        }
        if (result < 1) {
            this.LOGGER.error("\u8c03\u7528mappe\u786e\u8ba4\u5e97\u94fa\u6a21\u677f\u8fd4\u56de\u503c\u96f6");
            retBo.setRespCode("112002");
            retBo.setRespDesc("\u8c03\u7528mappe\u786e\u8ba4\u5e97\u94fa\u6a21\u677f\u8fd4\u56de\u503c\u96f6");
            return retBo;
        }
        MmcDicMapQueryAtomReqBo atomReqBo = new MmcDicMapQueryAtomReqBo();
        atomReqBo.setType("REL_SHOP_TEMPLATE_STATUS");
        MmcDicMapQueryAtomRspBo atomRetBo = this.mmcDicMapQueryAtomService.qryDicMap(atomReqBo);
        if (!"0000".equals(atomRetBo.getRespCode())) {
            throw new MmcBusinessException("116001", "\u7ffb\u8bd1\u72b6\u6001\u503c\u5931\u8d25\uff1a" + atomRetBo.getRespDesc());
        }
        Map<String, String> dicMap = atomRetBo.getDicMap();
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setRelId(reqPo.getRelId());
        retBo.setStatusName(dicMap.get("1"));
        retBo.setStatus(reqPo.getStatus());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        retBo.setCreateTime(nowTime);
        return retBo;
    }

    private String validateArgs(MmcShopTemplateConfirmBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getShopId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'shopId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getTemplateId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'templateId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getType())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'type'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

