/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.ability.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.merchant.mmc.ability.MmcShopMaintainArticleUpdateAbilityService;
import com.tydic.merchant.mmc.ability.bo.MmcShopMaintainArticleUpdateAbilityReqBo;
import com.tydic.merchant.mmc.ability.bo.MmcShopMaintainArticleUpdateAbilityRspBo;
import com.tydic.merchant.mmc.config.MmcPropertiesManager;
import com.tydic.merchant.mmc.constants.MmcConstants;
import com.tydic.merchant.mmc.enums.MmcPropertiesEnum;
import com.tydic.uac.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="MMC_GROUP", serviceInterface=MmcShopMaintainArticleUpdateAbilityService.class)
public class MmcShopMaintainArticleUpdateAbilityServiceImpl
implements MmcShopMaintainArticleUpdateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(MmcShopMaintainArticleUpdateAbilityServiceImpl.class);
    private static final String UNDERLINE = "_";
    @Autowired
    private MmcPropertiesManager mmcPropertiesManager;

    public MmcShopMaintainArticleUpdateAbilityRspBo updateArticle(MmcShopMaintainArticleUpdateAbilityReqBo reqBo) {
        if (log.isDebugEnabled()) {
            log.debug("====\u5e97\u94fa\u7ef4\u62a4-\u6587\u7ae0\u66f4\u65b0\uff08CMS\uff09\u5f00\u59cb\uff0c\u5165\u53c2\uff1a{}", (Object)reqBo);
        }
        MmcShopMaintainArticleUpdateAbilityRspBo retBo = new MmcShopMaintainArticleUpdateAbilityRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("114052");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        String path = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_ARTICLE_UPDATE_RUL.getName());
        if (StringUtils.isEmpty((Object)path)) {
            log.error("CMS\u6587\u6863\u66f4\u65b0\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.mass.article.update.url");
            throw new BusinessException("118003", "CMS\u6587\u6863\u66f4\u65b0\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.mass.article.update.url");
        }
        String cmsRequestStr = this.getCmsRequestData(reqBo);
        String result = HttpUtil.post((String)path, (String)cmsRequestStr);
        log.debug("\u8c03\u7528CMS\u63a5\u53e3\u7ed3\u679c\uff1a{}", (Object)result);
        JSONObject resultJson = JSON.parseObject((String)result);
        if (!MmcConstants.CMS_SUCCESS.equals(resultJson.get((Object)"code"))) {
            log.error("\u8c03\u7528CMS\u7684\u6587\u6863\u66f4\u65b0\u63a5\u53e3\u5931\u8d25\uff1a{}", resultJson.get((Object)"message"));
            retBo.setRespCode("114052");
            retBo.setRespDesc("\u8c03\u7528CMS\u7684\u6587\u6863\u66f4\u65b0\u63a5\u53e3\u5931\u8d25\uff1a" + resultJson.get((Object)"message"));
            return retBo;
        }
        this.generateColumn(reqBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        if (log.isDebugEnabled()) {
            log.debug("====\u5e97\u94fa\u7ef4\u62a4-\u6587\u7ae0\u66f4\u65b0\uff08CMS\uff09\u7ed3\u675f\uff0c\u51fa\u53c2\uff1a{}", (Object)retBo);
        }
        return retBo;
    }

    private void generateColumn(MmcShopMaintainArticleUpdateAbilityReqBo reqBo) {
        String articleCode = MmcConstants.ARTICLE_TYPE.getArticleType((String)reqBo.getArticleType()).getCode();
        StringBuilder columnCodeBuilder = new StringBuilder();
        columnCodeBuilder.append(reqBo.getShopId()).append(UNDERLINE).append(articleCode);
        log.debug("\u5f00\u59cb\u9759\u6001\u5316\u680f\u76ee\uff1a{}", (Object)columnCodeBuilder.toString());
        String generateUrl = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_GENERATE_BY_CODE.getName());
        if (StringUtils.isEmpty((Object)generateUrl)) {
            log.error("CMS\u680f\u76ee\u65b0\u589e\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.generate.by.code.url");
            throw new BusinessException("118002", "CMS\u680f\u76ee\u65b0\u589e\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.generate.by.code.url");
        }
        JSONObject reqJson = new JSONObject();
        reqJson.put("columnCode", (Object)columnCodeBuilder.toString());
        String result = HttpUtil.post((String)generateUrl, (String)reqJson.toJSONString());
        log.debug("CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u9759\u6001\u5316\u6587\u7ae0\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a{}", (Object)result);
        JSONObject resultJson = JSON.parseObject((String)result);
        if (!MmcConstants.CMS_SUCCESS.equals(resultJson.get((Object)"code"))) {
            log.error("CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u9759\u6001\u5316\u6587\u7ae0\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a{}", resultJson.get((Object)"message"));
        }
    }

    private String getCmsRequestData(MmcShopMaintainArticleUpdateAbilityReqBo reqBo) {
        JSONObject requestJson;
        String articleCode = MmcConstants.ARTICLE_TYPE.getArticleType((String)reqBo.getArticleType()).getCode();
        if (MmcConstants.ARTICLE_TYPE.INTRO.getType().equals(reqBo.getArticleType())) {
            MmcShopMaintainArticleUpdateAbilityReqBo.Company company = reqBo.getCompanyInfo();
            requestJson = JSON.parseObject((String)JSON.toJSONString((Object)company));
            requestJson.put("basicTitle", (Object)company.getTitle());
        } else {
            MmcShopMaintainArticleUpdateAbilityReqBo.AdvertisementOrBanner instance = reqBo.getInstance();
            requestJson = JSON.parseObject((String)JSON.toJSONString((Object)instance));
            requestJson.put("basicTitle", (Object)(reqBo.getShopId() + UNDERLINE + articleCode + UNDERLINE + System.currentTimeMillis()));
        }
        requestJson.put("articleId", (Object)reqBo.getArticleId());
        log.debug("\u7ec4\u88c5\u5f97\u5230\u7684CMS\u5165\u53c2\u4e3a\uff1a{}", (Object)requestJson.toJSONString());
        return requestJson.toJSONString();
    }

    private String validateArgs(MmcShopMaintainArticleUpdateAbilityReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getArticleId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'articleId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getShopId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'shopId'(\u5e97\u94faID)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        String articleType = reqBo.getArticleType();
        if (StringUtils.isEmpty((Object)articleType)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'articleType'(\u6587\u7ae0\u7c7b\u578b)\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == MmcConstants.ARTICLE_TYPE.getArticleType((String)articleType)) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'articleType'\u7684\u53d6\u503c\u8303\u56f4(1.\u8f6e\u64ad\u56fe 2.\u5e7f\u544a\u56fe 3 \u516c\u53f8\u4fe1\u606f)";
        }
        if (MmcConstants.ARTICLE_TYPE.BANNER.getType().equals(articleType) || MmcConstants.ARTICLE_TYPE.ADVERT.getType().equals(articleType)) {
            MmcShopMaintainArticleUpdateAbilityReqBo.AdvertisementOrBanner instance = reqBo.getInstance();
            if (StringUtils.isEmpty((Object)instance.getImage())) {
                return "\u6587\u7ae0\u7c7b\u578b(articleType)\uff0c\u53d6\u503c\u4e3a(1\uff0c2)\u65f6, \u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'instance'\u4e2d\u7684'imageUrl'\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (StringUtils.isEmpty((Object)instance.getRoute()) && MmcConstants.ARTICLE_TYPE.ADVERT.getType().equals(articleType)) {
                return "\u6587\u7ae0\u7c7b\u578b(articleType)\uff0c\u53d6\u503c\u4e3a(2)\u65f6, \u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'instance'\u4e2d\u7684'route'\u4e0d\u80fd\u4e3a\u7a7a";
            }
        }
        if (MmcConstants.ARTICLE_TYPE.INTRO.getType().equals(articleType)) {
            MmcShopMaintainArticleUpdateAbilityReqBo.Company companyInfo = reqBo.getCompanyInfo();
            if (StringUtils.isEmpty((Object)companyInfo.getTitle())) {
                return "\u6587\u7ae0\u7c7b\u578b(articleType)\uff0c\u53d6\u503c\u4e3a(3)\u65f6, \u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'companyInfo'\u4e2d\u7684'title'\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (StringUtils.isEmpty((Object)companyInfo.getIntro())) {
                return "\u6587\u7ae0\u7c7b\u578b(articleType)\uff0c\u53d6\u503c\u4e3a(3)\u65f6, \u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'companyInfo'\u4e2d\u7684'intro'\u4e0d\u80fd\u4e3a\u7a7a";
            }
        }
        return null;
    }
}

