/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.busi.impl;

import com.tydic.merchant.mmc.atom.api.MmcFitmentMaterialGroupAddAtomService;
import com.tydic.merchant.mmc.atom.bo.MmcFitmentMaterialGroupAddAtomReqBo;
import com.tydic.merchant.mmc.atom.bo.MmcFitmentMaterialGroupAddAtomRspBo;
import com.tydic.merchant.mmc.busi.MmcFitmentMaterialAddBusiService;
import com.tydic.merchant.mmc.busi.bo.MmcFitmentMaterialAddBusiReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcFitmentMaterialAddBusiRspBo;
import com.tydic.merchant.mmc.config.MmcSequence;
import com.tydic.merchant.mmc.dao.MmcFitmentMaterialInfoMapper;
import com.tydic.merchant.mmc.dao.MmcFitmentRelMaterialShopGroupMapper;
import com.tydic.merchant.mmc.dao.MmcInfoShopMapper;
import com.tydic.merchant.mmc.dao.po.MmcFitmentMaterialInfoPo;
import com.tydic.merchant.mmc.dao.po.MmcFitmentRelMaterialShopGroupPo;
import com.tydic.merchant.mmc.dao.po.MmcInfoShopPo;
import com.tydic.merchant.mmc.exception.MmcBusinessException;
import com.tydic.starter.sequence.autoconfiguration.SequenceManagement;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="mmcFitmentMaterialAddBusiService")
public class MmcFitmentMaterialAddBusiServiceImpl
implements MmcFitmentMaterialAddBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MmcInfoShopMapper mmcInfoShopMapper;
    @Autowired
    private SequenceManagement sequenceManagement;
    @Autowired
    private MmcFitmentRelMaterialShopGroupMapper mmcFitmentRelMaterialShopGroupMapper;
    @Autowired
    private MmcFitmentMaterialGroupAddAtomService mmcFitmentMaterialGroupAddAtomService;
    @Autowired
    private MmcFitmentMaterialInfoMapper mmcFitmentMaterialInfoMapper;

    public MmcFitmentMaterialAddBusiRspBo addMaterial(MmcFitmentMaterialAddBusiReqBo reqBo) {
        this.LOGGER.info("\u5e97\u94fa\u88c5\u4fee-\u7d20\u6750\u65b0\u589e Busi\u670d\u52a1\uff1a" + reqBo);
        MmcFitmentMaterialAddBusiRspBo retBo = new MmcFitmentMaterialAddBusiRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("114032");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        MmcInfoShopPo queryShopRetBo = this.mmcInfoShopMapper.selectByPrimaryKey(reqBo.getShopId());
        if (queryShopRetBo == null) {
            this.LOGGER.error("\u672a\u67e5\u8be2\u5230\u5e97\u94faID:" + reqBo.getShopId() + "\u7684\u76f8\u5173\u4fe1\u606f");
            retBo.setRespCode("113011");
            retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5e97\u94faID:" + reqBo.getShopId() + "\u7684\u76f8\u5173\u4fe1\u606f");
            return retBo;
        }
        Long groupId = this.validateGroup(reqBo);
        long materialId = MmcSequence.nextId();
        Date nowTime = this.mmcInfoShopMapper.getDbDate();
        MmcFitmentMaterialInfoPo addMaterialPo = new MmcFitmentMaterialInfoPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)addMaterialPo);
        addMaterialPo.setGroupId(groupId);
        addMaterialPo.setMaterialId(materialId);
        addMaterialPo.setCreateTime(nowTime);
        int result = this.mmcFitmentMaterialInfoMapper.insertSelective(addMaterialPo);
        if (result < 1) {
            this.LOGGER.error("\u8c03\u7528mapper\u5199\u5165\u4fe1\u606f\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            throw new MmcBusinessException("116009", "\u8c03\u7528mapper\u5199\u5165\u4fe1\u606f\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setMaterialId(Long.valueOf(materialId));
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArgs(MmcFitmentMaterialAddBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getShopId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'shopId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getGroupType())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'groupType'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getMaterialName())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'materialName'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getMaterialPath())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'materialPath'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    private Long validateGroup(MmcFitmentMaterialAddBusiReqBo reqBo) {
        MmcFitmentRelMaterialShopGroupPo qryGroupReqPo = new MmcFitmentRelMaterialShopGroupPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)qryGroupReqPo);
        MmcFitmentRelMaterialShopGroupPo qryGroupRetPo = this.mmcFitmentRelMaterialShopGroupMapper.selectByPrimaryKeyOrIndex(qryGroupReqPo);
        if (qryGroupRetPo == null) {
            this.LOGGER.info("\u6839\u636egroupId\uff1a" + reqBo.getGroupId() + "\u672a\u67e5\u8be2\u5230\u5206\u7ec4\u4fe1\u606f\uff0c\u5373\u5c06\u628a\u7d20\u6750\u4fdd\u5b58\u5230\u9ed8\u8ba4\u5206\u7ec4");
            qryGroupReqPo.setDefaultGroup(Integer.valueOf("1"));
            qryGroupRetPo = this.mmcFitmentRelMaterialShopGroupMapper.selectByPrimaryKeyOrIndex(qryGroupReqPo);
        }
        if (qryGroupRetPo == null) {
            this.LOGGER.info("\u6ca1\u6709\u83b7\u53d6\u5230\u5206\u7ec4\u4fe1\u606f\uff0c\u5c06\u65b0\u5efa\u9ed8\u8ba4\u5206\u7ec4");
            MmcFitmentMaterialGroupAddAtomReqBo addGroupReqBo = new MmcFitmentMaterialGroupAddAtomReqBo();
            long groupId = MmcSequence.nextId();
            addGroupReqBo.setShopId(reqBo.getShopId());
            addGroupReqBo.setGroupType(reqBo.getGroupType());
            addGroupReqBo.setGroupId(groupId);
            addGroupReqBo.setGroupName("\u9ed8\u8ba4\u5206\u7ec4");
            addGroupReqBo.setDefaultGroup(Integer.valueOf("1"));
            MmcFitmentMaterialGroupAddAtomRspBo addGroupRetBo = this.mmcFitmentMaterialGroupAddAtomService.addGroup(addGroupReqBo);
            if (!"0000".equals(addGroupRetBo.getRespCode())) {
                this.LOGGER.error("\u8c03\u7528\u5e97\u94fa\u88c5\u4fee-\u7d20\u6750\u5206\u7ec4-\u65b0\u589e Atom\u670d\u52a1\u65b0\u589e\u9ed8\u8ba4\u5206\u7ec4\u5931\u8d25\uff1a" + addGroupRetBo.getRespDesc());
                throw new MmcBusinessException("116009", "\u8c03\u7528\u5e97\u94fa\u88c5\u4fee-\u7d20\u6750\u5206\u7ec4-\u65b0\u589e Atom\u670d\u52a1\u65b0\u589e\u9ed8\u8ba4\u5206\u7ec4\u5931\u8d25\uff1a" + addGroupRetBo.getRespDesc());
            }
            return groupId;
        }
        return qryGroupRetPo.getGroupId();
    }
}

