/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.busi.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.merchant.mmc.busi.MmcShopContentAddBusiService;
import com.tydic.merchant.mmc.busi.bo.MmcShopContentAddBusiReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopContentAddBusiRspBo;
import com.tydic.merchant.mmc.config.MmcPropertiesManager;
import com.tydic.merchant.mmc.constants.MmcConstants;
import com.tydic.merchant.mmc.dao.MmcRelShopContentSettingMapper;
import com.tydic.merchant.mmc.dao.po.MmcRelShopContentSettingPo;
import com.tydic.merchant.mmc.enums.MmcPropertiesEnum;
import com.tydic.uac.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="mmcShopContentAddBusiService")
public class MmcShopContentAddBusiServiceImpl
implements MmcShopContentAddBusiService {
    private static final Logger log = LoggerFactory.getLogger(MmcShopContentAddBusiServiceImpl.class);
    private static final String UNDERLINE = "_";
    @Autowired
    private MmcPropertiesManager mmcPropertiesManager;
    @Autowired
    private MmcRelShopContentSettingMapper mmcRelShopContentSettingMapper;

    public MmcShopContentAddBusiRspBo addShopContent(MmcShopContentAddBusiReqBo reqBo) {
        int addResult;
        String result;
        if (log.isDebugEnabled()) {
            log.debug("\u5e97\u94fa\u7ba1\u7406-\u5e97\u94fa\u5185\u5bb9\u7ef4\u62a4-\u6587\u7ae0\u65b0\u589ebusi\u670d\u52a1\uff0c\u5165\u53c2\uff1a{}", (Object)reqBo);
        }
        MmcShopContentAddBusiRspBo retBo = new MmcShopContentAddBusiRspBo();
        String validateStr = this.valiDataArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        String path = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_ARTICLE_ADD_RUL.getName());
        if (StringUtils.isEmpty((Object)path)) {
            log.error("CMS\u6587\u6863\u65b0\u589e\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.mass.article.push.url");
            throw new BusinessException("116013", "CMS\u6587\u6863\u65b0\u589e\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.mass.article.push.url");
        }
        String columnPath = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_COLUMN_ADD_URL.getName());
        if (StringUtils.isEmpty((Object)columnPath)) {
            log.error("CMS\u680f\u76ee\u65b0\u589e\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.column.add.url");
            throw new BusinessException("116013", "CMS\u680f\u76ee\u65b0\u589e\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.column.add.url");
        }
        String columnCode = this.createCmcColumn(reqBo, columnPath);
        String cmsRequestStr = this.getCmsRequestData(reqBo, columnCode);
        log.info("\u65b0\u589e\u6587\u7ae0\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)cmsRequestStr);
        log.info("\u65b0\u589e\u6587\u7ae0\u8bf7\u6c42\u5730\u5740\u4e3a\uff1a{}", (Object)path);
        try {
            result = HttpUtil.post((String)path, (String)cmsRequestStr);
        }
        catch (Exception e) {
            throw new BusinessException("116013", "\u8c03\u7528CMS\u63a5\u53e3\u5f02\u5e38\uff1a", (Throwable)e);
        }
        log.info("\u65b0\u589e\u6587\u7ae0\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)result);
        if (StringUtils.isEmpty((Object)result)) {
            throw new BusinessException("116013", "CMS\u8fd4\u56de\u53c2\u6570\u4e3a\u7a7a");
        }
        JSONObject resultJson = JSON.parseObject((String)result);
        if (!MmcConstants.CMS_SUCCESS.equals(resultJson.get((Object)"code"))) {
            log.error("\u8c03\u7528CMS\u7684\u6587\u6863\u65b0\u589e\u63a5\u53e3\u5931\u8d25\uff1a{}", resultJson.get((Object)"message"));
            retBo.setRespCode("112041");
            retBo.setRespDesc("\u8c03\u7528CMS\u7684\u6587\u6863\u65b0\u589e\u63a5\u53e3\u5931\u8d25\uff1a" + resultJson.get((Object)"message"));
            return retBo;
        }
        this.generateColumn(columnCode);
        MmcRelShopContentSettingPo contentSettingPo = new MmcRelShopContentSettingPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)contentSettingPo);
        JSONArray articleIds = JSONArray.parseArray((String)resultJson.getString("data"));
        if (articleIds.size() > 0) {
            contentSettingPo.setArticleId(String.valueOf(articleIds.get(0)));
        }
        if ((addResult = this.mmcRelShopContentSettingMapper.insert(contentSettingPo)) != 1) {
            throw new BusinessException("116013", "\u65b0\u589e\u5e97\u94fa\u5185\u5bb9\uff0c\u6570\u636e\u5165\u5e93\u5931\u8d25");
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        if (log.isDebugEnabled()) {
            log.debug("\u5e97\u94fa\u7ba1\u7406-\u5e97\u94fa\u5185\u5bb9\u7ef4\u62a4-\u6587\u7ae0\u65b0\u589e\u7ed3\u675f\uff0c\u51fa\u53c2\uff1a{}", (Object)retBo);
        }
        return retBo;
    }

    private void generateColumn(String columnCode) {
        log.debug("\u5f00\u59cb\u9759\u6001\u5316\u680f\u76ee\uff1a{}", (Object)columnCode);
        String generateUrl = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_GENERATE_BY_CODE.getName());
        if (StringUtils.isEmpty((Object)generateUrl)) {
            log.error("CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u9759\u6001\u5316\u6587\u7ae0\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.generate.by.code.url");
            throw new BusinessException("118002", "CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u9759\u6001\u5316\u6587\u7ae0\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.generate.by.code.url");
        }
        JSONObject reqJson = new JSONObject();
        reqJson.put("columnCode", (Object)columnCode);
        log.info("CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u9759\u6001\u5316\u6587\u7ae0\u5165\u53c2\uff1a{}", (Object)reqJson);
        log.info("CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u9759\u6001\u5316\u6587\u7ae0\u5730\u5740\uff1a{}", (Object)generateUrl);
        String result = HttpUtil.post((String)generateUrl, (String)reqJson.toJSONString());
        log.info("CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u9759\u6001\u5316\u6587\u7ae0\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a{}", (Object)result);
        JSONObject resultJson = JSON.parseObject((String)result);
        if (!MmcConstants.CMS_SUCCESS.equals(resultJson.get((Object)"code"))) {
            log.error("CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u9759\u6001\u5316\u6587\u7ae0\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a{}", resultJson.get((Object)"message"));
        }
    }

    private String createCmcColumn(MmcShopContentAddBusiReqBo reqBo, String columnPath) {
        String result;
        if (log.isDebugEnabled()) {
            log.debug("======\u5f00\u59cb\u521b\u5efaCMS\u680f\u76ee======");
        }
        String articleCode = "shopContentSettingColumn";
        StringBuilder columnCodeBuilder = new StringBuilder();
        columnCodeBuilder.append(reqBo.getShopId()).append(UNDERLINE).append(articleCode);
        log.debug("\u5165\u53c2shopId:{}, articleType:{},\u5f97\u5230\u7684\u680f\u76ee\u7f16\u7801\u4e3a:{}", new Object[]{reqBo.getShopId(), reqBo.getContentType(), columnCodeBuilder.toString()});
        String columnModel = null;
        String table = null;
        if (MmcConstants.ARTICLE_TYPE.BANNER.getType().equals(reqBo.getContentType())) {
            columnModel = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_SHOP_BANNER_COLUMN_MODEL.getName());
            table = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_SHOP_BANNER_TABLE.getName());
        } else if (MmcConstants.ARTICLE_TYPE.ADVERT.getType().equals(reqBo.getContentType())) {
            columnModel = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_SHOP_ADVERT_COLUMN_MODEL.getName());
            table = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_SHOP_ADVERT_TABLE.getName());
        }
        JSONObject columnJson = new JSONObject();
        columnJson.put("columnCode", (Object)columnCodeBuilder.toString());
        columnJson.put("columnTitle", (Object)new StringBuilder().append("\u5e97\u94fa").append(reqBo.getShopId()).append(UNDERLINE).append(articleCode.toUpperCase()));
        columnJson.put("columnSmallimg", (Object)"");
        columnJson.put("columnUrlName", (Object)columnModel);
        columnJson.put("columnListUrlName", (Object)columnModel);
        columnJson.put("columnSort", (Object)0);
        columnJson.put("columnFieldOne", (Object)"");
        columnJson.put("columnFieldTwo", (Object)"");
        columnJson.put("columnCmTable", (Object)table);
        columnJson.put("columnParentCode", (Object)articleCode);
        log.info("CMS\u65b0\u589e\u680f\u76ee\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)columnJson.toJSONString());
        log.info("\u672c\u6b21\u7684CMS\u680f\u76ee\u521b\u5efa\u5730\u5740\u4e3a\uff1a{}", (Object)columnPath);
        try {
            result = HttpUtil.post((String)columnPath, (String)columnJson.toJSONString());
        }
        catch (Exception e) {
            throw new BusinessException("116013", "\u8c03\u7528CMS\u63a5\u53e3\u5f02\u5e38\uff1a", (Throwable)e);
        }
        log.info("CMS\u680f\u76ee\u65b0\u589e\u8fd4\u56de\u7684\u53c2\u6570\u4e3a\uff1a" + result);
        if (StringUtils.isEmpty((Object)result)) {
            throw new BusinessException("116013", "\u8c03\u7528CMS\u63a5\u53e3\u5931\u8d25\uff0c\u8fd4\u56de\u4e3a\u7a7a");
        }
        JSONObject resultJson = JSON.parseObject((String)result);
        if (!MmcConstants.CMS_SUCCESS.equals(resultJson.get((Object)"code"))) {
            log.error("\u8c03\u7528CMS\u7684\u6587\u6863\u65b0\u589e\u63a5\u53e3\u5931\u8d25\uff1a{}", resultJson.get((Object)"message"));
        }
        return columnCodeBuilder.toString();
    }

    private String getCmsRequestData(MmcShopContentAddBusiReqBo reqBo, String columnCode) {
        String articleCode = "shopContentSettingColumn";
        log.debug("\u5165\u53c2shopId:{}, articleType:{},\u5f97\u5230\u7684\u680f\u76ee\u7f16\u7801\u4e3a:{}", new Object[]{reqBo.getShopId(), reqBo.getContentType(), columnCode});
        JSONObject requestJson = JSON.parseObject((String)JSON.toJSONString((Object)reqBo));
        requestJson.put("basicTitle", (Object)(reqBo.getShopId() + UNDERLINE + articleCode + UNDERLINE + System.currentTimeMillis()));
        requestJson.put("columnCode", (Object)columnCode);
        log.debug("\u7ec4\u88c5\u5f97\u5230\u7684CMS\u5165\u53c2\u4e3a\uff1a{}", (Object)requestJson.toJSONString());
        return "[" + requestJson.toJSONString() + "]";
    }

    private String valiDataArgs(MmcShopContentAddBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2'reqBo'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getShopId())) {
            return "\u5165\u53c2'reqBo'\u7684\u5c5e\u6027'shopId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getContentType())) {
            return "\u5165\u53c2'reqBo'\u7684\u5c5e\u6027'contentType'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getImgUrl())) {
            return "\u5165\u53c2'reqBo'\u7684\u5c5e\u6027'imgUrl'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRoute())) {
            return "\u5165\u53c2'reqBo'\u7684\u5c5e\u6027'route'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

