/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.busi.impl;

import com.tydic.merchant.mmc.atom.api.MmcAuditRequestAtomService;
import com.tydic.merchant.mmc.atom.bo.MmcAuditRequestAtomReqBo;
import com.tydic.merchant.mmc.atom.bo.MmcAuditRequestAtomRspBo;
import com.tydic.merchant.mmc.busi.MmcShopContentCommitBusiService;
import com.tydic.merchant.mmc.busi.bo.MmcShopContentCommitBusiReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopContentCommitBusiRspBo;
import com.tydic.merchant.mmc.dao.MmcInfoShopMapper;
import com.tydic.merchant.mmc.dao.po.MmcInfoShopPo;
import com.tydic.merchant.mmc.exception.MmcBusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="mmcShopContentCommitBusiService")
public class MmcShopContentCommitBusiServiceImpl
implements MmcShopContentCommitBusiService {
    private static final Logger log = LoggerFactory.getLogger(MmcShopContentCommitBusiServiceImpl.class);
    private static final String UNDERLINE = "_";
    @Value(value="${mmc.approval.shop.request.prokey}")
    private String shopRequestProKey;
    @Value(value="${CALL_PRC_SYS_CODE}")
    private String approvalSysCode;
    @Autowired
    private MmcAuditRequestAtomService mmcAuditRequestAtomService;
    @Autowired
    private MmcInfoShopMapper mmcInfoShopMapper;

    public MmcShopContentCommitBusiRspBo commitShopContent(MmcShopContentCommitBusiReqBo reqBo) {
        if (log.isDebugEnabled()) {
            log.debug("\u5e97\u94fa\u7ba1\u7406-\u5e97\u94fa\u5185\u5bb9\u7ef4\u62a4-\u5e97\u94fa\u5185\u5bb9\u63d0\u4ea4busi\u670d\u52a1\uff0c\u5165\u53c2\uff1a{}", (Object)reqBo);
        }
        MmcShopContentCommitBusiRspBo retBo = new MmcShopContentCommitBusiRspBo();
        String validateStr = this.valiDataArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        Long shopId = Long.parseLong(reqBo.getShopId());
        MmcInfoShopPo mmcInfoShopPo = this.mmcInfoShopMapper.selectByPrimaryKey(shopId);
        MmcAuditRequestAtomReqBo auditBo = this.assembleAuditBo(mmcInfoShopPo);
        MmcAuditRequestAtomRspBo auditRspBo = this.mmcAuditRequestAtomService.auditRequest(auditBo);
        if (!"0000".equals(auditRspBo.getRespCode())) {
            throw new MmcBusinessException("116003", "\u8c03\u7528\u5ba1\u6279\u670d\u52a1\u9519\u8bef\uff1a" + auditRspBo.getRespDesc());
        }
        MmcInfoShopPo updateShopBo = new MmcInfoShopPo();
        updateShopBo.setShopId(Long.parseLong(reqBo.getShopId()));
        updateShopBo.setStatus(Integer.parseInt("2"));
        this.mmcInfoShopMapper.updateByPrimaryKeySelective(updateShopBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        if (log.isDebugEnabled()) {
            log.debug("\u5e97\u94fa\u7ba1\u7406-\u5e97\u94fa\u5185\u5bb9\u7ef4\u62a4-\u5185\u5bb9\u63d0\u4ea4\uff0c\u51fa\u53c2\uff1a{}", (Object)retBo);
        }
        return retBo;
    }

    private MmcAuditRequestAtomReqBo assembleAuditBo(MmcInfoShopPo mmcInfoShopPo) {
        String shopId = String.valueOf(mmcInfoShopPo.getShopId());
        MmcAuditRequestAtomReqBo auditBo = new MmcAuditRequestAtomReqBo();
        auditBo.setProcDefKey(this.shopRequestProKey);
        auditBo.setSysCode(this.approvalSysCode);
        auditBo.setCreateOperId(mmcInfoShopPo.getCreateOper());
        auditBo.setCreateOperName(mmcInfoShopPo.getCreateOper());
        auditBo.setRemark("\u5e97\u94fa(" + shopId + ")\u5f00\u5e97\u5ba1\u6279");
        auditBo.setObjId(shopId);
        auditBo.setObjType(Integer.parseInt("1"));
        auditBo.setObjCode(shopId);
        auditBo.setObjName(shopId + "_Name");
        return auditBo;
    }

    private String valiDataArgs(MmcShopContentCommitBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2'reqBo'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getShopId())) {
            return "\u5165\u53c2'reqBo'\u7684\u5c5e\u6027'shopId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

