/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.busi.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.merchant.mmc.busi.MmcShopContentUpdateBusiService;
import com.tydic.merchant.mmc.busi.bo.MmcShopContentUpdateBusiReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopContentUpdateBusiRspBo;
import com.tydic.merchant.mmc.config.MmcPropertiesManager;
import com.tydic.merchant.mmc.constants.MmcConstants;
import com.tydic.merchant.mmc.dao.MmcRelShopContentSettingMapper;
import com.tydic.merchant.mmc.dao.po.MmcRelShopContentSettingPo;
import com.tydic.merchant.mmc.enums.MmcPropertiesEnum;
import com.tydic.uac.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="mmcShopContentUpdateBusiService")
public class MmcShopContentUpdateBusiServiceImpl
implements MmcShopContentUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(MmcShopContentUpdateBusiServiceImpl.class);
    private static final String UNDERLINE = "_";
    @Autowired
    private MmcPropertiesManager mmcPropertiesManager;
    @Autowired
    private MmcRelShopContentSettingMapper mmcRelShopContentSettingMapper;

    public MmcShopContentUpdateBusiRspBo updateShopContent(MmcShopContentUpdateBusiReqBo reqBo) {
        if (log.isDebugEnabled()) {
            log.debug("\u5e97\u94fa\u7ba1\u7406-\u5e97\u94fa\u5185\u5bb9\u7ef4\u62a4-\u6587\u7ae0\u66f4\u65b0busi\u670d\u52a1\uff0c\u5165\u53c2\uff1a{}", (Object)reqBo);
        }
        MmcShopContentUpdateBusiRspBo retBo = new MmcShopContentUpdateBusiRspBo();
        String validateStr = this.valiDataArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        String path = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_ARTICLE_UPDATE_RUL.getName());
        if (StringUtils.isEmpty((Object)path)) {
            log.error("CMS\u6587\u6863\u66f4\u65b0\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.mass.article.update.url");
            throw new BusinessException("116015", "CMS\u6587\u6863\u66f4\u65b0\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.mass.article.update.url");
        }
        String cmsRequestStr = this.getCmsRequestData(reqBo);
        String result = HttpUtil.post((String)path, (String)cmsRequestStr);
        log.debug("\u8c03\u7528CMS\u63a5\u53e3\u7ed3\u679c\uff1a{}", (Object)result);
        JSONObject resultJson = JSON.parseObject((String)result);
        if (!MmcConstants.CMS_SUCCESS.equals(resultJson.get((Object)"code"))) {
            log.error("\u8c03\u7528CMS\u7684\u6587\u6863\u66f4\u65b0\u63a5\u53e3\u5931\u8d25\uff1a{}", resultJson.get((Object)"message"));
            retBo.setRespCode("112042");
            retBo.setRespDesc("\u8c03\u7528CMS\u7684\u6587\u6863\u66f4\u65b0\u63a5\u53e3\u5931\u8d25\uff1a" + resultJson.get((Object)"message"));
            return retBo;
        }
        this.generateColumn(reqBo);
        MmcRelShopContentSettingPo contentSettingPo = new MmcRelShopContentSettingPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)contentSettingPo);
        int updateResult = this.mmcRelShopContentSettingMapper.updateByPrimaryKey(contentSettingPo);
        if (updateResult != 1) {
            throw new BusinessException("116015", "\u66f4\u65b0\u5e97\u94fa\u5185\u5bb9\uff0c\u6570\u636e\u5165\u5e93\u5931\u8d25");
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        if (log.isDebugEnabled()) {
            log.debug("\u5e97\u94fa\u7ba1\u7406-\u5e97\u94fa\u5185\u5bb9\u7ef4\u62a4-\u6587\u7ae0\u65b0\u589e\u7ed3\u675f\uff0c\u51fa\u53c2\uff1a{}", (Object)retBo);
        }
        return retBo;
    }

    private void generateColumn(MmcShopContentUpdateBusiReqBo reqBo) {
        String articleCode = "shopContentSettingColumn";
        StringBuilder columnCodeBuilder = new StringBuilder();
        columnCodeBuilder.append(reqBo.getShopId()).append(UNDERLINE).append(articleCode);
        log.debug("\u5f00\u59cb\u9759\u6001\u5316\u680f\u76ee\uff1a{}", (Object)columnCodeBuilder.toString());
        String generateUrl = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.CMS_GENERATE_BY_CODE.getName());
        if (StringUtils.isEmpty((Object)generateUrl)) {
            log.error("CMS\u680f\u76ee\u66f4\u65b0\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.generate.by.code.url");
            throw new BusinessException("118002", "CMS\u680f\u76ee\u66f4\u65b0\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u6dfb\u52a0\uff1acms.generate.by.code.url");
        }
        JSONObject reqJson = new JSONObject();
        reqJson.put("columnCode", (Object)columnCodeBuilder.toString());
        String result = HttpUtil.post((String)generateUrl, (String)reqJson.toJSONString());
        log.debug("CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u9759\u6001\u5316\u6587\u7ae0\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a{}", (Object)result);
        JSONObject resultJson = JSON.parseObject((String)result);
        if (!MmcConstants.CMS_SUCCESS.equals(resultJson.get((Object)"code"))) {
            log.error("CMS\u6839\u636e\u680f\u76ee\u7f16\u7801\u9759\u6001\u5316\u6587\u7ae0\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a{}", resultJson.get((Object)"message"));
        }
    }

    private String getCmsRequestData(MmcShopContentUpdateBusiReqBo reqBo) {
        String articleCode = "shopContentSettingColumn";
        JSONObject requestJson = JSON.parseObject((String)JSON.toJSONString((Object)reqBo));
        requestJson.put("basicTitle", (Object)(reqBo.getShopId() + UNDERLINE + articleCode + UNDERLINE + System.currentTimeMillis()));
        requestJson.put("articleId", (Object)reqBo.getContentType());
        log.debug("\u7ec4\u88c5\u5f97\u5230\u7684CMS\u5165\u53c2\u4e3a\uff1a{}", (Object)requestJson.toJSONString());
        return requestJson.toJSONString();
    }

    private String valiDataArgs(MmcShopContentUpdateBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2'reqBo'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getShopId())) {
            return "\u5165\u53c2'reqBo'\u7684\u5c5e\u6027'shopId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getContentType())) {
            return "\u5165\u53c2'reqBo'\u7684\u5c5e\u6027'contentType'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getImgUrl())) {
            return "\u5165\u53c2'reqBo'\u7684\u5c5e\u6027'imgUrl'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRoute())) {
            return "\u5165\u53c2'reqBo'\u7684\u5c5e\u6027'route'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

