/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.merchant.mmc.atom.api.MmcAuditRequestAtomService;
import com.tydic.merchant.mmc.atom.bo.MmcAuditRequestAtomReqBo;
import com.tydic.merchant.mmc.atom.bo.MmcAuditRequestAtomRspBo;
import com.tydic.merchant.mmc.busi.MmcShopUnfreezeBusiService;
import com.tydic.merchant.mmc.busi.bo.MmcShopUnfreezeBusiReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopUnfreezeBusiRspBo;
import com.tydic.merchant.mmc.dao.MmcInfoShopMapper;
import com.tydic.merchant.mmc.dao.po.MmcInfoShopPo;
import com.tydic.merchant.mmc.exception.MmcBusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="mmcShopUnfreezeBusiService")
public class MmcShopUnfreezeBusiServiceImpl
implements MmcShopUnfreezeBusiService {
    private static final Logger log = LoggerFactory.getLogger(MmcShopUnfreezeBusiServiceImpl.class);
    @Autowired
    private MmcInfoShopMapper mmcInfoShopMapper;
    @Autowired
    private MmcAuditRequestAtomService mmcAuditRequestAtomService;
    @Value(value="${mmc.approval.shop.unfreeze.prokey}")
    private String shopUnfreezeProKey;
    @Value(value="${CALL_PRC_SYS_CODE}")
    private String approvalSysCode;

    public MmcShopUnfreezeBusiRspBo applyUnfreezeShop(MmcShopUnfreezeBusiReqBo reqBo) {
        MmcInfoShopPo mmcInfoShopPo;
        log.info("===========\u5e97\u94fa\u7533\u8bf7\u89e3\u51bbbusi\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        MmcShopUnfreezeBusiRspBo retBo = new MmcShopUnfreezeBusiRspBo();
        String validateArgStr = this.validateReqArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("112040");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        if (reqBo.getShopId() != null && reqBo.getShopId() > 0L && (mmcInfoShopPo = this.mmcInfoShopMapper.selectByPrimaryKey(reqBo.getShopId())) == null) {
            retBo.setRespCode("112040");
            retBo.setRespDesc("\u5e97\u94fa\u4fe1\u606f" + reqBo.getShopId() + "\u4e0d\u5b58\u5728");
            return retBo;
        }
        MmcAuditRequestAtomReqBo auditBo = this.assembleAuditBo(reqBo);
        MmcAuditRequestAtomRspBo auditRspBo = this.mmcAuditRequestAtomService.auditRequest(auditBo);
        if (!"0000".equals(auditRspBo.getRespCode())) {
            throw new MmcBusinessException("116003", "\u8c03\u7528\u5ba1\u6279\u670d\u52a1\u9519\u8bef\uff1a" + auditRspBo.getRespDesc());
        }
        MmcInfoShopPo updateShopBo = new MmcInfoShopPo();
        updateShopBo.setShopId(reqBo.getShopId());
        updateShopBo.setUnfreezeReasons(reqBo.getDesc());
        updateShopBo.setStatus(Integer.parseInt("8"));
        this.mmcInfoShopMapper.updateByPrimaryKeySelective(updateShopBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private MmcAuditRequestAtomReqBo assembleAuditBo(MmcShopUnfreezeBusiReqBo reqBo) {
        MmcAuditRequestAtomReqBo auditBo = new MmcAuditRequestAtomReqBo();
        auditBo.setProcDefKey(this.shopUnfreezeProKey);
        auditBo.setSysCode(this.approvalSysCode);
        auditBo.setCreateOperId(reqBo.getUserId());
        auditBo.setCreateOperName(reqBo.getUserId());
        auditBo.setRemark("\u5e97\u94fa(" + reqBo.getShopId() + ")\u89e3\u51bb\u5ba1\u6279");
        auditBo.setObjId(reqBo.getShopId().toString());
        auditBo.setObjType(Integer.parseInt("3"));
        auditBo.setObjCode(reqBo.getShopId().toString());
        auditBo.setObjName(reqBo.getShopId().toString() + "_Name");
        return auditBo;
    }

    private String validateReqArg(MmcShopUnfreezeBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBo.getShopId() == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027shopId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getDesc())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027desc\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getUserId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027userId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

