/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.ability.impl;

import com.tydic.merchant.mmc.ability.MmcShopCommitAbilityService;
import com.tydic.merchant.mmc.ability.MmcShopSaveAbilityService;
import com.tydic.merchant.mmc.ability.bo.MmcShopCommitAbilityReqBo;
import com.tydic.merchant.mmc.ability.bo.MmcShopCommitAbilityRspBo;
import com.tydic.merchant.mmc.ability.bo.MmcShopSaveAbilityReqBo;
import com.tydic.merchant.mmc.ability.bo.MmcShopSaveAbilityRspBo;
import com.tydic.merchant.mmc.dao.MmcInfoShopMapper;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="MmcShopCommitAbilityService")
@RestController
@RequestMapping(value={"MMC_GROUP/1.0.0/com.tydic.merchant.mmc.ability.MmcShopCommitAbilityService"})
public class MmcShopCommitAbilityServiceImpl
implements MmcShopCommitAbilityService {
    @Autowired
    private MmcShopSaveAbilityService mmcShopSaveAbilityService;
    @Autowired
    private MmcInfoShopMapper mmcInfoShopMapper;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Value(value="${mmc.approval.shop.request.prokey}")
    private String shopRequestProKey;
    @Value(value="${CALL_PRC_SYS_CODE}")
    private String approvalSysCode;
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    @PostMapping(value={"submitShop"})
    public MmcShopCommitAbilityRspBo submitShop(@RequestBody MmcShopCommitAbilityReqBo reqBo) {
        MmcShopCommitAbilityRspBo rspBo = new MmcShopCommitAbilityRspBo();
        String validateArgStr = this.validateReqArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            rspBo.setRespCode("114010");
            rspBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return rspBo;
        }
        MmcShopSaveAbilityReqBo saveShopBo = new MmcShopSaveAbilityReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)saveShopBo);
        saveShopBo.setAudit(true);
        MmcShopSaveAbilityRspBo saveShopRspBo = this.mmcShopSaveAbilityService.saveShop(saveShopBo);
        BeanUtils.copyProperties((Object)saveShopRspBo, (Object)rspBo);
        if (!"0000".equals(saveShopRspBo.getRespCode())) {
            return rspBo;
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u63d0\u4ea4\u6210\u529f");
        return rspBo;
    }

    private UacNoTaskAuditCreateReqBO assembleApprovalBo(MmcShopCommitAbilityReqBo reqBo, MmcShopSaveAbilityRspBo saveShopRspBo) {
        UacNoTaskAuditCreateReqBO createAuditBo = new UacNoTaskAuditCreateReqBO();
        createAuditBo.setProcDefKey(this.shopRequestProKey);
        createAuditBo.setSysCode(this.approvalSysCode);
        createAuditBo.setCreateOperId(reqBo.getCreateOper());
        createAuditBo.setCreateOperName(reqBo.getCreateOperName());
        createAuditBo.setIsSaveCreateLog(Boolean.valueOf(true));
        ArrayList<UacNoTaskAuditCreateInfoReqBO> auditList = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        createAuditBo.setCreateBusiReqBO(auditList);
        UacNoTaskAuditCreateInfoReqBO auditCreateReqBo = new UacNoTaskAuditCreateInfoReqBO();
        auditList.add(auditCreateReqBo);
        auditCreateReqBo.setObjType(Integer.valueOf(Integer.parseInt("1")));
        auditCreateReqBo.setRemark("\u5e97\u94fa\u5f00\u5e97\u5ba1\u6279");
        ArrayList<ApprovalObjBO> appObjInfoList = new ArrayList<ApprovalObjBO>();
        auditCreateReqBo.setApprovalObjInfo(appObjInfoList);
        ApprovalObjBO approvalObjBo = new ApprovalObjBO();
        appObjInfoList.add(approvalObjBo);
        auditCreateReqBo.setObjNum(appObjInfoList.size() + "");
        approvalObjBo.setObjId(saveShopRspBo.getShopId().toString());
        approvalObjBo.setObjType(Integer.valueOf(Integer.parseInt("1")));
        approvalObjBo.setObjCode(saveShopRspBo.getShopId().toString());
        approvalObjBo.setObjName(saveShopRspBo.getShopName());
        return createAuditBo;
    }

    private String validateReqArg(MmcShopCommitAbilityReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getSupplierName())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027supplierName\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

