/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.busi.impl;

import com.tydic.merchant.mmc.ability.bo.MmcShopChannelQueryAbilityDataBo;
import com.tydic.merchant.mmc.atom.api.MmcDicMapQueryAtomService;
import com.tydic.merchant.mmc.atom.bo.MmcDicMapQueryAtomReqBo;
import com.tydic.merchant.mmc.atom.bo.MmcDicMapQueryAtomRspBo;
import com.tydic.merchant.mmc.busi.MmcShopSetApproveListExportBusiService;
import com.tydic.merchant.mmc.busi.bo.MmcShopApproveListExportBusiReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopApproveListExportBusiRspBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopListQueryBusiDataBo;
import com.tydic.merchant.mmc.constants.MmcDictionaryValueConstants;
import com.tydic.merchant.mmc.dao.MmcRelShopChannelMapper;
import com.tydic.merchant.mmc.dao.MmcRelShopSettingMapper;
import com.tydic.merchant.mmc.dao.po.MmcRelShopChannelPo;
import com.tydic.merchant.mmc.dao.po.MmcRelShopSettingPo;
import com.tydic.merchant.mmc.dao.po.MmcShopApproveListQueryPo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="MmcShopSetApproveListExportBusiService")
public class MmcShopSetApproveListExportBusiServiceImpl
implements MmcShopSetApproveListExportBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MmcRelShopSettingMapper mmcRelShopSettingMapper;
    @Autowired
    private MmcRelShopChannelMapper mmcRelShopChannelMapper;
    @Autowired
    private MmcDicMapQueryAtomService mmcDicMapQueryAtomService;

    public MmcShopApproveListExportBusiRspBo exportList(MmcShopApproveListExportBusiReqBo reqBo) {
        this.LOGGER.info("\u5e97\u94fa\u8bbe\u7f6e\u5ba1\u6279\u5217\u8868\u5bfc\u51fabusi\u670d\u52a1\uff1a" + reqBo);
        MmcShopApproveListExportBusiRspBo retBo = new MmcShopApproveListExportBusiRspBo();
        ArrayList<MmcShopListQueryBusiDataBo> data = new ArrayList<MmcShopListQueryBusiDataBo>();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("112012");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        MmcShopApproveListQueryPo reqPo = new MmcShopApproveListQueryPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)reqPo);
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        reqPo.setStatusList(statusList);
        reqPo.setType(MmcDictionaryValueConstants.REL_SHOP_CHANNEL_TYPE_SETTING);
        if ("4".equals(reqBo.getQueryType().toString())) {
            statusList.add(Integer.parseInt("3"));
            reqPo.setTaskStatus(Integer.parseInt("102"));
        } else {
            statusList.add(Integer.parseInt("2"));
            reqPo.setTaskStatus(Integer.parseInt("100"));
        }
        List<MmcRelShopSettingPo> retPos = this.mmcRelShopSettingMapper.selectApproveList(reqPo);
        if (CollectionUtils.isEmpty(retPos)) {
            this.LOGGER.error("\u672a\u67e5\u8be2\u5230\u76f8\u5339\u914d\u7684\u6570\u636e");
            retBo.setRespCode("112012");
            retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u76f8\u5339\u914d\u7684\u6570\u636e");
            return retBo;
        }
        Map<String, Map<String, String>> dicMap = this.queryTranslateMap();
        for (MmcRelShopSettingPo po : retPos) {
            this.assignData(po, data, dicMap);
        }
        retBo.setData(data);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private void assignData(MmcRelShopSettingPo po, List<MmcShopListQueryBusiDataBo> data, Map<String, Map<String, String>> dicMap) {
        MmcShopListQueryBusiDataBo busiDataBo = new MmcShopListQueryBusiDataBo();
        MmcRelShopChannelPo relShopChannelReqPo = new MmcRelShopChannelPo();
        relShopChannelReqPo.setType(MmcDictionaryValueConstants.REL_SHOP_CHANNEL_TYPE_SETTING);
        relShopChannelReqPo.setShopId(po.getShopId());
        relShopChannelReqPo.setSettingId(po.getSettingId());
        List<MmcRelShopChannelPo> relShopChannels = this.mmcRelShopChannelMapper.selectByCondition(relShopChannelReqPo);
        ArrayList<MmcShopChannelQueryAbilityDataBo> channelList = new ArrayList<MmcShopChannelQueryAbilityDataBo>();
        if (!CollectionUtils.isEmpty(relShopChannels)) {
            for (MmcRelShopChannelPo relShopChannelPo : relShopChannels) {
                MmcShopChannelQueryAbilityDataBo channelBo = new MmcShopChannelQueryAbilityDataBo();
                channelBo.setChannelId(relShopChannelPo.getChannel());
                channelBo.setChannelName(dicMap.get("SHOP_INFO_CHANNEL").get(relShopChannelPo.getChannel().toString()));
                channelList.add(channelBo);
            }
        }
        BeanUtils.copyProperties((Object)po, (Object)busiDataBo);
        busiDataBo.setStatus(po.getStatus());
        busiDataBo.setStatusName(dicMap.get("SHOP_INFO_STATUS").get(busiDataBo.getStatus().toString()));
        busiDataBo.setChannel(channelList);
        data.add(busiDataBo);
    }

    private void translateValue(List<MmcRelShopSettingPo> retPos, List<MmcShopListQueryBusiDataBo> data) {
    }

    private Map<String, Map<String, String>> queryTranslateMap() {
        HashMap<String, Map<String, String>> dicMap = new HashMap<String, Map<String, String>>(16);
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add("SHOP_INFO_CHANNEL");
        typeList.add("SHOP_INFO_STATUS");
        for (String type : typeList) {
            MmcDicMapQueryAtomReqBo dicMapReqBo = new MmcDicMapQueryAtomReqBo();
            dicMapReqBo.setType(type);
            MmcDicMapQueryAtomRspBo dicMapRetBo = this.mmcDicMapQueryAtomService.qryDicMap(dicMapReqBo);
            if (!"0000".equals(dicMapRetBo.getRespCode())) {
                this.LOGGER.error("\u67e5\u8be2type= '" + type + "'\u7684\u503c\u5931\u8d25");
                continue;
            }
            Map<String, String> valueMap = dicMapRetBo.getDicMap();
            dicMap.put(type, valueMap);
        }
        return dicMap;
    }

    private String validateArgs(MmcShopApproveListExportBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getQueryType())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'queryType'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

