/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.config;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.merchant.mmc.config.MmcPropertiesManager;
import com.tydic.merchant.mmc.enums.MmcPropertiesEnum;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class MmcCacheManager {
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private MmcPropertiesManager mmcPropertiesManager;
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private Set<String> cachedSet = new CopyOnWriteArraySet<String>();
    private int cacheTime = 15;
    private boolean usedCacheHighQuery = false;

    public void set(String key, Object obj) {
        if (this.usedCacheHighQuery) {
            this.cacheClient.set(key, obj, this.cacheTime * 60);
            this.cachedSet.add(key);
        }
        this.LOGGER.debug("\u7f13\u5b58\u6570\u636e\u5230redis\uff0ckey\u4e3a\uff1a" + key);
    }

    public <T> T get(String key, Class<T> clazz) {
        if (!this.usedCacheHighQuery) {
            return null;
        }
        return (T)this.cacheClient.get(key, clazz);
    }

    public void clearCache() {
        for (String cacheKey : this.cachedSet) {
            this.cacheClient.delete(cacheKey);
        }
        this.cachedSet.clear();
    }

    @PostConstruct
    public void init() {
        String cacheEnableStr = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.HIGH_QUERY_CACHE_ENABLE.getName());
        if (!StringUtils.isEmpty((Object)cacheEnableStr)) {
            this.usedCacheHighQuery = Boolean.parseBoolean(cacheEnableStr);
            if (this.usedCacheHighQuery) {
                this.LOGGER.info("\u9ad8\u9891\u67e5\u8be2\uff0c\u9700\u8981\u4f7f\u7528\u7f13\u5b58");
                String cacheStr = this.mmcPropertiesManager.getValue(MmcPropertiesEnum.HIGH_QUERY_CACHE_TIME.getName());
                if (!StringUtils.isEmpty((Object)cacheStr)) {
                    this.cacheTime = Integer.parseInt(cacheStr);
                }
                this.LOGGER.info("\u9ad8\u9891\u67e5\u8be2\uff0c\u7f13\u5b58\u65f6\u95f4\u4e3a" + this.cacheTime + "\u5206\u949f");
            } else {
                this.LOGGER.warn("\u9ad8\u9891\u67e5\u8be2\uff0c\u4e0d\u9700\u8981\u4f7f\u7528\u7f13\u5b58");
            }
        } else {
            this.LOGGER.warn("\u9ad8\u9891\u67e5\u8be2\uff0c\u4e0d\u9700\u8981\u4f7f\u7528\u7f13\u5b58");
        }
    }
}

