/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.busi.impl;

import com.tydic.merchant.mmc.ability.bo.MmcShopChannelQueryAbilityDataBo;
import com.tydic.merchant.mmc.atom.api.MmcDicMapQueryAtomService;
import com.tydic.merchant.mmc.atom.bo.MmcDicMapQueryAtomReqBo;
import com.tydic.merchant.mmc.atom.bo.MmcDicMapQueryAtomRspBo;
import com.tydic.merchant.mmc.busi.MmcShopDetailQueryBusiService;
import com.tydic.merchant.mmc.busi.bo.MmcShopDetailQueryBusiReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopDetailQueryBusiRspBo;
import com.tydic.merchant.mmc.constants.MmcDictionaryValueConstants;
import com.tydic.merchant.mmc.dao.MmcInfoShopMapper;
import com.tydic.merchant.mmc.dao.MmcRelShopChannelMapper;
import com.tydic.merchant.mmc.dao.MmcRelShopTemplateMapper;
import com.tydic.merchant.mmc.dao.po.MmcInfoShopPo;
import com.tydic.merchant.mmc.dao.po.MmcRelShopChannelPo;
import com.tydic.merchant.mmc.dao.po.MmcRelShopTemplatePo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class MmcShopDetailQueryBusiServiceImpl
implements MmcShopDetailQueryBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MmcInfoShopMapper mmcInfoShopMapper;
    @Autowired
    private MmcDicMapQueryAtomService mmcDicMapQueryAtomService;
    @Autowired
    private MmcRelShopChannelMapper mmcRelShopChannelMapper;
    @Autowired
    private MmcRelShopTemplateMapper mmcRelShopTemplateMapper;

    public MmcShopDetailQueryBusiRspBo queryShopDetail(MmcShopDetailQueryBusiReqBo reqBo) {
        this.LOGGER.info("\u5e97\u94fa\u8be6\u60c5\u67e5\u8be2busi\u670d\u52a1\uff1a" + reqBo);
        MmcShopDetailQueryBusiRspBo retBo = new MmcShopDetailQueryBusiRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("112003");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        MmcInfoShopPo reqPo = new MmcInfoShopPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)reqPo);
        if (StringUtils.isEmpty((Object)reqBo.getShopId())) {
            this.LOGGER.info("\u5e97\u94fa\u8be6\u60c5\u67e5\u8be2busi\u670d\u52a1shopId\u4e3a\u7a7a\u9700\u901a\u8fc7suppilerId\u67e5\u8be2\u51fa\u6765");
            MmcInfoShopPo shopIdPo = this.mmcInfoShopMapper.selectByShopIdOrSupplierId(reqPo);
            reqPo.setShopId(shopIdPo.getShopId());
        }
        MmcRelShopTemplatePo mmcRelShopTemplatePo = new MmcRelShopTemplatePo();
        BeanUtils.copyProperties((Object)reqPo, (Object)mmcRelShopTemplatePo);
        List<MmcRelShopTemplatePo> temolatePo = this.mmcRelShopTemplateMapper.selectByCondition(mmcRelShopTemplatePo);
        BeanUtils.copyProperties((Object)temolatePo.get(0), (Object)retBo);
        retBo.setTemplateId(temolatePo.get(0).getTemplateId().toString());
        this.translate(retBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        this.LOGGER.info("\u5e97\u94fa\u8be6\u60c5\u67e5\u8be2busi\u670d\u52a1\u8fd4\u56de\u7ed3\u679c\u4e3a\uff1a" + retBo);
        return retBo;
    }

    private void translate(MmcShopDetailQueryBusiRspBo retBo) {
        ArrayList<String> typeList = new ArrayList<String>();
        typeList.add("SHOP_INFO_CHANNEL");
        typeList.add("SHOP_INFO_STATUS");
        HashMap<String, Map<String, String>> transMap = new HashMap<String, Map<String, String>>(16);
        for (String type : typeList) {
            MmcDicMapQueryAtomReqBo mmcDicMapReqBo = new MmcDicMapQueryAtomReqBo();
            mmcDicMapReqBo.setType(type);
            MmcDicMapQueryAtomRspBo mmcDicMapRetBo = this.mmcDicMapQueryAtomService.qryDicMap(mmcDicMapReqBo);
            if (!"0000".equals(mmcDicMapRetBo.getRespCode())) {
                this.LOGGER.error("\u7ffb\u8bd1TYPE:" + type + "\u5931\u8d25");
                continue;
            }
            Map<String, String> valueMap = mmcDicMapRetBo.getDicMap();
            transMap.put(type, valueMap);
        }
        retBo.setStatusName((String)((Map)transMap.get("SHOP_INFO_STATUS")).get(retBo.getStatus().toString()));
        MmcRelShopChannelPo relShopChannelReqPo = new MmcRelShopChannelPo();
        relShopChannelReqPo.setShopId(retBo.getShopId());
        relShopChannelReqPo.setType(MmcDictionaryValueConstants.REL_SHOP_CHANNEL_TYPE_SELF);
        List<MmcRelShopChannelPo> relShopChannels = this.mmcRelShopChannelMapper.selectByCondition(relShopChannelReqPo);
        ArrayList<MmcShopChannelQueryAbilityDataBo> channelList = new ArrayList<MmcShopChannelQueryAbilityDataBo>();
        for (MmcRelShopChannelPo relShopChannelPo : relShopChannels) {
            MmcShopChannelQueryAbilityDataBo channelBo = new MmcShopChannelQueryAbilityDataBo();
            channelBo.setChannelId(relShopChannelPo.getChannel());
            channelBo.setChannelName((String)((Map)transMap.get("SHOP_INFO_CHANNEL")).get(relShopChannelPo.getChannel().toString()));
            channelList.add(channelBo);
        }
        retBo.setChannel(channelList);
    }

    private String validateArgs(MmcShopDetailQueryBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

