/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.busi.impl;

import com.tydic.merchant.mmc.busi.MmcShopContractSaleBusiService;
import com.tydic.merchant.mmc.busi.bo.MmcShopContractSaleBusiReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopContractSaleBusiRspBo;
import com.tydic.merchant.mmc.dao.MmcInfoShopMapper;
import com.tydic.merchant.mmc.dao.MmcShopSaleRelationMapper;
import com.tydic.merchant.mmc.dao.po.MmcInfoShopPo;
import com.tydic.merchant.mmc.dao.po.MmcShopSaleRelationPo;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="mmcShopContractSaleBusiService")
public class MmcShopContractSaleBusiServiceImpl
implements MmcShopContractSaleBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MmcInfoShopMapper mmcInfoShopMapper;
    @Autowired
    private MmcShopSaleRelationMapper mmcShopSaleRelationMapper;

    public MmcShopContractSaleBusiRspBo saveShopContractSale(MmcShopContractSaleBusiReqBo reqBo) {
        this.LOGGER.info("\u6570\u636e\u540c\u6b65busi\u670d\u52a1\uff1a" + reqBo);
        MmcShopContractSaleBusiRspBo retBo = new MmcShopContractSaleBusiRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("112005");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        MmcInfoShopPo reqPo = new MmcInfoShopPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)reqPo);
        MmcInfoShopPo shopIdPo = this.mmcInfoShopMapper.selectByShopIdOrSupplierId(reqPo);
        reqPo.setShopId(shopIdPo.getShopId());
        if (StringUtils.isEmpty((Object)reqPo.getShopId())) {
            retBo.setRespCode("0000");
            retBo.setRespDesc("suppilerId:" + reqPo.getSupplierId() + "\u5bf9\u5e94\u7684\u5e97\u94fashopId\u4e3a\u7a7a");
            return retBo;
        }
        this.mmcShopSaleRelationMapper.deleteByPrimaryKey(reqPo.getShopId());
        Date dbDate = this.mmcInfoShopMapper.getDbDate();
        MmcShopSaleRelationPo mmcShopSaleRelationPo = new MmcShopSaleRelationPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)mmcShopSaleRelationPo);
        mmcShopSaleRelationPo.setShopId(reqPo.getShopId());
        mmcShopSaleRelationPo.setUpdateTime(dbDate);
        this.mmcShopSaleRelationMapper.insert(mmcShopSaleRelationPo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validateArgs(MmcShopContractSaleBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getSupplierId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'supplierId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

