/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.busi.impl;

import com.tydic.merchant.mmc.atom.api.MmcDicMapQueryAtomService;
import com.tydic.merchant.mmc.atom.bo.MmcDicMapQueryAtomReqBo;
import com.tydic.merchant.mmc.atom.bo.MmcDicMapQueryAtomRspBo;
import com.tydic.merchant.mmc.busi.MmcFitmentMaterialGroupListBusiService;
import com.tydic.merchant.mmc.busi.bo.MmcFitmentMaterialGroupListBusiReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcFitmentMaterialGroupListBusiRspBo;
import com.tydic.merchant.mmc.constants.MmcConstants;
import com.tydic.merchant.mmc.dao.MmcFitmentRelMaterialShopGroupMapper;
import com.tydic.merchant.mmc.dao.po.MmcFitmentRelMaterialShopGroupPo;
import com.tydic.merchant.mmc.data.MmcFitmentMaterialGroupDataBo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="mmcFitmentMaterialGroupListBusiService")
public class MmcFitmentMaterialGroupListBusiServiceImpl
implements MmcFitmentMaterialGroupListBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MmcDicMapQueryAtomService mmcDicMapQueryAtomService;
    @Autowired
    private MmcFitmentRelMaterialShopGroupMapper mmcFitmentRelMaterialShopGroupMapper;

    public MmcFitmentMaterialGroupListBusiRspBo queryGroup(MmcFitmentMaterialGroupListBusiReqBo reqBo) {
        this.LOGGER.info("\u5e97\u94fa\u88c5\u4fee-\u7d20\u6750\u7ec4\u522b-\u67e5\u8be2 Busi\u670d\u52a1\uff1a" + reqBo);
        MmcFitmentMaterialGroupListBusiRspBo retBo = new MmcFitmentMaterialGroupListBusiRspBo();
        ArrayList<MmcFitmentMaterialGroupDataBo> groups = new ArrayList<MmcFitmentMaterialGroupDataBo>();
        retBo.setGroups(groups);
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("112022");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        MmcFitmentRelMaterialShopGroupPo qryReqPo = new MmcFitmentRelMaterialShopGroupPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)qryReqPo);
        List<MmcFitmentRelMaterialShopGroupPo> groupPoList = this.mmcFitmentRelMaterialShopGroupMapper.selectByCondition(qryReqPo);
        if (CollectionUtils.isEmpty(groupPoList)) {
            this.LOGGER.error("\u6839\u636e\u5165\u53c2\u6ca1\u6709\u67e5\u8be2\u5230\u5339\u914d\u7684\u7d20\u6750\u5206\u7ec4\u4fe1\u606f");
            retBo.setRespCode("112022");
            retBo.setRespDesc("\u6839\u636e\u5165\u53c2\u6ca1\u6709\u67e5\u8be2\u5230\u5339\u914d\u7684\u7d20\u6750\u5206\u7ec4\u4fe1\u606f");
            return retBo;
        }
        Map<String, Map<String, String>> dicMap = this.getDicMap();
        for (MmcFitmentRelMaterialShopGroupPo po : groupPoList) {
            MmcFitmentMaterialGroupDataBo groupDataBo = new MmcFitmentMaterialGroupDataBo();
            BeanUtils.copyProperties((Object)po, (Object)groupDataBo);
            groupDataBo.setDefaultGroupDesc(dicMap.get("MMC_FITMENT_MATERIAL_GROUP_DEFAULT").get(po.getDefaultGroup() + ""));
            groupDataBo.setGroupTypeDesc(dicMap.get("MMC_FITMENT_MATERIAL_GROUP_TYPE").get(po.getGroupType() + ""));
            groups.add(groupDataBo);
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private Map<String, Map<String, String>> getDicMap() {
        HashMap<String, Map<String, String>> dicMap = new HashMap<String, Map<String, String>>(16);
        MmcDicMapQueryAtomReqBo atomReqBo = new MmcDicMapQueryAtomReqBo();
        ArrayList<String> types = new ArrayList<String>();
        types.add("MMC_FITMENT_MATERIAL_GROUP_TYPE");
        types.add("MMC_FITMENT_MATERIAL_GROUP_DEFAULT");
        for (String type : types) {
            atomReqBo.setType(type);
            MmcDicMapQueryAtomRspBo atomRetBo = this.mmcDicMapQueryAtomService.qryDicMap(atomReqBo);
            dicMap.put(type, atomRetBo.getDicMap());
        }
        return dicMap;
    }

    private String validateArgs(MmcFitmentMaterialGroupListBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getShopId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'shopId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getGroupType())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'groupType'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return Arrays.asList(MmcConstants.TYPE_ARRAY).contains(reqBo.getGroupType()) ? null : "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'groupType'\u7684\u503c\u975e\u6cd5\uff0c\u5176\u503c\u53ea\u80fd\u4e3a[1 , 2, 3]";
    }
}

