/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.busi.impl;

import com.tydic.merchant.mmc.atom.api.MmcDicMapQueryAtomService;
import com.tydic.merchant.mmc.atom.bo.MmcDicMapQueryAtomReqBo;
import com.tydic.merchant.mmc.atom.bo.MmcDicMapQueryAtomRspBo;
import com.tydic.merchant.mmc.busi.MmcFitmentComponentPropertyListQueryBusiService;
import com.tydic.merchant.mmc.busi.MmcFitmentQueryChildComponentDetailBusiService;
import com.tydic.merchant.mmc.busi.bo.MmcFitmentComponentPropertyListQueryBusiReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcFitmentComponentPropertyListQueryBusiRspBo;
import com.tydic.merchant.mmc.busi.bo.MmcFitmentQueryChildComponentDetailBusiReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcFitmentQueryChildComponentDetailBusiRspBo;
import com.tydic.merchant.mmc.dao.MmcFitmentComponentConfigMapper;
import com.tydic.merchant.mmc.dao.MmcFitmentRelComponentParentMapper;
import com.tydic.merchant.mmc.dao.po.MmcFitmentComponentConfigPo;
import com.tydic.merchant.mmc.dao.po.MmcFitmentRelComponentParentPo;
import com.tydic.merchant.mmc.data.MmcFitmentChildrenComponentDataBo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="mmcFitmentQueryChildComponentDetailBusiService")
public class MmcFitmentQueryChildComponentDetailBusiServiceImpl
implements MmcFitmentQueryChildComponentDetailBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MmcFitmentRelComponentParentMapper mmcFitmentRelComponentParentMapper;
    @Autowired
    private MmcFitmentComponentConfigMapper mmcFitmentComponentConfigMapper;
    @Autowired
    private MmcDicMapQueryAtomService mmcDicMapQueryAtomService;
    @Autowired
    private MmcFitmentComponentPropertyListQueryBusiService mmcFitmentComponentPropertyListQueryBusiService;

    public MmcFitmentQueryChildComponentDetailBusiRspBo queryChildComponentDetail(MmcFitmentQueryChildComponentDetailBusiReqBo reqBo) {
        this.LOGGER.info("\u5e97\u94fa\u88c5\u4fee-\u67e5\u8be2\u5b50\u7ec4\u4ef6\u8be6\u60c5 busi\u670d\u52a1\uff1a" + reqBo);
        MmcFitmentQueryChildComponentDetailBusiRspBo retBo = new MmcFitmentQueryChildComponentDetailBusiRspBo();
        ArrayList<MmcFitmentChildrenComponentDataBo> childData = new ArrayList<MmcFitmentChildrenComponentDataBo>();
        retBo.setChildData(childData);
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("112035");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        List<MmcFitmentRelComponentParentPo> children = this.mmcFitmentRelComponentParentMapper.selectByParentCode(reqBo.getParentCode());
        if (CollectionUtils.isEmpty(children)) {
            this.LOGGER.error("\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u7ec4\u4ef6\u7684\u5b50\u7ec4\u4ef6");
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u7ec4\u4ef6\u7684\u5b50\u7ec4\u4ef6");
            return retBo;
        }
        ArrayList<String> types = new ArrayList<String>();
        types.add("MMC_FITMENT_COMPONENT_CONFIG_IS_TOP");
        types.add("MMC_FITMENT_COMPONENT_CONFIG_STATUS");
        Map<String, Map<String, String>> dicMap = this.getMap(types);
        MmcFitmentComponentConfigPo componentPo = null;
        MmcFitmentComponentPropertyListQueryBusiReqBo propertyQueryBusiReqBo = new MmcFitmentComponentPropertyListQueryBusiReqBo();
        MmcFitmentComponentPropertyListQueryBusiRspBo propertyQueryBusiRetBo = null;
        for (MmcFitmentRelComponentParentPo po : children) {
            MmcFitmentChildrenComponentDataBo dataBo = new MmcFitmentChildrenComponentDataBo();
            dataBo.setParentCode(po.getParentCode());
            dataBo.setDefaultCount(po.getDefaultCount());
            componentPo = this.mmcFitmentComponentConfigMapper.selectByPrimaryKey(po.getChildCode());
            if (componentPo == null) {
                this.LOGGER.error("\u67e5\u8be2\u5b50\u7ec4\u4ef6\u4fe1\u606f\u5931\u8d25");
                retBo.setRespCode("112035");
                retBo.setRespDesc("\u67e5\u8be2\u5b50\u7ec4\u4ef6\u4fe1\u606f\u5931\u8d25");
                return retBo;
            }
            BeanUtils.copyProperties((Object)componentPo, (Object)dataBo);
            dataBo.setComponentStatusDesc(dicMap.get("MMC_FITMENT_COMPONENT_CONFIG_STATUS").get(dataBo.getComponentStatus() + ""));
            dataBo.setTopComponentDesc(dicMap.get("MMC_FITMENT_COMPONENT_CONFIG_IS_TOP").get(dataBo.getTopComponent() + ""));
            propertyQueryBusiReqBo.setComponentCode(componentPo.getComponentCode());
            propertyQueryBusiRetBo = this.mmcFitmentComponentPropertyListQueryBusiService.queryProperty(propertyQueryBusiReqBo);
            if (!"0000".equals(propertyQueryBusiRetBo.getRespCode())) {
                this.LOGGER.error("\u67e5\u8be2\u5b50\u7ec4\u4ef6" + po.getChildCode() + "\u7684\u5c5e\u6027\u4fe1\u606f\u5931\u8d25");
                retBo.setRespCode("112035");
                retBo.setRespDesc("\u67e5\u8be2\u5b50\u7ec4\u4ef6" + componentPo.getComponentName() + "(\u7f16\u7801\uff1a" + componentPo.getComponentCode() + ")\u7684\u5c5e\u6027\u4fe1\u606f\u5931\u8d25");
                return retBo;
            }
            dataBo.setProperties(propertyQueryBusiRetBo.getData());
            childData.add(dataBo);
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private Map<String, Map<String, String>> getMap(List<String> types) {
        HashMap<String, Map<String, String>> dicMap = new HashMap<String, Map<String, String>>(16);
        MmcDicMapQueryAtomReqBo atomReqBo = new MmcDicMapQueryAtomReqBo();
        for (String type : types) {
            atomReqBo.setType(type);
            MmcDicMapQueryAtomRspBo atomRetBo = this.mmcDicMapQueryAtomService.qryDicMap(atomReqBo);
            dicMap.put(type, atomRetBo.getDicMap());
        }
        return dicMap;
    }

    private String validateArgs(MmcFitmentQueryChildComponentDetailBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParentCode())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027'parentCode'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

