/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.merchant.mmc.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.merchant.mmc.atom.api.MmcAuditRequestAtomService;
import com.tydic.merchant.mmc.atom.api.MmcShopChannelCreateAtomService;
import com.tydic.merchant.mmc.atom.bo.MmcAuditRequestAtomReqBo;
import com.tydic.merchant.mmc.atom.bo.MmcAuditRequestAtomRspBo;
import com.tydic.merchant.mmc.atom.bo.MmcShopChannelCreateAtomReqBo;
import com.tydic.merchant.mmc.atom.bo.MmcShopChannelCreateAtomRspBo;
import com.tydic.merchant.mmc.busi.MmcShopUpdateBusiService;
import com.tydic.merchant.mmc.busi.bo.MmcShopUpdateBusiReqBo;
import com.tydic.merchant.mmc.busi.bo.MmcShopUpdateBusiRspBo;
import com.tydic.merchant.mmc.dao.MmcInfoShopMapper;
import com.tydic.merchant.mmc.dao.MmcRelShopChannelMapper;
import com.tydic.merchant.mmc.dao.MmcRelShopTemplateMapper;
import com.tydic.merchant.mmc.dao.po.MmcInfoShopPo;
import com.tydic.merchant.mmc.dao.po.MmcRelShopChannelPo;
import com.tydic.merchant.mmc.dao.po.MmcRelShopTemplatePo;
import com.tydic.merchant.mmc.exception.MmcBusinessException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="mmcShopUpdateBusiService")
public class MmcShopUpdateBusiServiceImpl
implements MmcShopUpdateBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MmcInfoShopMapper mmcInfoShopMapper;
    @Autowired
    private MmcRelShopChannelMapper mmcRelShopChannelMapper;
    @Autowired
    private MmcRelShopTemplateMapper mmcRelShopTemplateMapper;
    @Autowired
    private MmcShopChannelCreateAtomService mmcShopChannelCreateAtomService;
    @Autowired
    private MmcAuditRequestAtomService mmcAuditRequestAtomService;
    @Value(value="${mmc.approval.shop.request.prokey}")
    private String shopRequestProKey;
    @Value(value="${CALL_PRC_SYS_CODE}")
    private String approvalSysCode;

    public MmcShopUpdateBusiRspBo updateShop(MmcShopUpdateBusiReqBo reqBo) {
        this.LOGGER.info("\u5e97\u94fa\u66f4\u65b0busi\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        MmcShopUpdateBusiRspBo rspBo = new MmcShopUpdateBusiRspBo();
        String validateArgStr = this.validateReqArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            rspBo.setRespCode("112008");
            rspBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return rspBo;
        }
        MmcInfoShopPo mmcInfoShopPo = new MmcInfoShopPo();
        if (reqBo.getShopId() != null && reqBo.getShopId() > 0L && (mmcInfoShopPo = this.mmcInfoShopMapper.selectByPrimaryKey(reqBo.getShopId())) == null) {
            rspBo.setRespCode("112008");
            rspBo.setRespDesc("\u5e97\u94fa\u4fe1\u606f" + reqBo.getShopId() + "\u4e0d\u5b58\u5728");
            return rspBo;
        }
        if (reqBo.getSupplierId() != null && reqBo.getSupplierId().length() > 0) {
            MmcInfoShopPo updateShopPo = new MmcInfoShopPo();
            BeanUtils.copyProperties((Object)reqBo, (Object)updateShopPo);
            mmcInfoShopPo = this.mmcInfoShopMapper.selectByShopIdOrSupplierId(updateShopPo);
            if (mmcInfoShopPo == null) {
                rspBo.setRespCode("112008");
                rspBo.setRespDesc("\u4f9b\u5e94\u5546\u4fe1\u606f" + reqBo.getSupplierId() + "\u4e0d\u5b58\u5728");
                return rspBo;
            }
        }
        if (reqBo.isAudit() && mmcInfoShopPo.getStatus() > Integer.parseInt("1")) {
            rspBo.setRespCode("112008");
            rspBo.setRespDesc("\u8be5\u5e97\u94fa\u4e0d\u80fd\u53d1\u8d77\u5f00\u5e97\u5ba1\u6279\uff0c\u72b6\u6001\u5df2\u7ecf\u5927\u4e8e\u5f00\u5e97\u7533\u8bf7\u4e2d");
            return rspBo;
        }
        Date dbDate = this.mmcInfoShopMapper.getDbDate();
        MmcInfoShopPo updateShopPo = new MmcInfoShopPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)updateShopPo);
        updateShopPo.setUpdateTime(dbDate);
        this.mmcInfoShopMapper.updateByPrimaryKeySelective(updateShopPo);
        reqBo.setShopId(mmcInfoShopPo.getShopId());
        Long shopId = reqBo.getShopId();
        MmcRelShopTemplatePo mmcRelShopTemplatePo = new MmcRelShopTemplatePo();
        BeanUtils.copyProperties((Object)reqBo, (Object)mmcRelShopTemplatePo);
        mmcRelShopTemplatePo.setUpdateTime(dbDate);
        mmcRelShopTemplatePo.setTemplateId(Long.valueOf(reqBo.getTemplateId()));
        this.LOGGER.info("\u66f4\u65b0\u5e97\u94fa\u6a21\u677f\u5173\u7cfb\u8868\u5165\u53c2\uff1a" + JSON.toJSONString((Object)mmcRelShopTemplatePo));
        this.mmcRelShopTemplateMapper.updateByShopId(mmcRelShopTemplatePo);
        List channels = reqBo.getChannel();
        if (channels != null && !channels.isEmpty()) {
            MmcRelShopChannelPo deleteRelPo = new MmcRelShopChannelPo();
            deleteRelPo.setShopId(shopId);
            deleteRelPo.setType(Integer.parseInt("1"));
            int deleteShopChannel = this.mmcRelShopChannelMapper.deleteByCondition(deleteRelPo);
            if (deleteShopChannel < 1) {
                throw new MmcBusinessException("116002", "\u5220\u9664\u5e97\u94fa-\u6e20\u9053\u5173\u7cfb\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            }
            MmcShopChannelCreateAtomReqBo createChannelBo = new MmcShopChannelCreateAtomReqBo();
            createChannelBo.setChannels(channels);
            createChannelBo.setCreateDate(dbDate);
            createChannelBo.setRemark("\u5e97\u94fa\u66f4\u65b0\u5199\u5165\u6e20\u9053");
            createChannelBo.setShopId(shopId);
            createChannelBo.setType("1");
            MmcShopChannelCreateAtomRspBo creteShopChannelRspBo = this.mmcShopChannelCreateAtomService.createShopChannel(createChannelBo);
            if (!"0000".equals(creteShopChannelRspBo.getRespCode())) {
                throw new MmcBusinessException("116002", "\u63d2\u5165\u5e97\u94fa-\u6e20\u9053\u9519\u8bef\uff1a" + creteShopChannelRspBo.getRespDesc());
            }
        }
        if (reqBo.isAudit()) {
            MmcAuditRequestAtomReqBo auditBo = this.assembleAuditBo(reqBo);
            MmcAuditRequestAtomRspBo auditRspBo = this.mmcAuditRequestAtomService.auditRequest(auditBo);
            if (!"0000".equals(auditRspBo.getRespCode())) {
                throw new MmcBusinessException("116003", "\u8c03\u7528\u5ba1\u6279\u670d\u52a1\u9519\u8bef\uff1a" + auditRspBo.getRespDesc());
            }
            MmcInfoShopPo updateShopBo = new MmcInfoShopPo();
            updateShopBo.setShopId(shopId);
            updateShopBo.setStatus(Integer.parseInt("2"));
            this.mmcInfoShopMapper.updateByPrimaryKeySelective(updateShopBo);
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)rspBo);
        rspBo.setCreateTime(mmcInfoShopPo.getCreateTime());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private MmcAuditRequestAtomReqBo assembleAuditBo(MmcShopUpdateBusiReqBo reqBo) {
        MmcAuditRequestAtomReqBo auditBo = new MmcAuditRequestAtomReqBo();
        auditBo.setProcDefKey(this.shopRequestProKey);
        auditBo.setSysCode(this.approvalSysCode);
        auditBo.setCreateOperId(reqBo.getCreateOper());
        auditBo.setCreateOperName(reqBo.getCreateOper());
        auditBo.setRemark("\u5e97\u94fa(" + reqBo.getShopId() + ")\u5f00\u5e97\u5ba1\u6279");
        auditBo.setObjId(reqBo.getShopId().toString());
        auditBo.setObjType(Integer.parseInt("1"));
        auditBo.setObjCode(reqBo.getShopId().toString());
        auditBo.setObjName(reqBo.getShopId().toString() + "_Name");
        return auditBo;
    }

    private String validateReqArg(MmcShopUpdateBusiReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBo.getShopId() == null && reqBo.getSupplierId() == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027shopId\u4e0esupplierId\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a";
        }
        return null;
    }
}

