/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.extend.api;

public class BytesUtils {
    private static final int HALF_MAX = 0x3FFFFFFF;

    public static String toHex(byte b) {
        String str = Integer.toHexString(b & 0xFF);
        return str.length() == 1 ? '0' + str : str;
    }

    public static String toHex(byte[] arrB) {
        if (arrB == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(arrB.length * 2);
        for (byte b : arrB) {
            sb.append(BytesUtils.toHex(b));
        }
        return sb.toString();
    }

    public static byte toByte(String str) {
        return (byte)Integer.parseInt(str, 16);
    }

    public static byte[] toBytes(String str) {
        if (str == null) {
            return null;
        }
        int strLen = str.length();
        if (strLen > 0x3FFFFFFF) {
            throw new IllegalArgumentException("str len too large");
        }
        int length = strLen / 2;
        byte[] arrOut = new byte[length];
        for (int i = 0; i < length; ++i) {
            int idx = i << 1;
            arrOut[i] = BytesUtils.toByte(str.substring(idx, idx + 2));
        }
        return arrOut;
    }
}

