/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.api.bo.eums;

public enum QuestionType {
    CHOICE_S("2001", "\u5355\u9009\u9898"),
    CHOICE_M("2002", "\u591a\u9009\u9898"),
    FILL_BLANK("2003", "\u586b\u7a7a\u9898"),
    TRUE_FALSE("2004", "\u5224\u65ad\u9898"),
    QA_MIN("2005", "\u7b80\u7b54\u9898"),
    QA_MAX("2006", "\u8bba\u8ff0\u9898");

    private String code;
    private String name;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private QuestionType(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static String getNameByCode(String code) {
        for (QuestionType field : QuestionType.values()) {
            if (!field.code.equals(code)) continue;
            return field.name;
        }
        return "";
    }

    public static String getCodeByName(String name) {
        for (QuestionType field : QuestionType.values()) {
            if (!field.name.equals(name)) continue;
            return field.code;
        }
        return "";
    }

    public static boolean isFillBlank(String questionType) {
        return FILL_BLANK.getCode().equals(questionType);
    }

    public static boolean isChoice(String questionType) {
        return CHOICE_S.getCode().equals(questionType) || CHOICE_M.getCode().equals(questionType);
    }

    public static boolean isJudgment(String questionType) {
        return TRUE_FALSE.getCode().equals(questionType);
    }

    public static boolean isQA(String questionType) {
        return TRUE_FALSE.getCode().equals(questionType) || QA_MIN.getCode().equals(questionType) || QA_MAX.getCode().equals(questionType);
    }
}

