/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.api.bo.eums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum LanguageType {
    CHINESE("\u4e2d\u6587", "Chinese", "cmn"),
    SPANISH("\u897f\u73ed\u7259\u8bed", "Spanish", "spa"),
    ENGLISH("\u82f1\u8bed", "English", "eng"),
    RUSSIAN("\u4fc4\u8bed", "Russian", "rus"),
    ARABIC("\u963f\u62c9\u4f2f\u8bed", "Arabic", "arb"),
    BENGALI("\u5b5f\u52a0\u62c9\u8bed", "Bengali", "ben"),
    HINDI("\u5370\u5730\u8bed", "Hindi", "hin"),
    PORTUGUESE("\u8461\u8404\u7259\u8bed", "Portuguese", "por"),
    INDONESIAN("\u5370\u5c3c\u8bed", "Indonesian", "ind"),
    JAPANESE("\u65e5\u8bed", "Japanese", "jpn"),
    FRENCH("\u6cd5\u8bed", "French", "fra"),
    GERMAN("\u5fb7\u8bed", "German", "deu"),
    JAVANESE("\u722a\u54c7\u8bed", "Javanese", "jav"),
    KOREAN("\u97e9\u8bed", "Korean", "kor"),
    TELUGU("\u6cf0\u5362\u56fa\u8bed", "Telugu", "tel"),
    VIETNAMESE("\u8d8a\u5357\u8bed", "Vietnamese", "vie"),
    MARATHI("\u9a6c\u62c9\u5730\u8bed", "Marathi", "mar"),
    ITALIAN("\u610f\u5927\u5229\u8bed", "Italian", "ita"),
    TAMIL("\u6cf0\u7c73\u5c14\u8bed", "Tamil", "tam"),
    TURKISH("\u571f\u8033\u5176\u8bed", "Turkish", "tur"),
    URDU("\u4e4c\u5c14\u90fd\u8bed", "Urdu", "urd"),
    GUJARATI("\u53e4\u5409\u62c9\u7279\u8bed", "Gujarati", "guj"),
    POLISH("\u6ce2\u5170\u8bed", "Polish", "pol"),
    UKRAINIAN("\u4e4c\u514b\u5170\u8bed", "Ukrainian", "ukr"),
    KANNADA("\u5361\u7eb3\u8fbe\u8bed", "Kannada", "kan"),
    MAITHILI("\u8fc8\u8482\u5229\u8bed", "Maithili", "mai"),
    MALAYALAM("\u9a6c\u62c9\u96c5\u62c9\u59c6\u8bed", "Malayalam", "mal"),
    PERSIAN("\u6ce2\u65af\u8bed", "Persian", "pes"),
    BURMESE("\u7f05\u7538\u8bed", "Burmese", "mya"),
    SWAHILI("\u65af\u74e6\u5e0c\u91cc\u8bed", "Swahili", "swh"),
    SUNDANESE("\u5dfd\u4ed6\u8bed", "Sundanese", "sun"),
    ROMANIAN("\u7f57\u9a6c\u5c3c\u4e9a\u8bed", "Romanian", "ron"),
    PANJABI("\u65c1\u906e\u666e\u8bed", "Panjabi", "pan"),
    BHOJPURI("\u535a\u6770\u666e\u5c14\u8bed", "Bhojpuri", "bho"),
    AMHARIC("\u963f\u59c6\u54c8\u62c9\u8bed", "Amharic", "amh"),
    HAUSA("\u8c6a\u8428\u8bed", "Hausa", "hau"),
    FULFULDE("\u5bcc\u62c9\u5c3c\u8bed", "Fulfulde", "fuv"),
    BOSNIAN("\u6ce2\u65af\u5c3c\u4e9a\u8bed", "Bosnian", "bos"),
    CROATIAN("\u514b\u7f57\u5730\u4e9a\u8bed", "Croatian", "hrv"),
    DUTCH("\u8377\u5170\u8bed", "Dutch", "nld"),
    SERBIAN("\u585e\u5c14\u7ef4\u4e9a\u8bed", "Serbian", "srp"),
    THAI("\u6cf0\u8bed", "Thai", "tha"),
    KURDISH("\u5e93\u5c14\u5fb7\u8bed", "Kurdish", "ckb"),
    YORUBA("\u7ea6\u9c81\u5df4\u8bed", "Yoruba", "yor"),
    UZBEK("\u4e4c\u5179\u522b\u514b\u8bed", "Uzbek", "uzn"),
    MALAY("\u9a6c\u6765\u8bed", "Malay", "zlm"),
    IGBO("\u4f0a\u535a\u8bed", "Igbo", "ibo");

    private final String chineseName;
    private final String englishName;
    private final String languageCode;

    private LanguageType(String chineseName, String englishName, String languageCode) {
        this.chineseName = chineseName;
        this.englishName = englishName;
        this.languageCode = languageCode;
    }

    public String getChineseName() {
        return this.chineseName;
    }

    public String getEnglishName() {
        return this.englishName;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public static Map<String, String> getLanguageMap() {
        return Arrays.stream(LanguageType.values()).collect(Collectors.toMap(LanguageType::getChineseName, LanguageType::getLanguageCode, (oldValue, newValue) -> oldValue));
    }

    public static Map<String, String> getLanguageDisplayMap() {
        return Arrays.stream(LanguageType.values()).collect(Collectors.toMap(LanguageType::getChineseName, LanguageType::getEnglishName, (oldValue, newValue) -> oldValue));
    }

    public static LanguageType getByCode(String code) {
        if (code == null) {
            return null;
        }
        return Arrays.stream(LanguageType.values()).filter(language -> code.equals(language.getLanguageCode())).findFirst().orElse(null);
    }
}

