/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.api.validation;

import com.tydic.nbchat.train.api.validation.ValidEnum;
import java.lang.reflect.Method;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidEnumValidator
implements ConstraintValidator<ValidEnum, String> {
    private static final Logger log = LoggerFactory.getLogger(ValidEnumValidator.class);
    private Class<? extends Enum<?>> enumClass;
    private String validateMethodName;

    public void initialize(ValidEnum annotation) {
        this.enumClass = annotation.enumClass();
        this.validateMethodName = annotation.methodName();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return true;
        }
        try {
            Method validateMethod = this.enumClass.getMethod(this.validateMethodName, String.class);
            Object result = validateMethod.invoke(null, value);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            log.warn("\u679a\u4e3e\u6821\u9a8c\u65b9\u6cd5 {}#{} \u8fd4\u56de\u503c\u4e0d\u662f boolean \u7c7b\u578b", (Object)this.enumClass.getSimpleName(), (Object)this.validateMethodName);
            return false;
        }
        catch (Exception e) {
            log.error("\u679a\u4e3e\u6821\u9a8c\u5f02\u5e38: \u679a\u4e3e\u7c7b {} \u6ca1\u6709\u627e\u5230\u65b9\u6cd5 {}(String) \u6216\u65b9\u6cd5\u8c03\u7528\u5931\u8d25", new Object[]{this.enumClass.getSimpleName(), this.validateMethodName, e});
            return false;
        }
    }
}

