/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.report.promotion;

import com.alibaba.fastjson.JSON;
import com.tydic.nbchat.train.mapper.po.RpSearchLog;
import com.tydic.nbchat.train.report.promotion.bo.AccountTokenBO;
import com.tydic.nbchat.train.report.promotion.bo.PromotionTypeEnum;
import com.tydic.nicc.common.nbchat.exception.CommonBusiException;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AppService {
    private static final Logger log = LoggerFactory.getLogger(AppService.class);
    protected final String REDIS_KEY_TOKEN = "nbchat-train:report:promotion:token:" + this.getAppType();

    public abstract String getAppType();

    public abstract RedisHelper getRedisHelper();

    public String getAccessToken(String appId) {
        String accountTokenJson = (String)this.getRedisHelper().hget(this.REDIS_KEY_TOKEN, appId);
        AccountTokenBO accountToken = StringUtils.isBlank((CharSequence)accountTokenJson) ? this.refreshToken(appId) : (AccountTokenBO)JSON.parseObject((String)accountTokenJson, AccountTokenBO.class);
        if (accountToken.getExpiresTime().before(new Date())) {
            accountToken = this.refreshToken(appId);
        }
        return accountToken.getAccessToken();
    }

    public abstract void doRefreshToken(String var1);

    public void refreshAllTokens() {
        Map accountTokenMap = this.getRedisHelper().hmget(this.REDIS_KEY_TOKEN);
        accountTokenMap.keySet().forEach(appId -> this.doRefreshToken((String)appId));
    }

    public List<PromotionTypeEnum> getPromotionType() {
        return List.of(PromotionTypeEnum.ALL_PROMOTION_TYPE);
    }

    public RspList<RpSearchLog> findRpSearchLog(PromotionTypeEnum promotionType, int page) {
        return this.findRpSearchLog(DateTimeUtil.DateAdd((Date)DateTimeUtil.getStartTimeOfDay(), (int)6, (int)-1), promotionType, page);
    }

    public RspList<RpSearchLog> findRpSearchLog(Date date, PromotionTypeEnum promotionType, int page) {
        return this.findRpSearchLog(date, date, promotionType, page);
    }

    public abstract RspList<RpSearchLog> findRpSearchLog(Date var1, Date var2, PromotionTypeEnum var3, int var4);

    private AccountTokenBO refreshToken(String appId) {
        this.doRefreshToken(appId);
        String accountTokenJson = (String)this.getRedisHelper().hget(this.REDIS_KEY_TOKEN, appId);
        if (StringUtils.isBlank((CharSequence)accountTokenJson)) {
            log.error("\u4e09\u65b9\u6388\u6743accessToken\u83b7\u53d6\u5931\u8d25\uff0cappType\uff1a{}, appId\uff1a{}", (Object)this.getAppType(), (Object)appId);
            throw new CommonBusiException("\u4e09\u65b9\u6388\u6743accessToken\u83b7\u53d6\u5931\u8d25");
        }
        return (AccountTokenBO)JSON.parseObject((String)accountTokenJson, AccountTokenBO.class);
    }
}

