/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.report.promotion.baidu;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.tydic.nbchat.train.mapper.po.RpSearchLog;
import com.tydic.nbchat.train.report.promotion.AppService;
import com.tydic.nbchat.train.report.promotion.baidu.AESUtils;
import com.tydic.nbchat.train.report.promotion.baidu.bo.ApplicationBO;
import com.tydic.nbchat.train.report.promotion.baidu.bo.BaiduCallbackBO;
import com.tydic.nbchat.train.report.promotion.bo.AccountTokenBO;
import com.tydic.nbchat.train.report.promotion.bo.AppServiceEnum;
import com.tydic.nbchat.train.report.promotion.bo.PromotionTypeEnum;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.http.RestApiHelper;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.crypto.SecretKey;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BaiduAppService
extends AppService {
    private static final Logger log = LoggerFactory.getLogger(BaiduAppService.class);
    private static final String AES_OFFSET = "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000";
    private static final String ACCESS_TOKEN_URL = "https://u.baidu.com/oauth/accessToken";
    private static final String REFRESH_TOKEN_URL = "https://u.baidu.com/oauth/refreshToken";
    private static final String REPORT_DATA_URL = "https://api.baidu.com/json/sms/service/OpenApiReportService/getReportData";
    @Value(value="${nbchat-train.promotion.baidu.reportDataAppId:25adbf552e5f1e4add8cb8eef92622ac}")
    private String reportDataAppId;
    @Value(value="${nbchat-train.promotion.baidu.appConfig:[{\"appId\":\"25adbf552e5f1e4add8cb8eef92622ac\",\"appName\":\"\u641c\u7d22\u62a5\u8868\u67e5\u8be2\",\"userId\":56734782,\"userName\":\"\u5929\u6e90\u8fea\u79d12024\",\"secretKey\":\"f724f13c00c8babb39fd3280142fe306\"}]}")
    private String appConfigProperties;
    @Value(value="${nbchat-train.promotion.baidu.limit:200}")
    private int limit;
    private Map<String, ApplicationBO> appConfigMap = new HashMap<String, ApplicationBO>();
    @Resource
    private RedisHelper redisHelper;
    @Resource
    private RestApiHelper restApiHelper;

    @PostConstruct
    public void init() {
        List applications = JSON.parseArray((String)this.appConfigProperties, ApplicationBO.class);
        this.appConfigMap = applications.stream().collect(Collectors.toMap(ApplicationBO::getAppId, value -> value));
    }

    @Override
    public String getAppType() {
        return AppServiceEnum.BAIDU.getCode();
    }

    @Override
    public RedisHelper getRedisHelper() {
        return this.redisHelper;
    }

    public String callback(BaiduCallbackBO param) {
        log.info("\u767e\u5ea6\u8425\u9500\u56de\u8c03\u4fe1\u606f {}", (Object)JSON.toJSONString((Object)param));
        if (StringUtils.isBlank((CharSequence)param.getSignature())) {
            return this.getResponseJson(600011, "\u53c2\u6570\u9519\u8bef", null);
        }
        ApplicationBO app = this.getAppByAppId(param.getAppId());
        if (!this.checkState(param.getAppId(), app.getUserId(), param.getState())) {
            log.info("callback: state check fail");
            return this.getResponseJson(600011, "\u72b6\u6001\u7801\u9519\u8bef", null);
        }
        if (!this.checkSignature(param, app.getSecretKey())) {
            log.info("callback: signature check fail");
            return this.getResponseJson(600011, "\u7b7e\u540d\u9519\u8bef", null);
        }
        String accessToken = this.doAccessToken(param, app.getSecretKey(), param.getUserIdLong());
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return this.getResponseJson(600011, "\u672a\u83b7\u53d6\u5230 access_token", null);
        }
        return this.getResponseJson(0, "success", accessToken);
    }

    private String doAccessToken(BaiduCallbackBO param, String secretKey, Long userId) {
        String responseJson;
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("appId", param.getAppId());
        request.put("userId", userId);
        request.put("authCode", param.getAuthCode());
        request.put("secretKey", secretKey);
        request.put("grantType", "auth_code");
        try {
            log.info("\u83b7\u53d6\u767e\u5ea6\u6388\u6743\u4ee4\u724c\u5f00\u59cb\uff1a{}", (Object)JSON.toJSONString(request));
            responseJson = this.restApiHelper.post(ACCESS_TOKEN_URL, request);
            log.info("\u83b7\u53d6\u767e\u5ea6\u6388\u6743\u4ee4\u724c\u7ed3\u675f\uff1a{}", (Object)responseJson);
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u767e\u5ea6\u6388\u6743\u4ee4\u724c\u5931\u8d25", (Throwable)e);
            return null;
        }
        JSONObject response = JSON.parseObject((String)responseJson);
        if (response.getInteger("code") != 0) {
            log.warn("\u672a\u83b7\u53d6\u5230\u767e\u5ea6\u6388\u6743\u4ee4\u724c\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)response.getString("message"));
            return null;
        }
        AccountTokenBO data = this.saveAccountTokenInRedis(response.getJSONObject("data"), param.getAppId());
        return data.getAccessToken();
    }

    @Override
    public void doRefreshToken(String appId) {
        String responseJson;
        log.info("\u3010\u767e\u5ea6\u8425\u9500\u3011\u5237\u65b0accessToken\uff1a{}", (Object)appId);
        String accountTokenJson = (String)this.getRedisHelper().hget(this.REDIS_KEY_TOKEN, appId);
        if (StringUtils.isBlank((CharSequence)accountTokenJson)) {
            log.error("\u767e\u5ea6\u8425\u9500\u5237\u65b0accessToken\u9700\u8981\u6709\u751f\u6548\u72b6\u6001\u7684refreshToken\u5b57\u6bb5\uff0c\u5f53\u524d\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u6388\u6743, appId\uff1a{}", (Object)appId);
            return;
        }
        AccountTokenBO accountToken = (AccountTokenBO)JSON.parseObject((String)accountTokenJson, AccountTokenBO.class);
        if (accountToken.getRefreshExpiresTime().before(new Date())) {
            log.error("\u767e\u5ea6\u8425\u9500\u5237\u65b0accessToken\u9700\u8981\u6709\u751f\u6548\u72b6\u6001\u7684refreshToken\u5b57\u6bb5\uff0c\u5f53\u524d\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u6388\u6743, appId\uff1a{}", (Object)appId);
            return;
        }
        ApplicationBO application = this.getAppByAppId(appId);
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("appId", appId);
        request.put("secretKey", application.getSecretKey());
        request.put("userId", accountToken.getUserId());
        request.put("refreshToken", accountToken.getRefreshToken());
        try {
            log.info("\u66f4\u65b0\u767e\u5ea6\u6388\u6743\u4ee4\u724c\u5f00\u59cb\uff1a{}", (Object)JSON.toJSONString(request));
            responseJson = this.restApiHelper.post(REFRESH_TOKEN_URL, request);
            log.info("\u66f4\u65b0\u767e\u5ea6\u6388\u6743\u4ee4\u724c\u7ed3\u675f\uff1a{}", (Object)responseJson);
        }
        catch (Exception e) {
            log.warn("\u66f4\u65b0\u767e\u5ea6\u6388\u6743\u4ee4\u724c\u5931\u8d25", (Throwable)e);
            return;
        }
        JSONObject response = JSON.parseObject((String)responseJson);
        if (response.getInteger("code") != 0) {
            log.warn("\u672a\u66f4\u65b0\u5230\u767e\u5ea6\u6388\u6743\u4ee4\u724c\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)response.getString("message"));
            return;
        }
        this.saveAccountTokenInRedis(response.getJSONObject("data"), appId);
    }

    @Override
    public List<PromotionTypeEnum> getPromotionType() {
        return List.of(PromotionTypeEnum.COMPUTER, PromotionTypeEnum.MOBILE);
    }

    @Override
    public RspList<RpSearchLog> findRpSearchLog(Date startDate, Date endDate, PromotionTypeEnum promotionType, int page) {
        String responseJson;
        log.info("\u3010\u767e\u5ea6\u8425\u9500\u3011\u67e5\u627e\u641c\u7d22\u65e5\u5fd7\u8bb0\u5f55\uff1astartDate-{}, endDate-{}, page-{}", new Object[]{startDate, endDate, page});
        if (page < 1) {
            page = 1;
        }
        int offset = (page - 1) * this.limit;
        ApplicationBO application = this.getAppByAppId(this.reportDataAppId);
        HashMap<String, Object> filter = new HashMap<String, Object>();
        if (promotionType != null && !PromotionTypeEnum.ALL_PROMOTION_TYPE.equals((Object)promotionType)) {
            filter.put("column", "device");
            filter.put("operator", "EQ");
            filter.put("values", List.of(promotionType.getBaiduType()));
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("accessToken", this.getAccessToken(this.reportDataAppId));
        header.put("userName", application.getUserName());
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("reportType", 2307838);
        body.put("startDate", DateTimeUtil.getTimeShortString((Date)startDate, (String)"yyyy-MM-dd"));
        body.put("endDate", DateTimeUtil.getTimeShortString((Date)endDate, (String)"yyyy-MM-dd"));
        body.put("timeUnit", "DAY");
        body.put("filters", List.of(filter));
        body.put("columns", List.of("device", "queryWord", "date", "campaignName", "adGroupName", "wInfoNameStatus", "impression", "click", "cost", "ctr", "cpc", "mixWmatchEnum"));
        body.put("startRow", offset);
        body.put("rowCount", this.limit);
        HashMap<String, HashMap<String, Object>> request = new HashMap<String, HashMap<String, Object>>();
        request.put("header", header);
        request.put("body", body);
        try {
            log.info("\u67e5\u627e\u641c\u7d22\u65e5\u5fd7\u8bb0\u5f55\u5f00\u59cb\uff1a{}", (Object)JSON.toJSONString(request));
            responseJson = this.restApiHelper.post(REPORT_DATA_URL, request);
            log.info("\u67e5\u627e\u641c\u7d22\u65e5\u5fd7\u8bb0\u5f55\u7ed3\u675f\uff1a{}", (Object)responseJson);
        }
        catch (Exception e) {
            log.warn("\u67e5\u627e\u641c\u7d22\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
            return BaseRspUtils.createErrorRspList((String)"\u67e5\u627e\u641c\u7d22\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25");
        }
        JSONObject response = JSON.parseObject((String)responseJson);
        if (response.getJSONObject("header").getInteger("status") != 0) {
            log.warn("\u67e5\u627e\u641c\u7d22\u65e5\u5fd7\u8bb0\u5f55\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)response.getString("header"));
            return BaseRspUtils.createErrorRspList((String)"\u67e5\u627e\u641c\u7d22\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25");
        }
        JSONObject data = response.getJSONObject("body").getJSONArray("data").getJSONObject(0);
        long totalCount = data.getLongValue("totalRowCount");
        long count = data.getLongValue("rowCount");
        ArrayList<RpSearchLog> rpSearchLogs = new ArrayList<RpSearchLog>();
        JSONArray rows = data.getJSONArray("rows");
        int i = 0;
        while ((long)i < count) {
            String device;
            JSONObject row = rows.getJSONObject(i);
            String sources = promotionType != null && !PromotionTypeEnum.ALL_PROMOTION_TYPE.equals((Object)promotionType) ? "\u767e\u5ea6".concat(promotionType.getDesc()) : ("\u8ba1\u7b97\u673a".equals(device = row.getString("device")) ? "\u767e\u5ea6PC\u7aef" : ("".equals(device) ? "\u767e\u5ea6\u79fb\u52a8\u7aef" : "\u767e\u5ea6"));
            RpSearchLog rpSearchLog = new RpSearchLog();
            rpSearchLog.setSources(sources);
            rpSearchLog.setTerm(row.getString("queryWord"));
            rpSearchLog.setDayData(DateTimeUtil.convertAsDate((String)row.getString("date")));
            rpSearchLog.setPlanScheme(row.getString("campaignName"));
            rpSearchLog.setKeywordGroups(row.getString("adGroupName"));
            rpSearchLog.setKeyword(row.getString("wInfoNameStatus"));
            rpSearchLog.setImpressions(Integer.valueOf(row.getIntValue("impression")));
            rpSearchLog.setClick(Integer.valueOf(row.getIntValue("click")));
            rpSearchLog.setConsumption(Integer.valueOf(row.getBigDecimal("cost").multiply(BigDecimal.valueOf(100L)).intValue()));
            rpSearchLog.setClickRate(Integer.valueOf(row.getBigDecimal("ctr").multiply(BigDecimal.valueOf(10000L)).intValue()));
            rpSearchLog.setAvgClickPrice(Integer.valueOf(row.getBigDecimal("cpc").multiply(BigDecimal.valueOf(100L)).intValue()));
            rpSearchLog.setMatchMode(row.getString("mixWmatchEnum"));
            rpSearchLogs.add(rpSearchLog);
            ++i;
        }
        return BaseRspUtils.createSuccessRspList(rpSearchLogs, (long)totalCount);
    }

    private ApplicationBO getAppByAppId(String appId) {
        return this.appConfigMap.get(appId);
    }

    private AccountTokenBO saveAccountTokenInRedis(JSONObject data, String appId) {
        AccountTokenBO accountToken = AccountTokenBO.builder().accessToken(data.getString("accessToken")).refreshToken(data.getString("refreshToken")).expiresTime(DateTimeUtil.convertAsDate((String)data.getString("expiresTime"))).refreshExpiresTime(DateTimeUtil.convertAsDate((String)data.getString("refreshExpiresTime"))).userId(data.getString("userId")).openId(data.getString("openId")).build();
        this.redisHelper.hset(this.REDIS_KEY_TOKEN, appId, (Object)JSON.toJSONString((Object)accountToken));
        return accountToken;
    }

    private String getResponseJson(int code, String message, String accessToken) {
        HashMap<String, String> data = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)accessToken)) {
            data.put("accessToken", accessToken);
        }
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put("code", code);
        responseMap.put("message", message);
        responseMap.put("data", data);
        return JSON.toJSONString(responseMap);
    }

    private boolean checkState(String appId, Long userId, String state) {
        try {
            String md5State = appId.concat("_").concat(String.valueOf(userId));
            String newState = MD5Utils.md5Hex((byte[])md5State.getBytes());
            return newState.equals(state);
        }
        catch (NoSuchAlgorithmException e) {
            log.warn("token \u8ba1\u7b97md5\u5f02\u5e38:", (Throwable)e);
            return false;
        }
    }

    private boolean checkSignature(BaiduCallbackBO param, String secretKey) {
        String sign = this.paramsSign(secretKey, param.toSignatureString());
        log.info("baidu callback: signature = {}", (Object)sign);
        return param.getSignature().equals(sign);
    }

    private String paramsSign(String secretKey, String signatureString) {
        byte[] bytes = Base64.getEncoder().encode(signatureString.getBytes(StandardCharsets.UTF_8));
        SecretKey keyAES = AESUtils.loadKeyAES(secretKey.substring(0, 16));
        return AESUtils.encryptAES(bytes, keyAES, AES_OFFSET);
    }
}

