/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nbchat.train.report.promotion.bing;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nbchat.train.mapper.po.RpSearchLog;
import com.tydic.nbchat.train.report.promotion.AppService;
import com.tydic.nbchat.train.report.promotion.bing.BingReportUtils;
import com.tydic.nbchat.train.report.promotion.bing.bo.ApplicationBO;
import com.tydic.nbchat.train.report.promotion.bing.bo.BingCallbackBO;
import com.tydic.nbchat.train.report.promotion.bing.config.BingPromotionConfigProperties;
import com.tydic.nbchat.train.report.promotion.bo.AccountTokenBO;
import com.tydic.nbchat.train.report.promotion.bo.AppServiceEnum;
import com.tydic.nbchat.train.report.promotion.bo.PromotionTypeEnum;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.http.RestApiHelper;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;

@Service
public class BingAppService
extends AppService {
    private static final Logger log = LoggerFactory.getLogger(BingAppService.class);
    private static final String OAUTH_TOKEN_URL = "https://login.microsoftonline.com/common/oauth2/v2.0/token";
    @Resource
    private BingPromotionConfigProperties bingPromotionConfigProperties;
    private Map<String, ApplicationBO> appConfigMap = new HashMap<String, ApplicationBO>();
    @Resource
    private RedisHelper redisHelper;
    @Resource
    private RestApiHelper restApiHelper;

    @PostConstruct
    public void init() {
        log.info("\u3010Bing\u914d\u7f6e\u3011\u914d\u7f6e\u5c5e\u6027\u5bf9\u8c61: {}", (Object)JSON.toJSONString((Object)this.bingPromotionConfigProperties));
        log.info("\u3010Bing\u914d\u7f6e\u3011reportDataCustomerId: {}", (Object)this.bingPromotionConfigProperties.getReportDataCustomerId());
        log.info("\u3010Bing\u914d\u7f6e\u3011limit: {}", (Object)this.bingPromotionConfigProperties.getLimit());
        List<ApplicationBO> applications = this.bingPromotionConfigProperties.getAppConfig();
        log.info("\u3010Bing\u914d\u7f6e\u3011\u5e94\u7528\u914d\u7f6e\u5217\u8868: {}", (Object)JSON.toJSONString(applications));
        if (applications != null && !applications.isEmpty()) {
            this.appConfigMap = applications.stream().collect(Collectors.toMap(ApplicationBO::getCustomerId, value -> value));
            log.info("\u3010Bing\u914d\u7f6e\u3011\u5e94\u7528\u914d\u7f6eMap keys: {}", this.appConfigMap.keySet());
        } else {
            log.warn("\u3010Bing\u914d\u7f6e\u3011\u5e94\u7528\u914d\u7f6e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6");
        }
    }

    @Override
    public String getAppType() {
        return AppServiceEnum.BING.getCode();
    }

    @Override
    public RedisHelper getRedisHelper() {
        return this.redisHelper;
    }

    public String callback(BingCallbackBO param) {
        log.info("Bing OAuth\u56de\u8c03\u4fe1\u606f: {}", (Object)JSON.toJSONString((Object)param));
        if (param.hasError()) {
            log.error("Bing OAuth\u6388\u6743\u5931\u8d25: {} - {}", (Object)param.getError(), (Object)param.getError_description());
            return this.getResponseJson(600011, "\u6388\u6743\u5931\u8d25: " + param.getError_description(), null);
        }
        if (!param.isSuccess()) {
            log.error("Bing OAuth\u56de\u8c03\u53c2\u6570\u4e0d\u5b8c\u6574: {}", (Object)JSON.toJSONString((Object)param));
            return this.getResponseJson(600011, "\u56de\u8c03\u53c2\u6570\u4e0d\u5b8c\u6574", null);
        }
        String customerId = this.parseCustomerIdFromState(param.getState());
        if (StringUtils.isBlank((CharSequence)customerId)) {
            log.error("Bing OAuth state\u9a8c\u8bc1\u5931\u8d25\u6216\u65e0\u6cd5\u89e3\u6790customerId: {}", (Object)param.getState());
            return this.getResponseJson(600011, "\u72b6\u6001\u9a8c\u8bc1\u5931\u8d25", null);
        }
        ApplicationBO application = this.getAppByCustomerId(customerId);
        if (application == null) {
            log.error("\u672a\u627e\u5230customerId\u5bf9\u5e94\u7684\u5e94\u7528\u914d\u7f6e: {}", (Object)customerId);
            return this.getResponseJson(600011, "\u5e94\u7528\u914d\u7f6e\u4e0d\u5b58\u5728", null);
        }
        String accessToken = this.doAccessToken(param.getCode(), application);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return this.getResponseJson(600011, "\u672a\u83b7\u53d6\u5230 access_token", null);
        }
        return this.getResponseJson(0, "success", accessToken);
    }

    private String doAccessToken(String authCode, ApplicationBO application) {
        try {
            log.info("\u3010Bing OAuth\u3011\u5f00\u59cb\u6362\u53d6\u8bbf\u95ee\u4ee4\u724c\uff0ccustomerId: {}", (Object)application.getCustomerId());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("grant_type", "authorization_code");
            params.put("client_id", application.getClientId());
            params.put("client_secret", application.getClientSecret());
            params.put("code", authCode);
            params.put("redirect_uri", this.bingPromotionConfigProperties.getRedirectUri());
            params.put("scope", "https://ads.microsoft.com/msads.manage offline_access");
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/x-www-form-urlencoded");
            String formData = params.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("&"));
            String responseJson = this.restApiHelper.post(OAUTH_TOKEN_URL, formData, headers, new MediaType[0]);
            log.info("\u3010Bing OAuth\u3011\u6362\u53d6\u8bbf\u95ee\u4ee4\u724c\u54cd\u5e94: {}", (Object)responseJson);
            JSONObject response = JSON.parseObject((String)responseJson);
            if (response.containsKey((Object)"error")) {
                log.error("\u3010Bing OAuth\u3011\u6362\u53d6\u8bbf\u95ee\u4ee4\u724c\u5931\u8d25: {}", (Object)response.getString("error_description"));
                return null;
            }
            AccountTokenBO accountToken = this.saveAccountTokenInRedis(response, application.getCustomerId());
            return accountToken.getAccessToken();
        }
        catch (Exception e) {
            log.error("\u3010Bing OAuth\u3011\u6362\u53d6\u8bbf\u95ee\u4ee4\u724c\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    private AccountTokenBO saveAccountTokenInRedis(JSONObject tokenResponse, String customerId) {
        int expiresIn = tokenResponse.getIntValue("expires_in");
        Date expiresTime = DateTimeUtil.DateAddSecond((int)(expiresIn - 300));
        Date refreshExpiresTime = DateTimeUtil.DateAddDayOfYear((int)90);
        AccountTokenBO accountToken = AccountTokenBO.builder().accessToken(tokenResponse.getString("access_token")).refreshToken(tokenResponse.getString("refresh_token")).expiresTime(expiresTime).refreshExpiresTime(refreshExpiresTime).userId(customerId).openId(customerId).build();
        log.info("redisToken:{}", (Object)this.REDIS_KEY_TOKEN);
        this.redisHelper.hset(this.REDIS_KEY_TOKEN, customerId, (Object)JSON.toJSONString((Object)accountToken));
        String redis = (String)this.redisHelper.hget(this.REDIS_KEY_TOKEN, customerId);
        log.info("redis:{}", (Object)redis);
        log.info("\u3010Bing OAuth\u3011Token\u4fdd\u5b58\u6210\u529f\uff0ccustomerId: {}", (Object)customerId);
        return accountToken;
    }

    private String parseCustomerIdFromState(String state) {
        if (StringUtils.isBlank((CharSequence)state)) {
            return null;
        }
        try {
            String[] parts = state.split("_");
            if (parts.length >= 3 && "bing".equals(parts[0])) {
                return parts[1];
            }
        }
        catch (Exception e) {
            log.warn("\u89e3\u6790state\u5931\u8d25: {}", (Object)state, (Object)e);
        }
        return null;
    }

    public String generateAuthUrl(String customerId) {
        ApplicationBO application = this.getAppByCustomerId(customerId);
        if (application == null) {
            log.error("\u672a\u627e\u5230customerId\u5bf9\u5e94\u7684\u5e94\u7528\u914d\u7f6e: {}", (Object)customerId);
            return null;
        }
        String state = "bing_" + customerId + "_" + System.currentTimeMillis();
        String authUrl = "https://login.microsoftonline.com/common/oauth2/v2.0/authorize?client_id=" + application.getClientId() + "&response_type=code&redirect_uri=" + this.bingPromotionConfigProperties.getRedirectUri() + "&scope=https://ads.microsoft.com/msads.manage offline_access&state=" + state;
        log.info("\u3010Bing OAuth\u3011\u751f\u6210\u6388\u6743URL\uff0ccustomerId: {}, authUrl: {}", (Object)customerId, (Object)authUrl);
        return authUrl;
    }

    private String getResponseJson(int code, String message, String data) {
        JSONObject response = new JSONObject();
        response.put("code", (Object)code);
        response.put("message", (Object)message);
        response.put("data", (Object)data);
        return response.toJSONString();
    }

    @Override
    public void doRefreshToken(String customerId) {
        log.info("\u3010Bing\u5e7f\u544a\u3011\u5237\u65b0accessToken\uff1a{}", (Object)customerId);
        log.info("customerId:{}", (Object)customerId);
        String accountTokenJson = (String)this.getRedisHelper().hget(this.REDIS_KEY_TOKEN, customerId);
        log.info("redisToken:{}|{}", (Object)this.REDIS_KEY_TOKEN, (Object)accountTokenJson);
        if (StringUtils.isBlank((CharSequence)accountTokenJson)) {
            log.error("Bing\u5e7f\u544a\u5237\u65b0accessToken\u9700\u8981\u6709\u751f\u6548\u72b6\u6001\u7684refreshToken\u5b57\u6bb51\uff0c\u5f53\u524d\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u6388\u6743, customerId\uff1a{}", (Object)customerId);
            return;
        }
        AccountTokenBO accountToken = (AccountTokenBO)JSON.parseObject((String)accountTokenJson, AccountTokenBO.class);
        if (accountToken.getRefreshExpiresTime().before(new Date())) {
            log.error("Bing\u5e7f\u544a\u5237\u65b0accessToken\u9700\u8981\u6709\u751f\u6548\u72b6\u6001\u7684refreshToken\u5b57\u6bb52\uff0c\u5f53\u524d\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u6388\u6743, customerId\uff1a{}", (Object)customerId);
            return;
        }
        ApplicationBO application = this.getAppByCustomerId(customerId);
        if (application == null) {
            log.error("Bing\u5e7f\u544a\u5237\u65b0accessToken\u5931\u8d25\uff0c\u672a\u627e\u5230customerId\u5bf9\u5e94\u7684\u5e94\u7528\u914d\u7f6e: {}", (Object)customerId);
            return;
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("grant_type", "refresh_token");
            params.put("client_id", application.getClientId());
            params.put("client_secret", application.getClientSecret());
            params.put("refresh_token", accountToken.getRefreshToken());
            params.put("scope", "https://ads.microsoft.com/msads.manage offline_access");
            HttpHeaders headers = new HttpHeaders();
            headers.set("Content-Type", "application/x-www-form-urlencoded");
            String formData = params.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("&"));
            String responseJson = this.restApiHelper.post(OAUTH_TOKEN_URL, formData, headers, new MediaType[0]);
            log.info("\u3010Bing\u5e7f\u544a\u3011\u5237\u65b0accessToken\u54cd\u5e94: {}", (Object)responseJson);
            JSONObject response = JSON.parseObject((String)responseJson);
            if (response.containsKey((Object)"error")) {
                log.error("\u3010Bing\u5e7f\u544a\u3011\u5237\u65b0accessToken\u5931\u8d25: {}", (Object)response.getString("error_description"));
                return;
            }
            this.saveAccountTokenInRedis(response, customerId);
            log.info("\u3010Bing\u5e7f\u544a\u3011\u5237\u65b0accessToken\u6210\u529f\uff1a{}", (Object)customerId);
        }
        catch (Exception e) {
            log.error("\u3010Bing\u5e7f\u544a\u3011\u5237\u65b0accessToken\u5f02\u5e38", (Throwable)e);
        }
    }

    @Override
    public RspList<RpSearchLog> findRpSearchLog(Date startDate, Date endDate, PromotionTypeEnum promotionType, int page) {
        return this.findRpSearchLogWithRestApi(startDate, endDate, promotionType, page);
    }

    public RspList<RpSearchLog> findRpSearchLogWithRestApi(Date startDate, Date endDate, PromotionTypeEnum promotionType, int page) {
        String reportRequestId;
        log.info("\u3010Bing\u5e7f\u544a\u3011\u4f7f\u7528 RestApiHelper \u67e5\u627e\u641c\u7d22\u65e5\u5fd7\u8bb0\u5f55\uff1astartDate-{}, endDate-{}, promotionType-{}, page-{}", new Object[]{startDate, endDate, promotionType, page});
        if (this.bingPromotionConfigProperties == null) {
            log.error("Bing\u63a8\u5e7f\u914d\u7f6e\u4e3a\u7a7a");
            return BaseRspUtils.createErrorRspList((String)"Bing\u63a8\u5e7f\u914d\u7f6e\u4e3a\u7a7a");
        }
        String reportDataCustomerId = this.bingPromotionConfigProperties.getReportDataCustomerId();
        if (StringUtils.isBlank((CharSequence)reportDataCustomerId)) {
            log.error("Bing\u62a5\u544a\u6570\u636e\u5ba2\u6237ID\u4e3a\u7a7a");
            return BaseRspUtils.createErrorRspList((String)"Bing\u62a5\u544a\u6570\u636e\u5ba2\u6237ID\u4e3a\u7a7a");
        }
        ApplicationBO application = this.getAppByCustomerId(reportDataCustomerId);
        if (application == null) {
            log.error("Bing\u5e7f\u544a\u67e5\u627e\u641c\u7d22\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25\uff0c\u672a\u627e\u5230customerId\u5bf9\u5e94\u7684\u5e94\u7528\u914d\u7f6e: {}", (Object)reportDataCustomerId);
            return BaseRspUtils.createErrorRspList((String)("\u5e94\u7528\u914d\u7f6e\u4e0d\u5b58\u5728\uff0ccustomerId: " + reportDataCustomerId));
        }
        String accessToken = this.getAccessToken(reportDataCustomerId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.error("\u83b7\u53d6\u8bbf\u95ee\u4ee4\u724c\u5931\u8d25\uff0ccustomerId: {}", (Object)reportDataCustomerId);
            return BaseRspUtils.createErrorRspList((String)"\u83b7\u53d6\u8bbf\u95ee\u4ee4\u724c\u5931\u8d25");
        }
        String deviceFilter = null;
        if (promotionType != null && !PromotionTypeEnum.ALL_PROMOTION_TYPE.equals((Object)promotionType)) {
            deviceFilter = promotionType.getBingType();
        }
        if (StringUtils.isBlank((CharSequence)(reportRequestId = BingReportUtils.submitReportRequestWithRestApi(this.restApiHelper, application.getCustomerId(), application.getCustomerAccountId(), application.getDeveloperToken(), accessToken, startDate, endDate, deviceFilter)))) {
            log.error("\u3010Bing\u5e7f\u544a\u3011\u63d0\u4ea4\u62a5\u544a\u8bf7\u6c42\u5931\u8d25");
            return BaseRspUtils.createErrorRspList((String)"\u63d0\u4ea4\u62a5\u544a\u8bf7\u6c42\u5931\u8d25");
        }
        log.info("\u3010Bing\u5e7f\u544a\u3011\u6210\u529f\u83b7\u53d6\u62a5\u544a\u8bf7\u6c42ID: {}", (Object)reportRequestId);
        return this.pollAndDownloadReportWithRestApi(application, accessToken, reportRequestId, promotionType);
    }

    private RspList<RpSearchLog> pollAndDownloadReportWithRestApi(ApplicationBO application, String accessToken, String reportRequestId, PromotionTypeEnum promotionType) {
        try {
            log.info("\u3010Bing\u5e7f\u544a\u3011\u4f7f\u7528 RestApiHelper \u5f00\u59cb\u8f6e\u8be2\u62a5\u544a\u72b6\u6001\uff0creportRequestId: {}", (Object)reportRequestId);
            int maxAttempts = 30;
            for (int attempt = 0; attempt < maxAttempts; ++attempt) {
                Thread.sleep(10000L);
                BingReportUtils.ReportStatus status = BingReportUtils.pollReportStatusWithRestApi(this.restApiHelper, application.getCustomerId(), application.getCustomerAccountId(), application.getDeveloperToken(), accessToken, reportRequestId);
                if (status == null) {
                    log.error("\u3010Bing\u5e7f\u544a\u3011\u8f6e\u8be2\u62a5\u544a\u72b6\u6001\u5931\u8d25 (\u7b2c{}\u6b21)", (Object)attempt);
                    if (attempt < maxAttempts) continue;
                    return BaseRspUtils.createErrorRspList((String)"\u8f6e\u8be2\u62a5\u544a\u72b6\u6001\u5931\u8d25");
                }
                log.info("\u3010Bing\u5e7f\u544a\u3011\u62a5\u544a\u72b6\u6001: {}, \u4e0b\u8f7dURL: {}", (Object)status.getStatus(), (Object)status.getDownloadUrl());
                if (status.isSuccess()) {
                    if (StringUtils.isNotBlank((CharSequence)status.getDownloadUrl())) {
                        log.info("\u3010Bing\u5e7f\u544a\u3011\u62a5\u544a\u751f\u6210\u6210\u529f\uff0c\u5f00\u59cb\u4e0b\u8f7d: {}", (Object)status.getDownloadUrl());
                        return this.downloadAndParseReport(status.getDownloadUrl(), promotionType);
                    }
                    log.info("\u3010Bing\u5e7f\u544a\u3011\u62a5\u544a\u751f\u6210\u6210\u529f\uff0c\u65e0\u62a5\u544a\u6570\u636e");
                    return BaseRspUtils.createErrorRspList((String)"\u65e0\u62a5\u544a\u6570\u636e");
                }
                if (status.isError()) {
                    log.error("\u3010Bing\u5e7f\u544a\u3011\u62a5\u544a\u751f\u6210\u5931\u8d25\uff0c\u72b6\u6001: {}", (Object)status.getStatus());
                    return BaseRspUtils.createErrorRspList((String)"\u62a5\u544a\u751f\u6210\u5931\u8d25");
                }
                if (status.isPending()) {
                    log.info("\u3010Bing\u5e7f\u544a\u3011\u62a5\u544a\u6b63\u5728\u751f\u6210\u4e2d\uff0c\u7ee7\u7eed\u7b49\u5f85... (\u7b2c{}\u6b21)", (Object)attempt);
                    continue;
                }
                log.warn("\u3010Bing\u5e7f\u544a\u3011\u672a\u77e5\u7684\u62a5\u544a\u72b6\u6001: {}", (Object)status.getStatus());
            }
            log.error("\u3010Bing\u5e7f\u544a\u3011\u62a5\u544a\u751f\u6210\u8d85\u65f6\uff0c\u5df2\u5c1d\u8bd5{}\u6b21", (Object)maxAttempts);
            return BaseRspUtils.createErrorRspList((String)"\u62a5\u544a\u751f\u6210\u8d85\u65f6");
        }
        catch (Exception e) {
            log.error("\u3010Bing\u5e7f\u544a\u3011\u8f6e\u8be2\u62a5\u544a\u72b6\u6001\u5931\u8d25", (Throwable)e);
            return BaseRspUtils.createErrorRspList((String)("\u8f6e\u8be2\u62a5\u544a\u72b6\u6001\u5931\u8d25: " + e.getMessage()));
        }
    }

    private RspList<RpSearchLog> downloadAndParseReport(String downloadUrl, PromotionTypeEnum promotionType) {
        try {
            log.info("\u3010Bing\u5e7f\u544a\u3011\u5f00\u59cb\u4e0b\u8f7d\u62a5\u544a\u6570\u636e\uff0cURL: {}", (Object)downloadUrl);
            List<String[]> csvData = BingReportUtils.downloadCsvReport(downloadUrl);
            log.info("\u3010Bing\u5e7f\u544a\u3011\u6210\u529f\u4e0b\u8f7dCSV\u6570\u636e\uff0c\u884c\u6570: {}", (Object)csvData.size());
            ArrayList<RpSearchLog> rpSearchLogs = new ArrayList<RpSearchLog>();
            int skippedRows = 0;
            for (int i = 0; i < csvData.size(); ++i) {
                Object[] row = csvData.get(i);
                try {
                    RpSearchLog rpSearchLog = this.parseCsvRow((String[])row, promotionType);
                    if (rpSearchLog != null) {
                        rpSearchLogs.add(rpSearchLog);
                        continue;
                    }
                    ++skippedRows;
                    continue;
                }
                catch (Exception e) {
                    log.warn("\u3010Bing\u5e7f\u544a\u3011\u89e3\u6790CSV\u7b2c{}\u884c\u5931\u8d25: {}", new Object[]{i + 1, Arrays.toString(row), e});
                    ++skippedRows;
                }
            }
            log.info("\u3010Bing\u5e7f\u544a\u3011CSV\u89e3\u6790\u5b8c\u6210 - \u603b\u884c\u6570: {}, \u6210\u529f\u89e3\u6790: {}, \u8df3\u8fc7\u884c\u6570: {}", new Object[]{csvData.size(), rpSearchLogs.size(), skippedRows});
            log.info("\u3010Bing\u5e7f\u544a\u3011\u6210\u529f\u89e3\u6790\u641c\u7d22\u65e5\u5fd7\u8bb0\u5f55\u6570: {}", (Object)rpSearchLogs.size());
            return BaseRspUtils.createSuccessRspList(rpSearchLogs);
        }
        catch (Exception e) {
            log.error("\u3010Bing\u5e7f\u544a\u3011\u4e0b\u8f7d\u5e76\u89e3\u6790\u62a5\u544a\u6570\u636e\u5931\u8d25", (Throwable)e);
            return BaseRspUtils.createErrorRspList((String)("\u4e0b\u8f7d\u5e76\u89e3\u6790\u62a5\u544a\u6570\u636e\u5931\u8d25: " + e.getMessage()));
        }
    }

    private RpSearchLog parseCsvRow(String[] row, PromotionTypeEnum promotionType) {
        try {
            if (row == null || row.length < 12) {
                log.warn("\u3010Bing\u5e7f\u544a\u3011CSV\u884c\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u671f\u671b\u81f3\u5c1112\u5217\uff0c\u5b9e\u9645{}\u5217: {}", (Object)(row != null ? row.length : 0), (Object)Arrays.toString(row));
                return null;
            }
            if (this.isHeaderRow(row)) {
                log.warn("\u3010Bing\u5e7f\u544a\u3011\u68c0\u6d4b\u5230\u8868\u5934\u884c\uff0c\u8df3\u8fc7: {}", (Object)Arrays.toString(row));
                return null;
            }
            RpSearchLog rpSearchLog = new RpSearchLog();
            String timePeriod = row[0];
            if (StringUtils.isNotBlank((CharSequence)timePeriod)) {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    rpSearchLog.setDayData(sdf.parse(timePeriod));
                }
                catch (Exception e) {
                    log.warn("\u3010Bing\u5e7f\u544a\u3011\u89e3\u6790\u65e5\u671f\u5931\u8d25: {}", (Object)timePeriod);
                    rpSearchLog.setDayData(new Date());
                }
            } else {
                rpSearchLog.setDayData(new Date());
            }
            String sources = "Bing";
            rpSearchLog.setSources(sources);
            rpSearchLog.setTerm(row[1]);
            rpSearchLog.setPlanScheme(row[2]);
            rpSearchLog.setKeywordGroups(row[3]);
            rpSearchLog.setKeyword(row[4]);
            rpSearchLog.setImpressions(Integer.valueOf(this.parseIntValue(row[5])));
            rpSearchLog.setClick(Integer.valueOf(this.parseIntValue(row[6])));
            BigDecimal spend = this.parseBigDecimalValue(row[7]);
            rpSearchLog.setConsumption(Integer.valueOf(spend.multiply(BigDecimal.valueOf(100L)).intValue()));
            BigDecimal ctr = this.parseBigDecimalValue(row[8].replace("%", ""));
            rpSearchLog.setClickRate(Integer.valueOf(ctr.multiply(BigDecimal.valueOf(100L)).intValue()));
            BigDecimal avgCpc = this.parseBigDecimalValue(row[9]);
            rpSearchLog.setAvgClickPrice(Integer.valueOf(avgCpc.multiply(BigDecimal.valueOf(100L)).intValue()));
            rpSearchLog.setMatchMode(row[11]);
            return rpSearchLog;
        }
        catch (Exception e) {
            log.error("\u3010Bing\u5e7f\u544a\u3011\u89e3\u6790CSV\u884c\u6570\u636e\u5931\u8d25: {}", (Object)Arrays.toString(row), (Object)e);
            return null;
        }
    }

    private boolean isHeaderRow(String[] row) {
        if (row == null || row.length == 0) {
            return false;
        }
        String firstColumn = row[0];
        if ("TimePeriod".equalsIgnoreCase(firstColumn)) {
            return true;
        }
        for (String cell : row) {
            if (!"SearchQuery".equalsIgnoreCase(cell) && !"CampaignName".equalsIgnoreCase(cell) && !"AdGroupName".equalsIgnoreCase(cell) && !"Impressions".equalsIgnoreCase(cell) && !"DeliveredMatchType".equalsIgnoreCase(cell)) continue;
            return true;
        }
        return false;
    }

    private int parseIntValue(String value) {
        if (StringUtils.isBlank((CharSequence)value) || "--".equals(value)) {
            return 0;
        }
        try {
            return Integer.parseInt(value.replace(",", ""));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private BigDecimal parseBigDecimalValue(String value) {
        if (StringUtils.isBlank((CharSequence)value) || "--".equals(value)) {
            return BigDecimal.ZERO;
        }
        try {
            return new BigDecimal(value.replace(",", ""));
        }
        catch (NumberFormatException e) {
            return BigDecimal.ZERO;
        }
    }

    public ApplicationBO getAppByCustomerId(String customerId) {
        return this.appConfigMap.get(customerId);
    }

    public String testSubmitReportRequestWithRestApi(String customerId, Date startDate, Date endDate, String deviceFilter) {
        log.info("\u3010Bing\u5e7f\u544a\u3011\u6d4b\u8bd5RestApiHelper\u63d0\u4ea4\u62a5\u544a\u8bf7\u6c42\uff0ccustomerId: {}", (Object)customerId);
        ApplicationBO application = this.getAppByCustomerId(customerId);
        if (application == null) {
            log.error("\u672a\u627e\u5230customerId\u5bf9\u5e94\u7684\u5e94\u7528\u914d\u7f6e: {}", (Object)customerId);
            return null;
        }
        String accessToken = this.getAccessToken(customerId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.error("\u83b7\u53d6\u8bbf\u95ee\u4ee4\u724c\u5931\u8d25\uff0ccustomerId: {}", (Object)customerId);
            return null;
        }
        return BingReportUtils.submitReportRequestWithRestApi(this.restApiHelper, application.getCustomerId(), application.getCustomerAccountId(), application.getDeveloperToken(), accessToken, startDate, endDate, deviceFilter);
    }

    public BingReportUtils.ReportStatus testPollReportStatusWithRestApi(String customerId, String reportRequestId) {
        log.info("\u3010Bing\u5e7f\u544a\u3011\u6d4b\u8bd5RestApiHelper\u8f6e\u8be2\u62a5\u544a\u72b6\u6001\uff0ccustomerId: {}, reportRequestId: {}", (Object)customerId, (Object)reportRequestId);
        ApplicationBO application = this.getAppByCustomerId(customerId);
        if (application == null) {
            log.error("\u672a\u627e\u5230customerId\u5bf9\u5e94\u7684\u5e94\u7528\u914d\u7f6e: {}", (Object)customerId);
            return null;
        }
        String accessToken = this.getAccessToken(customerId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.error("\u83b7\u53d6\u8bbf\u95ee\u4ee4\u724c\u5931\u8d25\uff0ccustomerId: {}", (Object)customerId);
            return null;
        }
        return BingReportUtils.pollReportStatusWithRestApi(this.restApiHelper, application.getCustomerId(), application.getCustomerAccountId(), application.getDeveloperToken(), accessToken, reportRequestId);
    }
}

